/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestShowStats
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)HiveQueryRunner.builder().setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)).setNodeCount(1)).build();
    }

    @BeforeClass
    public void setUp() {
        this.assertUpdate("CREATE TABLE nation_partitioned(nationkey BIGINT, name VARCHAR, comment VARCHAR, regionkey BIGINT) WITH (partitioned_by = ARRAY['regionkey'])");
        this.assertUpdate("INSERT INTO nation_partitioned SELECT nationkey, name, comment, regionkey FROM tpch.tiny.nation", 25L);
        this.assertUpdate("CREATE TABLE region AS SELECT * FROM tpch.tiny.region", 5L);
        this.assertUpdate("CREATE TABLE orders AS SELECT * FROM tpch.tiny.orders", 15000L);
    }

    @Test
    public void testShowStats() {
        this.assertQuery("SHOW STATS FOR nation_partitioned", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 25.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned)", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 25.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey IS NOT NULL)", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 25.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey IS NULL)", "VALUES    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    (null, null, null, null, 0.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey = 1)", "VALUES    ('regionkey', null, 1.0, 0.0, null, 1, 1),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    ('name', 38.0, 5.0, 0.0, null, null, null),    ('comment', 500.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 5.0, null, null)");
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", "SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey = ?)").build();
        this.assertQuery(session, "EXECUTE my_query USING 1", "VALUES    ('regionkey', null, 1.0, 0.0, null, 1, 1),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    ('name', 38.0, 5.0, 0.0, null, null, null),    ('comment', 500.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 5.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey IN (1, 3))", "VALUES    ('regionkey', null, 2.0, 0.0, null, 1, 3),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    ('name', 78.0, 5.0, 0.0, null, null, null),    ('comment', 847.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 10.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey BETWEEN 1 AND 1 + 2)", "VALUES    ('regionkey', null, 3.0, 0.0, null, 1, 3),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    ('name', 109.0, 5.0, 0.0, null, null, null),    ('comment', 1199.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 15.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey > 3)", "VALUES    ('regionkey', null, 1.0, 0.0, null, 4, 4),    ('nationkey', null, 5.0, 0.0, null, 4, 20),    ('name', 31.0, 5.0, 0.0, null, null, null),    ('comment', 348.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 5.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey < 1)", "VALUES    ('regionkey', null, 1.0, 0.0, null, 0, 0),    ('nationkey', null, 5.0, 0.0, null, 0, 16),    ('name', 37.0, 5.0, 0.0, null, null, null),    ('comment', 310.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 5.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey > 0 and regionkey < 4)", "VALUES    ('regionkey', null, 3.0, 0.0, null, 1, 3),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    ('name', 109.0, 5.0, 0.0, null, null, null),    ('comment', 1199.0, 5.0, 0.0, null, null, null),    (null, null, null, null, 15.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey > 10 or regionkey < 0)", "VALUES    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    (null, null, null, null, 0.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT *, * FROM nation_partitioned WHERE regionkey > 10 or regionkey < 0)", "VALUES    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    (null, null, null, null, 0.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT *, *, regionkey FROM nation_partitioned WHERE regionkey > 10 or regionkey < 0)", "VALUES    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    ('nationkey', 0.0, 0.0, 1.0, null, null, null),    ('name', 0.0, 0.0, 1.0, null, null, null),    ('comment', 0.0, 0.0, 1.0, null, null, null),    ('regionkey', 0.0, 0.0, 1.0, null, null, null),    (null, null, null, null, 0.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT *, regionkey FROM nation_partitioned)", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857.0, 5.0, 0.0, null, null, null),    ('regionkey', null, 5.0, 0.0, null, 0, 4),    (null, null, null, null, 25.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT *, * FROM nation_partitioned)", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857, 5.0, 0.0, null, null, null),    ('regionkey', null, 5.0, 0.0, null, 0, 4),    ('nationkey', null, 5.0, 0.0, null, 0, 24),    ('name', 177.0, 5.0, 0.0, null, null, null),    ('comment', 1857.0, 5.0, 0, null, null, null),    (null, null, null, null, 25.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT regionkey FROM nation_partitioned WHERE regionkey BETWEEN 1 AND 1 + 2)", "VALUES    ('regionkey', null, 3.0, 0.0, null, 1, 3),    (null, null, null, null, 15.0, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT regionkey, nationkey FROM nation_partitioned WHERE regionkey BETWEEN 1 AND 1 + 2)", "VALUES    ('regionkey', null, 3.0, 0.0, null, 1, 3),    ('nationkey', null, 5.0, 0.0, null, 1, 24),    (null, null, null, null, 15.0, null, null)");
    }

    @Test
    public void testShowStatsWithBoolean() {
        this.assertQuery("SHOW STATS FOR (VALUES true)", "VALUES    ('_col0', null, 1, 0, null, 'true', 'true'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES false)", "VALUES    ('_col0', null, 1, 0, null, 'false', 'false'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES true, false)", "VALUES    ('_col0', null, 2, 0, null, 'false', 'true'),    (null, null, null, null, 2, null, null)");
    }

    @Test
    public void testShowStatsWithTimestamp() {
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00', '2021-07-20 16:52:00'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123', '2021-07-20 16:52:00.123'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123456')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123456', '2021-07-20 16:52:00.123456'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123456789')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123456', '2021-07-20 16:52:00.123456'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123456789012')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123456', '2021-07-20 16:52:00.123456'),    (null, null, null, null, 1, null, null)");
    }

    @Test
    public void testShowStatsWithTimestampWithTimeZone() {
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00 UTC')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00 UTC', '2021-07-20 16:52:00 UTC'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123 UTC')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123 UTC', '2021-07-20 16:52:00.123 UTC'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123999 UTC')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123 UTC', '2021-07-20 16:52:00.123 UTC'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123999999 UTC')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123 UTC', '2021-07-20 16:52:00.123 UTC'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123999999999 UTC')", "VALUES    ('_col0', null, 1, 0, null, '2021-07-20 16:52:00.123 UTC', '2021-07-20 16:52:00.123 UTC'),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (VALUES TIMESTAMP '2021-07-20 16:52:00.123456789 Europe/Warsaw', TIMESTAMP '2021-07-20 16:52:00.123456789 America/Los_Angeles')", "VALUES    ('_col0', null, 2, 0, null, '2021-07-20 14:52:00.123 UTC', '2021-07-20 23:52:00.123 UTC'),    (null, null, null, null, 2, null, null)");
    }

    @Test
    public void testShowStatsWithoutFrom() {
        this.assertQuery("SHOW STATS FOR (SELECT 1 AS x)", "VALUES    ('x', null, 1.0, 0.0, null, 1, 1),    (null, null, null, null, 1.0, null, null)");
    }

    @Test
    public void testShowStatsWithMultipleFrom() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned, region)", "VALUES    ('nationkey', null, 5, 0, null, 0, 24),    ('name',      850, 5, 0, null, null, null),    ('comment',   9285, 5, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    ('regionkey', null, 5, 0, null, 0, 4),    ('name',      885, 5, 0, null, null, null),    ('comment',   8250, 5, 0, null, null, null),    (null, null, null, null, 125, null, null)");
    }

    @Test
    public void testShowStatsWithoutTableScanAndImplicitColumnNames() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM (VALUES 1))", "VALUES    ('_col0', null, 1, 0, null, 1, 1),    (null, null, null, null, 1, null, null)");
    }

    @Test
    public void testShowStatsWithSubquery() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM (SELECT * FROM nation))", "VALUES    ('nationkey', null, 25, 0, null, 0, 24),    ('name', 177, 25, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    ('comment', 1857, 25, 0, null, null, null),    (null, null, null, null, 25, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation, (SELECT * FROM nation))", "VALUES    ('nationkey', null, 25, 0, null, 0, 24),    ('name', 4425, 25, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    ('comment', 46425, 25, 0, null, null, null),    ('nationkey', null, 25, 0, null, 0, 24),    ('name', 4425, 25, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    ('comment', 46425, 25, 0, null, null, null),    (null, null, null, null, 625, null, null)");
    }

    @Test
    public void testShowStatsForNonExistingColumnFails() {
        this.assertQueryFails("SHOW STATS FOR (SELECT column_does_not_exist FROM nation_partitioned)", ".*Column 'column_does_not_exist' cannot be resolved");
    }

    @Test
    public void testShowStatsForNonColumnQuery() {
        this.assertQuery("SHOW STATS FOR (SELECT 1 AS x FROM nation_partitioned)", "VALUES    ('x', null, 1, 0, null, 1, 1),    (null, null, null, null, 25, null, null)");
    }

    @Test
    public void testShowStatsForAliasedColumnQuery() {
        this.assertQuery("SHOW STATS FOR (SELECT nationkey, name, name AS name2 FROM nation_partitioned WHERE regionkey > 0 and regionkey < 4)", "VALUES    ('nationkey', null, 5, 0, null, 1, 24),    ('name', 109, 5, 0, null, null, null),    ('name2', 109, 5, 0, null, null, null),    (null, null, null, null, 15, null, null)");
    }

    @Test
    public void testShowStatsForNonIdentifierColumn() {
        this.assertQuery("SHOW STATS FOR (SELECT CONCAT('some', 'value') AS x FROM nation_partitioned)", "VALUES    ('x', null, 1, 0, null, null, null),    (null, null, null, null, 25, null, null)");
    }

    @Test
    public void testShowStatsForColumnExpression() {
        this.assertQuery("SHOW STATS FOR (SELECT nationkey + 100 AS x FROM nation_partitioned)", "VALUES    ('x', null, 5, 0, null, 100, 124),    (null, null, null, null, 25, null, null)");
    }

    @Test
    public void testShowStatsWithValues() {
        this.assertQuery("SHOW STATS FOR (VALUES 1, 2, 3)", "VALUES    ('_col0', null, 3, 0, null, 1, 3),    (null, null, null, null, 3, null, null)");
    }

    @Test
    public void testShowStatsWithTable() {
        this.assertQuery("SHOW STATS FOR (TABLE nation)", "VALUES    ('nationkey', null, 25, 0, null, 0, 24),    ('name', 177, 25, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    ('comment', 1857, 25, 0, null, null, null),    (null, null, null, null, 25, null, null)");
    }

    @Test
    public void testShowStatsWithWith() {
        this.assertQuery("SHOW STATS FOR (    WITH t AS (SELECT nationkey, name, regionkey FROM nation)    SELECT * FROM t)", "VALUES    ('nationkey', null, 25, 0, null, 0, 24),    ('name', 177, 25, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 25, null, null)");
    }

    @Test
    public void testShowStatsWithIntersect() {
        this.assertQuery("SHOW STATS FOR ((SELECT nationkey FROM nation) INTERSECT (SELECT regionkey FROM region))", "VALUES    ('nationkey', null, 22.5, 0.0, null, 0, 24),    (null, null, null, null, 22.5, null, null)");
    }

    @Test
    public void testShowStatsWithAggregation() {
        this.assertQuery("SHOW STATS FOR (SELECT count(*) AS x FROM orders)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 1, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "prefer_partial_aggregation", "false"), "SHOW STATS FOR (SELECT count(*) AS x FROM orders)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 1, null, null)");
    }

    @Test
    public void testShowStatsWithGroupBy() {
        this.assertQuery("SHOW STATS FOR (SELECT avg(totalprice) AS x FROM orders GROUP BY orderkey)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 15000.0, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "prefer_partial_aggregation", "false"), "SHOW STATS FOR (SELECT avg(totalprice) AS x FROM orders GROUP BY orderkey)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 15000, null, null)");
    }

    @Test
    public void testShowStatsWithHaving() {
        this.assertQuery("SHOW STATS FOR (SELECT count(nationkey) AS x FROM nation_partitioned GROUP BY regionkey HAVING regionkey > 0)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 4.0, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "prefer_partial_aggregation", "false"), "SHOW STATS FOR (SELECT count(nationkey) AS x FROM nation_partitioned GROUP BY regionkey HAVING regionkey > 0)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 4, null, null)");
    }

    @Test
    public void testShowStatsWithSelectDistinct() {
        this.assertQuery("SHOW STATS FOR (SELECT DISTINCT * FROM orders)", "VALUES    ('orderkey', null, 15000.0, 0.0, null, '1', '60000'),    ('custkey', null, 990.0, 0.0, null, '1', '1499'),    ('orderstatus',  15000.0, 3.0, 0.0, null, null, null),    ('totalprice', null, 15000.0, 0.0, null, '874.89', '466001.28'),    ('orderdate', null, 2406.0, 0.0, null, '1992-01-01', '1998-08-02'),    ('orderpriority', 126188.00000000001, 5.0, 0.0, null, null, null),    ('clerk', 225000.0, 995.0, 0.0, null, null, null),    ('shippriority', null, 1.0, 0.0, null, '0', '0'),    ('comment', 727364.0, 15000.0, 0.0, null, null, null),    (null, null, null, null, 15000.0, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "prefer_partial_aggregation", "false"), "SHOW STATS FOR (SELECT DISTINCT orderkey, custkey, orderstatus, totalprice, clerk, shippriority, comment FROM orders)", "VALUES    ('orderkey', null, 15000, 0, null, 1, 60000),    ('custkey', null, 990, 0, null, 1, 1499),    ('orderstatus', 15000, 3, 0, null, null, null),    ('totalprice', null, 15000, 0, null, 874.89, 466001.28),    ('clerk', 225000, 995, 0, null, null, null),    ('shippriority', null, 1, 0, null, 0, 0),    ('comment', 727364, 15000, 0, null, null, null),    (null, null, null, null, 15000, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT DISTINCT regionkey FROM region)", "VALUES    ('regionkey', null, 5.0, 0.0, null, 0, 4),    (null, null, null, null, 5.0, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "prefer_partial_aggregation", "false"), "SHOW STATS FOR (SELECT DISTINCT regionkey FROM region)", "VALUES    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 5, null, null)");
    }

    @Test
    public void testShowStatsWithDistinctLimit() {
        this.assertQuery("SHOW STATS FOR (SELECT DISTINCT regionkey FROM nation LIMIT 3)", "VALUES    ('regionkey', null, null, null, null, null, null),    (null, null, null, null, null, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "use_partial_distinct_limit", "false"), "SHOW STATS FOR (SELECT DISTINCT regionkey FROM nation LIMIT 3)", "VALUES    ('regionkey', null, 3, 0, null, 0, 4),    (null, null, null, null, 3, null, null)");
    }

    @Test
    public void testShowStatsWithLimit() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation LIMIT 7)", "VALUES    ('nationkey', null, 7, 0, null, 0, 24),    ('name', 49.56, 7, 0, null, null, null),    ('comment', 519.96, 7, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 7, null, null)");
    }

    @Test
    public void testShowStatsWithTopN() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation ORDER BY nationkey LIMIT 7)", "VALUES    ('nationkey', null, 7, 0, null, 0, 24),    ('name', 49.56, 7, 0, null, null, null),    ('comment', 519.96, 7, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 7, null, null)");
        this.assertQuery(TestShowStats.sessionWith(this.getSession(), "use_partial_topn", "false"), "SHOW STATS FOR (SELECT * FROM nation ORDER BY nationkey LIMIT 7)", "VALUES    ('nationkey', null, 7, 0, null, 0, 24),    ('name', 49.56, 7, 0, null, null, null),    ('comment', 519.96, 7, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 7, null, null)");
    }

    @Test
    public void testShowStatsWithSelectFunctionCall() {
        this.assertQuery("SHOW STATS FOR (SELECT sin(orderkey) AS x FROM orders)", "VALUES    ('x', null, null, null, null, null, null),    (null, null, null, null, 15000, null, null)");
    }

    @Test
    public void testShowStatsWithPredicate() {
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey + 100 < 200)", "VALUES    ('nationkey', null, 5, 0, null, 0, 24),    ('name', 177, 5, 0, null, null, null),    ('comment', 1857, 5, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 25, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE regionkey > 0 and nationkey > 0)", "VALUES    ('nationkey', null, 5, 0, null, 1, 24),    ('name', 140, 5, 0, null, null, null),    ('comment', 1547, 5, 0, null, null, null),    ('regionkey', null, 4, 0, null, 1, 4),    (null, null, null, null, 20, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE nationkey = 1 and name is not null)", "VALUES    ('nationkey', null, 1, 0, null, 1, 1),    ('name', 35.4, 5, 0, null, null, null),    ('comment', 371.4, 5, 0, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, 5, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned WHERE sin(regionkey) > 0)", "VALUES    ('nationkey', null, 5, 0, null, 1, 24),    ('name', null, 5, 0, null, null, null),    ('comment', null, 5, 0, null, null, null),    ('regionkey', null, 3, 0, null, 1, 3),    (null, null, null, null, null, null, null)");
    }

    @Test
    public void testShowStatsWithView() {
        this.assertUpdate("CREATE VIEW nation_view AS SELECT * FROM tpch.tiny.nation WHERE nationkey % 5 = 0");
        this.assertQuery("SHOW STATS FOR nation_view", "VALUES    ('nationkey', null, 1, 0, null, 0, 24),    ('name', 7.08, 1, 0, null, null, null),    ('comment', 74.28, 1, 0, null, null, null),    ('regionkey', null, 1, 0, null, 0, 4),    (null, null, null, null, 1, null, null)");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_view WHERE regionkey = 0)", "VALUES    ('nationkey', null, 0.29906975624424414, 0, null, 0, 24),    ('name', 2.1174138742092485, 0.29906975624424414, 0, null, null, null),    ('comment', 22.214901493822456, 0.29906975624424414, 0, null, null, null),    ('regionkey', null, 0.29906975624424414, 0, null, 0, 0),    (null, null, null, null, 0.29906975624424414, null, null)");
        this.assertUpdate("DROP VIEW nation_view");
    }

    @Test
    public void testShowStatsForPartitionedTableWhenStatisticsAreAbsentInMetastore() {
        Session session = Session.builder((Session)this.getSession()).setCatalogSessionProperty("hive", "collect_column_statistics_on_write", "false").build();
        this.assertUpdate(session, "CREATE TABLE nation_partitioned_without_stats(nationkey BIGINT, name VARCHAR, comment VARCHAR, regionkey BIGINT) WITH (partitioned_by = ARRAY['regionkey'])");
        this.assertUpdate(session, "INSERT INTO nation_partitioned_without_stats SELECT nationkey, name, comment, regionkey FROM tpch.tiny.nation", 25L);
        this.assertUpdate("CALL system.drop_stats('tpch', 'nation_partitioned_without_stats')");
        this.assertQuery("SHOW STATS FOR (SELECT * FROM nation_partitioned_without_stats)", "VALUES    ('nationkey', null, null, null, null, null, null),    ('name', null, null, null, null, null, null),    ('comment', null, null, null, null, null, null),    ('regionkey', null, 5, 0, null, 0, 4),    (null, null, null, null, null, null, null)");
        this.assertUpdate("DROP TABLE nation_partitioned_without_stats");
    }

    private static Session sessionWith(Session base, String property, String value) {
        return Session.builder((Session)base).setSystemProperty(property, value).build();
    }
}

