/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.hive.InternalHiveConnectorFactory;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TestingHiveConnectorFactory
implements ConnectorFactory {
    private final Optional<HiveMetastore> metastore;
    private final Module module;
    private final Optional<DirectoryLister> directoryLister;

    public TestingHiveConnectorFactory(HiveMetastore metastore) {
        this(Optional.of(metastore), Modules.EMPTY_MODULE, Optional.empty());
    }

    public TestingHiveConnectorFactory(Optional<HiveMetastore> metastore, Module module, Optional<DirectoryLister> directoryLister) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.module = Objects.requireNonNull(module, "module is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
    }

    public String getName() {
        return "hive";
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        return InternalHiveConnectorFactory.createConnector((String)catalogName, config, (ConnectorContext)context, (Module)this.module, this.metastore, this.directoryLister);
    }
}

