/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.trino.plugin.hive.TestingHiveConnectorFactory;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Objects;
import java.util.Optional;

public class TestingHivePlugin
implements Plugin {
    private final Optional<HiveMetastore> metastore;
    private final Module module;
    private final Optional<DirectoryLister> directoryLister;

    public TestingHivePlugin() {
        this(Optional.empty(), Modules.EMPTY_MODULE, Optional.empty());
    }

    public TestingHivePlugin(HiveMetastore metastore) {
        this(Optional.of(metastore), Modules.EMPTY_MODULE, Optional.empty());
    }

    public TestingHivePlugin(Optional<HiveMetastore> metastore, Module module, Optional<DirectoryLister> directoryLister) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.module = Objects.requireNonNull(module, "module is null");
        this.directoryLister = Objects.requireNonNull(directoryLister, "directoryLister is null");
    }

    public Iterable<ConnectorFactory> getConnectorFactories() {
        return ImmutableList.of((Object)new TestingHiveConnectorFactory(this.metastore, this.module, this.directoryLister));
    }
}

