/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.units.Duration;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.authentication.HdfsAuthentication;
import io.trino.hdfs.authentication.NoHdfsAuthentication;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.azure.HiveAzureConfig;
import io.trino.plugin.hive.azure.TrinoAzureConfigurationInitializer;
import io.trino.plugin.hive.gcs.GoogleGcsConfigurationInitializer;
import io.trino.plugin.hive.gcs.HiveGcsConfig;
import io.trino.plugin.hive.metastore.HiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.IdentityAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.TestingTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.UgiBasedMetastoreClientFactory;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3ConfigurationInitializer;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;

public final class TestingThriftHiveMetastoreBuilder {
    private static final HdfsEnvironment HDFS_ENVIRONMENT = new HdfsEnvironment((HdfsConfiguration)new DynamicHdfsConfiguration(new HdfsConfigurationInitializer(new HdfsConfig().setSocksProxy((HostAndPort)HiveTestUtils.SOCKS_PROXY.orElse(null)), (Set)ImmutableSet.of((Object)new TrinoS3ConfigurationInitializer(new HiveS3Config()), (Object)new GoogleGcsConfigurationInitializer(new HiveGcsConfig()), (Object)new TrinoAzureConfigurationInitializer(new HiveAzureConfig()))), (Set)ImmutableSet.of()), new HdfsConfig(), (HdfsAuthentication)new NoHdfsAuthentication());
    private TokenAwareMetastoreClientFactory tokenAwareMetastoreClientFactory;
    private HiveConfig hiveConfig = new HiveConfig();
    private ThriftMetastoreConfig thriftMetastoreConfig = new ThriftMetastoreConfig();
    private HdfsEnvironment hdfsEnvironment = HDFS_ENVIRONMENT;

    public static TestingThriftHiveMetastoreBuilder testingThriftHiveMetastoreBuilder() {
        return new TestingThriftHiveMetastoreBuilder();
    }

    private TestingThriftHiveMetastoreBuilder() {
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(HostAndPort address, Duration timeout) {
        Objects.requireNonNull(address, "address is null");
        Objects.requireNonNull(timeout, "timeout is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = new TestingTokenAwareMetastoreClientFactory(HiveTestUtils.SOCKS_PROXY, address, timeout);
        return this;
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(HostAndPort address) {
        Objects.requireNonNull(address, "address is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = new TestingTokenAwareMetastoreClientFactory(HiveTestUtils.SOCKS_PROXY, address);
        return this;
    }

    public TestingThriftHiveMetastoreBuilder metastoreClient(ThriftMetastoreClient client) {
        Objects.requireNonNull(client, "client is null");
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory == null ? 1 : 0) != 0, (Object)"Metastore client already set");
        this.tokenAwareMetastoreClientFactory = token -> client;
        return this;
    }

    public TestingThriftHiveMetastoreBuilder hiveConfig(HiveConfig hiveConfig) {
        this.hiveConfig = Objects.requireNonNull(hiveConfig, "hiveConfig is null");
        return this;
    }

    public TestingThriftHiveMetastoreBuilder thriftMetastoreConfig(ThriftMetastoreConfig thriftMetastoreConfig) {
        this.thriftMetastoreConfig = Objects.requireNonNull(thriftMetastoreConfig, "thriftMetastoreConfig is null");
        return this;
    }

    public TestingThriftHiveMetastoreBuilder hdfsEnvironment(HdfsEnvironment hdfsEnvironment) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        return this;
    }

    public ThriftMetastore build() {
        Preconditions.checkState((this.tokenAwareMetastoreClientFactory != null ? 1 : 0) != 0, (Object)"metastore client not set");
        ThriftHiveMetastoreFactory metastoreFactory = new ThriftHiveMetastoreFactory((IdentityAwareMetastoreClientFactory)new UgiBasedMetastoreClientFactory(this.tokenAwareMetastoreClientFactory, UserNameProvider.SIMPLE_USER_NAME_PROVIDER, this.thriftMetastoreConfig), new HiveMetastoreConfig().isHideDeltaLakeTables(), this.hiveConfig.isTranslateHiveViews(), this.thriftMetastoreConfig, this.hdfsEnvironment, Executors.newFixedThreadPool(this.thriftMetastoreConfig.getWriteStatisticsThreads()));
        return metastoreFactory.createMetastore(Optional.empty());
    }
}

