/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.azure;

import com.google.common.collect.Sets;
import io.trino.plugin.hive.azure.HiveAzureConfig;
import io.trino.plugin.hive.azure.TrinoAzureConfigurationInitializer;
import java.util.Set;
import java.util.function.BiConsumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTrinoAzureConfigurationInitializer {
    @Test
    public void testAdl() {
        TestTrinoAzureConfigurationInitializer.testPropertyGroup("If any of ADL client ID, credential, and refresh URL are set, all must be set", HiveAzureConfig::setAdlClientId, HiveAzureConfig::setAdlCredential, HiveAzureConfig::setAdlRefreshUrl);
    }

    @Test
    public void testWasb() {
        TestTrinoAzureConfigurationInitializer.testPropertyGroup("If WASB storage account or access key is set, both must be set", HiveAzureConfig::setWasbAccessKey, HiveAzureConfig::setWasbStorageAccount);
    }

    @Test
    public void testAbfsAccessKey() {
        TestTrinoAzureConfigurationInitializer.testPropertyGroup("If ABFS storage account or access key is set, both must be set", HiveAzureConfig::setAbfsAccessKey, HiveAzureConfig::setAbfsStorageAccount);
    }

    @Test
    public void testAbfsOAuth() {
        TestTrinoAzureConfigurationInitializer.testPropertyGroup("If any of ABFS OAuth2 Client endpoint, ID, and secret are set, all must be set.", HiveAzureConfig::setAbfsOAuthClientEndpoint, HiveAzureConfig::setAbfsOAuthClientId, HiveAzureConfig::setAbfsOAuthClientSecret);
    }

    @Test
    public void testExclusiveProperties() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTrinoAzureConfigurationInitializer.testProperties(HiveAzureConfig::setAbfsAccessKey, HiveAzureConfig::setAbfsStorageAccount, HiveAzureConfig::setAbfsOAuthClientEndpoint, HiveAzureConfig::setAbfsOAuthClientId, HiveAzureConfig::setAbfsOAuthClientSecret)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Multiple ABFS authentication methods configured: access key and OAuth2");
    }

    @SafeVarargs
    private static void testPropertyGroup(String expectedErrorMessage, BiConsumer<HiveAzureConfig, String> ... setters) {
        TestTrinoAzureConfigurationInitializer.testPropertyGroup(expectedErrorMessage, Set.of(setters));
    }

    private static void testPropertyGroup(String expectedErrorMessage, Set<BiConsumer<HiveAzureConfig, String>> setters) {
        TestTrinoAzureConfigurationInitializer.testProperties(setters);
        for (BiConsumer<HiveAzureConfig, String> setter : setters) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTrinoAzureConfigurationInitializer.testProperties((Set<BiConsumer<HiveAzureConfig, String>>)Sets.difference((Set)setters, Set.of(setter)))).isInstanceOf(IllegalArgumentException.class)).hasMessage(expectedErrorMessage);
        }
    }

    @SafeVarargs
    private static void testProperties(BiConsumer<HiveAzureConfig, String> ... setters) {
        TestTrinoAzureConfigurationInitializer.testProperties(Set.of(setters));
    }

    private static void testProperties(Set<BiConsumer<HiveAzureConfig, String>> setters) {
        HiveAzureConfig config = new HiveAzureConfig();
        for (BiConsumer<HiveAzureConfig, String> setter : setters) {
            setter.accept(config, "test value");
        }
        new TrinoAzureConfigurationInitializer(config);
    }
}

