/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.slice.Slices;
import io.trino.hadoop.HadoopNative;
import io.trino.jmh.Benchmarks;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.benchmark.BenchmarkFileFormat;
import io.trino.plugin.hive.benchmark.BenchmarkFileFormatsUtils;
import io.trino.plugin.hive.benchmark.FileFormat;
import io.trino.plugin.hive.benchmark.FormatWriter;
import io.trino.plugin.hive.benchmark.TestData;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.tpch.OrderColumn;
import io.trino.tpch.TpchColumn;
import io.trino.tpch.TpchTable;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Measurement(iterations=50)
@Warmup(iterations=20)
@Fork(value=3)
public class BenchmarkHiveFileFormat {
    private static final ConnectorSession SESSION = HiveTestUtils.getHiveSession(new HiveConfig(), new ParquetReaderConfig().setOptimizedReaderEnabled(false));
    private static final ConnectorSession SESSION_OPTIMIZED_PARQUET_READER = HiveTestUtils.getHiveSession(new HiveConfig(), new ParquetReaderConfig().setOptimizedReaderEnabled(true));
    @Param(value={"LINEITEM", "BIGINT_SEQUENTIAL", "BIGINT_RANDOM", "VARCHAR_SMALL", "VARCHAR_LARGE", "VARCHAR_DICTIONARY", "MAP_VARCHAR_DOUBLE", "LARGE_MAP_VARCHAR_DOUBLE", "MAP_INT_DOUBLE", "LARGE_MAP_INT_DOUBLE", "LARGE_ARRAY_VARCHAR"})
    private DataSet dataSet;
    @Param(value={"NONE", "SNAPPY", "GZIP"})
    private HiveCompressionCodec compression;
    @Param(value={"TRINO_RCBINARY", "TRINO_RCTEXT", "TRINO_ORC", "TRINO_PARQUET", "TRINO_OPTIMIZED_PARQUET", "HIVE_RCBINARY", "HIVE_RCTEXT", "HIVE_ORC", "HIVE_PARQUET"})
    private BenchmarkFileFormat benchmarkFileFormat;
    private FileFormat fileFormat;
    private TestData data;
    private File dataFile;
    private final File targetDir = BenchmarkFileFormatsUtils.createTempDir("trino-benchmark");

    public BenchmarkHiveFileFormat() {
    }

    public BenchmarkHiveFileFormat(DataSet dataSet, HiveCompressionCodec compression, BenchmarkFileFormat fileFormat) {
        this.dataSet = dataSet;
        this.compression = compression;
        this.benchmarkFileFormat = fileFormat;
    }

    @Setup
    public void setup() throws IOException {
        this.fileFormat = this.benchmarkFileFormat.getFormat();
        this.data = this.dataSet.createTestData(this.fileFormat);
        this.targetDir.mkdirs();
        this.dataFile = new File(this.targetDir, UUID.randomUUID().toString());
        this.writeData(this.dataFile);
    }

    @TearDown
    public void tearDown() throws IOException {
        MoreFiles.deleteRecursively((Path)this.targetDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Benchmark
    public List<Page> read(CompressionCounter counter) throws IOException {
        if (!this.fileFormat.supports(this.data)) {
            throw new RuntimeException(this.fileFormat + " does not support data set " + this.dataSet);
        }
        ArrayList<Page> pages = new ArrayList<Page>(100);
        try (ConnectorPageSource pageSource = this.fileFormat.createFileFormatReader(BenchmarkFileFormat.TRINO_OPTIMIZED_PARQUET.equals((Object)this.benchmarkFileFormat) ? SESSION_OPTIMIZED_PARQUET_READER : SESSION, HiveTestUtils.HDFS_ENVIRONMENT, this.dataFile, this.data.getColumnNames(), this.data.getColumnTypes());){
            while (!pageSource.isFinished()) {
                Page page = pageSource.getNextPage();
                if (page == null) continue;
                pages.add(page.getLoadedPage());
            }
        }
        counter.inputSize += (long)this.data.getSize();
        counter.outputSize += this.dataFile.length();
        return pages;
    }

    @Benchmark
    public File write(CompressionCounter counter) throws IOException {
        File targetFile = new File(this.targetDir, UUID.randomUUID().toString());
        this.writeData(targetFile);
        counter.inputSize += (long)this.data.getSize();
        counter.outputSize += targetFile.length();
        return targetFile;
    }

    private void writeData(File targetFile) throws IOException {
        List<Page> inputPages = this.data.getPages();
        try (FormatWriter formatWriter = this.fileFormat.createFileFormatWriter(SESSION, targetFile, this.data.getColumnNames(), this.data.getColumnTypes(), this.compression);){
            for (Page page : inputPages) {
                formatWriter.writePage(page);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Collection results = Benchmarks.benchmark(BenchmarkHiveFileFormat.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g"})).run();
        BenchmarkFileFormatsUtils.printResults(results);
    }

    static {
        HadoopNative.requireHadoopNative();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum DataSet {
        LINEITEM{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.LINE_ITEM, TpchTable.LINE_ITEM.getColumns());
            }
        }
        ,
        BIGINT_SEQUENTIAL{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.ORDER_KEY});
            }
        }
        ,
        BIGINT_RANDOM{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CUSTOMER_KEY});
            }
        }
        ,
        VARCHAR_SMALL{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CLERK});
            }
        }
        ,
        VARCHAR_LARGE{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.CLERK});
            }
        }
        ,
        VARCHAR_DICTIONARY{

            @Override
            public TestData createTestData(FileFormat format) {
                return BenchmarkFileFormatsUtils.createTpchDataSet(format, TpchTable.ORDERS, new TpchColumn[]{OrderColumn.ORDER_PRIORITY});
            }
        }
        ,
        MAP_VARCHAR_DOUBLE{
            private static final int MIN_ENTRIES = 1;
            private static final int MAX_ENTRIES = 5;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                int[] keys = new int[]{1, 2, 3, 4, 5};
                long dataSize = 0L;
                while (dataSize < BenchmarkFileFormatsUtils.MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkFileFormatsUtils.nextRandomBetween(random, 1, 5);
                    IntArrays.shuffle((int[])keys, (Random)random);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + keys[entryId])));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_MAP_VARCHAR_DOUBLE{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 15000;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < BenchmarkFileFormatsUtils.MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkFileFormatsUtils.nextRandomBetween(random, 5000, 15000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + random.nextInt(10000000))));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        MAP_INT_DOUBLE{
            private static final int MIN_ENTRIES = 1;
            private static final int MAX_ENTRIES = 5;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                int[] keys = new int[]{1, 2, 3, 4, 5};
                long dataSize = 0L;
                while (dataSize < BenchmarkFileFormatsUtils.MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkFileFormatsUtils.nextRandomBetween(random, 1, 5);
                    IntArrays.shuffle((int[])keys, (Random)random);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        IntegerType.INTEGER.writeLong(mapBuilder, (long)keys[entryId]);
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_MAP_INT_DOUBLE{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 150000;

            @Override
            public TestData createTestData(FileFormat format) {
                MapType type = HiveTestUtils.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE);
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < BenchmarkFileFormatsUtils.MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkFileFormatsUtils.nextRandomBetween(random, 5000, 150000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        IntegerType.INTEGER.writeLong(mapBuilder, (long)random.nextInt(10000000));
                        DoubleType.DOUBLE.writeDouble(mapBuilder, random.nextDouble());
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        }
        ,
        LARGE_ARRAY_VARCHAR{
            private static final int MIN_ENTRIES = 5000;
            private static final int MAX_ENTRIES = 150000;

            @Override
            public TestData createTestData(FileFormat format) {
                ArrayType type = new ArrayType((Type)VarcharType.createUnboundedVarcharType());
                Random random = new Random(1234L);
                PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)type));
                ImmutableList.Builder pages = ImmutableList.builder();
                long dataSize = 0L;
                while (dataSize < BenchmarkFileFormatsUtils.MIN_DATA_SIZE) {
                    pageBuilder.declarePosition();
                    BlockBuilder builder = pageBuilder.getBlockBuilder(0);
                    BlockBuilder mapBuilder = builder.beginBlockEntry();
                    int entries = BenchmarkFileFormatsUtils.nextRandomBetween(random, 5000, 150000);
                    for (int entryId = 0; entryId < entries; ++entryId) {
                        VarcharType.createUnboundedVarcharType().writeSlice(mapBuilder, Slices.utf8Slice((String)("key" + random.nextInt(10000000))));
                    }
                    builder.closeEntry();
                    if (!pageBuilder.isFull()) continue;
                    Page page = pageBuilder.build();
                    pages.add((Object)page);
                    pageBuilder.reset();
                    dataSize += page.getSizeInBytes();
                }
                return new TestData((List<String>)ImmutableList.of((Object)"map"), (List<Type>)ImmutableList.of((Object)type), (List<Page>)pages.build());
            }
        };


        public abstract TestData createTestData(FileFormat var1);
    }

    @AuxCounters
    @State(value=Scope.Thread)
    public static class CompressionCounter {
        public long inputSize;
        public long outputSize;
    }
}

