/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hive.formats.encodings.ColumnEncodingFactory;
import io.trino.hive.formats.encodings.binary.BinaryColumnEncodingFactory;
import io.trino.hive.formats.encodings.text.TextColumnEncodingFactory;
import io.trino.hive.formats.rcfile.RcFileWriter;
import io.trino.orc.OrcDataSink;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriteValidation;
import io.trino.orc.OrcWriter;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.OrcWriterStats;
import io.trino.orc.OutputStreamOrcDataSink;
import io.trino.orc.metadata.OrcType;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.RecordFileWriter;
import io.trino.plugin.hive.benchmark.AbstractFileFormat;
import io.trino.plugin.hive.benchmark.FileFormat;
import io.trino.plugin.hive.benchmark.FormatWriter;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.plugin.hive.util.CompressionConfigUtil;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.joda.time.DateTimeZone;

public final class StandardFileFormats {
    public static final FileFormat TRINO_RCBINARY = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCBINARY;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new RcFilePageSourceFactory(InternalTypeManager.TESTING_TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats(), new HiveConfig().setRcfileTimeZone("UTC")));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (ColumnEncodingFactory)new BinaryColumnEncodingFactory(DateTimeZone.UTC), compressionCodec);
        }
    };
    public static final FileFormat TRINO_RCTEXT = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCTEXT;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new RcFilePageSourceFactory(InternalTypeManager.TESTING_TYPE_MANAGER, hdfsEnvironment, new FileFormatDataSourceStats(), new HiveConfig().setRcfileTimeZone("UTC")));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoRcFileFormatWriter(targetFile, columnTypes, (ColumnEncodingFactory)new TextColumnEncodingFactory(), compressionCodec);
        }
    };
    public static final FileFormat TRINO_ORC = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.ORC;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, new FileFormatDataSourceStats(), DateTimeZone.UTC));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoOrcFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    };
    public static final FileFormat TRINO_PARQUET = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.PARQUET;
        }

        @Override
        public Optional<HivePageSourceFactory> getHivePageSourceFactory(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(new ParquetPageSourceFactory((TrinoFileSystemFactory)new HdfsFileSystemFactory(hdfsEnvironment), new FileFormatDataSourceStats(), new ParquetReaderConfig(), new HiveConfig()));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) throws IOException {
            return new PrestoParquetFormatWriter(targetFile, columnNames, columnTypes, compressionCodec);
        }
    };
    public static final FileFormat HIVE_RCBINARY = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCBINARY;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCBINARY, session);
        }
    };
    public static final FileFormat HIVE_RCTEXT = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.RCTEXT;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.RCTEXT, session);
        }
    };
    public static final FileFormat HIVE_ORC = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.ORC;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.ORC, session);
        }
    };
    public static final FileFormat HIVE_PARQUET = new AbstractFileFormat(){

        @Override
        public HiveStorageFormat getFormat() {
            return HiveStorageFormat.PARQUET;
        }

        @Override
        public Optional<HiveRecordCursorProvider> getHiveRecordCursorProvider(HdfsEnvironment hdfsEnvironment) {
            return Optional.of(HiveTestUtils.createGenericHiveRecordCursorProvider(hdfsEnvironment));
        }

        @Override
        public FormatWriter createFileFormatWriter(ConnectorSession session, File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec) {
            return new RecordFormatWriter(targetFile, columnNames, columnTypes, compressionCodec, HiveStorageFormat.PARQUET, session);
        }
    };

    private StandardFileFormats() {
    }

    private static class RecordFormatWriter
    implements FormatWriter {
        private final RecordFileWriter recordWriter;

        public RecordFormatWriter(File targetFile, List<String> columnNames, List<Type> columnTypes, HiveCompressionCodec compressionCodec, HiveStorageFormat format, ConnectorSession session) {
            JobConf config = new JobConf((Configuration)AbstractFileFormat.conf);
            CompressionConfigUtil.configureCompression((Configuration)config, (HiveCompressionCodec)compressionCodec);
            this.recordWriter = new RecordFileWriter(new Path(targetFile.toURI()), columnNames, StorageFormat.fromHiveStorageFormat((HiveStorageFormat)format), AbstractFileFormat.createSchema(format, columnNames, columnTypes), format.getEstimatedWriterMemoryUsage(), config, InternalTypeManager.TESTING_TYPE_MANAGER, DateTimeZone.UTC, session);
        }

        @Override
        public void writePage(Page page) {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.recordWriter.appendRow(page, position);
            }
        }

        @Override
        public void close() {
            this.recordWriter.commit();
        }
    }

    private static class PrestoRcFileFormatWriter
    implements FormatWriter {
        private final RcFileWriter writer;

        public PrestoRcFileFormatWriter(File targetFile, List<Type> types, ColumnEncodingFactory encoding, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new RcFileWriter((OutputStream)new FileOutputStream(targetFile), types, encoding, compressionCodec.getHiveCompressionKind(), (Map)ImmutableMap.of(), true);
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoOrcFormatWriter
    implements FormatWriter {
        private final OrcWriter writer;

        public PrestoOrcFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            this.writer = new OrcWriter((OrcDataSink)OutputStreamOrcDataSink.create((TrinoOutputFile)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY.create(HiveTestUtils.SESSION).newOutputFile(targetFile.getAbsolutePath())), columnNames, types, OrcType.createRootOrcType(columnNames, types), compressionCodec.getOrcCompressionKind(), new OrcWriterOptions(), (Map)ImmutableMap.of(), false, OrcWriteValidation.OrcWriteValidationMode.BOTH, new OrcWriterStats());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class PrestoParquetFormatWriter
    implements FormatWriter {
        private final ParquetWriter writer;

        public PrestoParquetFormatWriter(File targetFile, List<String> columnNames, List<Type> types, HiveCompressionCodec compressionCodec) throws IOException {
            ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(types, columnNames, true, true);
            this.writer = new ParquetWriter((OutputStream)new FileOutputStream(targetFile), schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), ParquetWriterOptions.builder().build(), compressionCodec.getParquetCompressionCodec(), "test-version", false, Optional.of(DateTimeZone.getDefault()), Optional.empty());
        }

        @Override
        public void writePage(Page page) throws IOException {
            this.writer.write(page);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

