/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.benchmark;

import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.benchmark.BenchmarkFileFormat;
import io.trino.plugin.hive.benchmark.BenchmarkHiveFileFormat;
import java.io.IOException;
import org.testng.annotations.Test;

public class TestHiveFileFormatBenchmark {
    @Test
    public void testSomeFormats() throws Exception {
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_OPTIMIZED_PARQUET);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.HIVE_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_RCBINARY);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_ORC);
        TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LARGE_MAP_VARCHAR_DOUBLE, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.HIVE_RCBINARY);
    }

    @Test
    public void testAllCompression() throws Exception {
        for (HiveCompressionCodec codec : HiveCompressionCodec.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(BenchmarkHiveFileFormat.DataSet.LINEITEM, codec, BenchmarkFileFormat.TRINO_RCBINARY);
        }
    }

    @Test
    public void testAllDataSets() throws Exception {
        for (BenchmarkHiveFileFormat.DataSet dataSet : BenchmarkHiveFileFormat.DataSet.values()) {
            TestHiveFileFormatBenchmark.executeBenchmark(dataSet, HiveCompressionCodec.SNAPPY, BenchmarkFileFormat.TRINO_RCBINARY);
        }
    }

    private static void executeBenchmark(BenchmarkHiveFileFormat.DataSet dataSet, HiveCompressionCodec codec, BenchmarkFileFormat format) throws IOException {
        BenchmarkHiveFileFormat benchmark = new BenchmarkHiveFileFormat(dataSet, codec, format);
        try {
            benchmark.setup();
            benchmark.read(new BenchmarkHiveFileFormat.CompressionCounter());
            benchmark.write(new BenchmarkHiveFileFormat.CompressionCounter());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed " + dataSet + " " + codec + " " + format, e);
        }
        finally {
            benchmark.tearDown();
        }
    }
}

