/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.log.Logger;
import io.trino.plugin.hive.containers.PrintingLogConsumer;
import io.trino.testing.TestingProperties;
import io.trino.testing.containers.BaseTestContainer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.testcontainers.containers.Network;

public class HiveHadoop
extends BaseTestContainer {
    private static final Logger log = Logger.get(HiveHadoop.class);
    public static final String DEFAULT_IMAGE = "ghcr.io/trinodb/testing/hdp2.6-hive:" + TestingProperties.getDockerImagesVersion();
    public static final String HIVE3_IMAGE = "ghcr.io/trinodb/testing/hdp3.1-hive:" + TestingProperties.getDockerImagesVersion();
    public static final String HOST_NAME = "hadoop-master";
    public static final int HIVE_METASTORE_PORT = 9083;

    public static Builder builder() {
        return new Builder();
    }

    private HiveHadoop(String image, String hostName, Set<Integer> ports, Map<String, String> filesToMount, Map<String, String> envVars, Optional<Network> network, int startupRetryLimit) {
        super(image, hostName, ports, filesToMount, envVars, network, startupRetryLimit);
    }

    protected void setupContainer() {
        super.setupContainer();
        String runCmd = "/usr/local/hadoop-run.sh";
        this.copyResourceToContainer("containers/hive_hadoop/hadoop-run.sh", runCmd);
        this.withRunCommand((List)ImmutableList.of((Object)"/bin/bash", (Object)runCmd));
        this.withLogConsumer((Consumer)((Object)new PrintingLogConsumer(String.format("%-20s| ", "hadoop"))));
    }

    public void start() {
        super.start();
        log.info("Hive container started with addresses for metastore: %s", new Object[]{this.getHiveMetastoreEndpoint()});
    }

    public String runOnHive(String query) {
        return this.executeInContainerFailOnError(new String[]{"beeline", "-u", "jdbc:hive2://localhost:10000/default", "-n", "hive", "-e", query});
    }

    public String runOnMetastore(String query) {
        return this.executeInContainerFailOnError(new String[]{"mysql", "-D", "metastore", "-uroot", "-proot", "--batch", "--column-names=false", "-e", query}).replaceAll("\n$", "");
    }

    public HostAndPort getHiveMetastoreEndpoint() {
        return this.getMappedHostAndPortForExposedPort(9083);
    }

    public static class Builder
    extends BaseTestContainer.Builder<Builder, HiveHadoop> {
        private Builder() {
            this.image = DEFAULT_IMAGE;
            this.hostName = HiveHadoop.HOST_NAME;
            this.exposePorts = ImmutableSet.of((Object)9083);
        }

        public HiveHadoop build() {
            return new HiveHadoop(this.image, this.hostName, this.exposePorts, this.filesToMount, this.envVars, this.network, this.startupRetryLimit);
        }
    }
}

