/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.containers;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.HiveHadoop;
import io.trino.testing.ResourcePresence;
import io.trino.testing.containers.Minio;
import io.trino.testing.containers.TestContainers;
import io.trino.testing.minio.MinioClient;
import io.trino.util.AutoCloseableCloser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testcontainers.containers.Network;

public class HiveMinioDataLake
implements AutoCloseable {
    public static final String MINIO_DEFAULT_REGION = "us-east-1";
    private final String bucketName;
    private final Minio minio;
    private final HiveHadoop hiveHadoop;
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();
    private State state = State.INITIAL;
    private MinioClient minioClient;

    public HiveMinioDataLake(String bucketName) {
        this(bucketName, HiveHadoop.DEFAULT_IMAGE);
    }

    public HiveMinioDataLake(String bucketName, String hiveHadoopImage) {
        this(bucketName, (Map<String, String>)ImmutableMap.of((Object)"/etc/hadoop/conf/core-site.xml", (Object)TestContainers.getPathFromClassPathResource((String)"hive_minio_datalake/hive-core-site.xml")), hiveHadoopImage);
    }

    public HiveMinioDataLake(String bucketName, Map<String, String> hiveHadoopFilesToMount, String hiveHadoopImage) {
        this.bucketName = Objects.requireNonNull(bucketName, "bucketName is null");
        Network network = (Network)this.closer.register((AutoCloseable)Network.newNetwork());
        this.minio = (Minio)this.closer.register((AutoCloseable)((Minio.Builder)((Minio.Builder)Minio.builder().withNetwork(network)).withEnvVars((Map)ImmutableMap.builder().put((Object)"MINIO_ACCESS_KEY", (Object)"accesskey").put((Object)"MINIO_SECRET_KEY", (Object)"secretkey").put((Object)"MINIO_REGION", (Object)MINIO_DEFAULT_REGION).buildOrThrow())).build());
        HiveHadoop.Builder hiveHadoopBuilder = (HiveHadoop.Builder)((HiveHadoop.Builder)((HiveHadoop.Builder)HiveHadoop.builder().withImage(hiveHadoopImage)).withNetwork(network)).withFilesToMount(hiveHadoopFilesToMount);
        this.hiveHadoop = (HiveHadoop)((Object)this.closer.register((AutoCloseable)((Object)hiveHadoopBuilder.build())));
    }

    public void start() {
        Preconditions.checkState((this.state == State.INITIAL ? 1 : 0) != 0, (String)"Already started: %s", (Object)((Object)this.state));
        this.state = State.STARTING;
        this.minio.start();
        this.hiveHadoop.start();
        this.minioClient = (MinioClient)this.closer.register((AutoCloseable)this.minio.createMinioClient());
        this.minio.createBucket(this.bucketName);
        this.state = State.STARTED;
    }

    public void stop() throws Exception {
        this.closer.close();
        this.state = State.STOPPED;
    }

    @ResourcePresence
    public boolean isNotStopped() {
        return this.state != State.STOPPED;
    }

    public MinioClient getMinioClient() {
        Preconditions.checkState((this.state == State.STARTED ? 1 : 0) != 0, (String)"Can't provide client when MinIO state is: %s", (Object)((Object)this.state));
        return this.minioClient;
    }

    public void copyResources(String resourcePath, String target) {
        this.minio.copyResources(resourcePath, this.bucketName, target);
    }

    public void writeFile(byte[] contents, String target) {
        this.minio.writeFile(contents, this.bucketName, target);
    }

    public List<String> listFiles(String targetDirectory) {
        return this.getMinioClient().listObjects(this.getBucketName(), targetDirectory);
    }

    public Minio getMinio() {
        return this.minio;
    }

    public HiveHadoop getHiveHadoop() {
        return this.hiveHadoop;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private static enum State {
        INITIAL,
        STARTING,
        STARTED,
        STOPPED;

    }
}

