/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.cos;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Assertions;
import io.airlift.testing.TempFile;
import io.trino.hdfs.DynamicHdfsConfiguration;
import io.trino.hdfs.HdfsConfig;
import io.trino.hdfs.HdfsConfiguration;
import io.trino.hdfs.HdfsConfigurationInitializer;
import io.trino.hdfs.HdfsContext;
import io.trino.plugin.hive.cos.CosConfigurationInitializer;
import io.trino.plugin.hive.cos.CosServiceConfigurationProvider;
import io.trino.plugin.hive.cos.HiveCosServiceConfig;
import io.trino.plugin.hive.cos.TrinoCosFileSystem;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TestTrinoS3FileSystem;
import io.trino.plugin.hive.s3.TrinoS3ConfigurationInitializer;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.spi.security.ConnectorIdentity;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveCosServiceConfigurationProvider {
    @Test
    public void testPerBucketCredentialsIntegrated() throws Exception {
        HdfsConfiguration hiveHdfsConfiguration = this.getCosHdfsConfiguration();
        try (TrinoCosFileSystem fs = new TrinoCosFileSystem();){
            TestHiveCosServiceConfigurationProvider.verifyStaticCredentials(hiveHdfsConfiguration, fs, "cos://test-bucket/", "test-bucket", "test_access_key", "test_secret_key");
            TestHiveCosServiceConfigurationProvider.verifyStaticCredentials(hiveHdfsConfiguration, fs, "cos://test-bucket.a/", "test-bucket", "cos_a_access_key", "cos_a_secret_key");
            TestHiveCosServiceConfigurationProvider.verifyStaticCredentials(hiveHdfsConfiguration, fs, "cos://test-bucket.b/", "test-bucket", "cos_b_access_key", "cos_b_secret_key");
            TestHiveCosServiceConfigurationProvider.verifyStaticCredentials(hiveHdfsConfiguration, fs, "cos://a/", "a", "test_access_key", "test_secret_key");
        }
    }

    private HdfsConfiguration getCosHdfsConfiguration() throws IOException {
        CosServiceConfigurationProvider provider;
        HdfsConfigurationInitializer initializer = new HdfsConfigurationInitializer(new HdfsConfig(), (Set)ImmutableSet.of((Object)new TrinoS3ConfigurationInitializer(new HiveS3Config().setS3AwsAccessKey("test_access_key").setS3AwsSecretKey("test_secret_key")), (Object)new CosConfigurationInitializer()));
        try (TempFile cosServiceConfig = new TempFile();){
            Properties cosServiceProperties = new Properties();
            cosServiceProperties.put("a.access-key", "cos_a_access_key");
            cosServiceProperties.put("a.secret-key", "cos_a_secret_key");
            cosServiceProperties.put("b.access-key", "cos_b_access_key");
            cosServiceProperties.put("b.secret-key", "cos_b_secret_key");
            try (FileOutputStream out = new FileOutputStream(cosServiceConfig.file());){
                cosServiceProperties.store(out, "S3 bucket");
            }
            provider = new CosServiceConfigurationProvider(new HiveCosServiceConfig().setServiceConfig(cosServiceConfig.file()));
        }
        return new DynamicHdfsConfiguration(initializer, (Set)ImmutableSet.of((Object)provider));
    }

    private static void verifyStaticCredentials(HdfsConfiguration hiveHdfsConfiguration, TrinoCosFileSystem fileSystem, String uri, String expectedBucket, String expectedAccessKey, String expectedSecretKey) throws IOException {
        HdfsContext hdfsContext = new HdfsContext(ConnectorIdentity.forUser((String)"test").build());
        Configuration configuration = hiveHdfsConfiguration.getConfiguration(hdfsContext, URI.create(uri));
        fileSystem.initialize(URI.create(uri), configuration);
        Assert.assertEquals((String)fileSystem.getBucketName(URI.create(uri)), (String)expectedBucket);
        AWSCredentialsProvider awsCredentialsProvider = TestTrinoS3FileSystem.getAwsCredentialsProvider((TrinoS3FileSystem)fileSystem);
        Assertions.assertInstanceOf((Object)awsCredentialsProvider, AWSStaticCredentialsProvider.class);
        Assert.assertEquals((String)awsCredentialsProvider.getCredentials().getAWSAccessKeyId(), (String)expectedAccessKey);
        Assert.assertEquals((String)awsCredentialsProvider.getCredentials().getAWSSecretKey(), (String)expectedSecretKey);
    }
}

