/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.cos;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.TempFile;
import io.trino.plugin.hive.cos.ServiceConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestServiceConfig {
    @Test
    public void testInitializeConfiguration() {
        TestServiceConfig.testInitializeConfiguration2("accessValue", "secretValue", Optional.of("endpointValue"));
        TestServiceConfig.testInitializeConfiguration2("accessValue", "secretValue", Optional.empty());
    }

    private static void testInitializeConfiguration2(String accessValue, String secretValue, Optional<String> endpointValue) {
        ServiceConfig serviceConfig = new ServiceConfig("name", accessValue, secretValue, endpointValue);
        TestServiceConfig.assertConfig(serviceConfig, accessValue, secretValue, endpointValue);
    }

    private static void assertConfig(ServiceConfig serviceConfig, String accessValue, String secretValue, Optional<String> endpointValue) {
        Assert.assertEquals((String)serviceConfig.getAccessKey(), (String)accessValue);
        Assert.assertEquals((String)serviceConfig.getSecretKey(), (String)secretValue);
        Assert.assertEquals((Object)serviceConfig.getEndpoint(), endpointValue);
    }

    @Test
    public void testLoad() throws IOException {
        try (TempFile tempFile = new TempFile();){
            Assert.assertTrue((boolean)ServiceConfig.loadServiceConfigs((File)tempFile.file()).isEmpty());
            TestServiceConfig.writeProperties(tempFile, (Map<String, String>)ImmutableMap.builder().put((Object)"a.access-key", (Object)"a-accessValue").put((Object)"a.secret-key", (Object)"a-secretValue").put((Object)"a.endpoint", (Object)"a-endpointValue").put((Object)"b.access-key", (Object)"b-accessValue").put((Object)"b.secret-key", (Object)"b-secretValue").put((Object)"c.access-key", (Object)"c-accessValue").put((Object)"c.secret-key", (Object)"c-secretValue").put((Object)"c.endpoint", (Object)"c-endpointValue").buildOrThrow());
            Map bucketConfigs = ServiceConfig.loadServiceConfigs((File)tempFile.file());
            Assert.assertEquals(bucketConfigs.keySet(), (Set)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c"));
            TestServiceConfig.assertConfig((ServiceConfig)bucketConfigs.get("a"), "a-accessValue", "a-secretValue", Optional.of("a-endpointValue"));
            TestServiceConfig.assertConfig((ServiceConfig)bucketConfigs.get("b"), "b-accessValue", "b-secretValue", Optional.empty());
            TestServiceConfig.assertConfig((ServiceConfig)bucketConfigs.get("c"), "c-accessValue", "c-secretValue", Optional.of("c-endpointValue"));
        }
    }

    @Test
    public void testLoadInvalid() throws IOException {
        TestServiceConfig.assertInvalidLoad("a.secret-key", (ImmutableMap<String, String>)ImmutableMap.of((Object)"a.access-key", (Object)"a-accessValue"));
        TestServiceConfig.assertInvalidLoad("a.unknown", (ImmutableMap<String, String>)ImmutableMap.builder().put((Object)"a.access-key", (Object)"a-accessValue").put((Object)"a.secret-key", (Object)"a-secretValue").put((Object)"a.unknown", (Object)"value").buildOrThrow());
        TestServiceConfig.assertInvalidLoad("unknown", (ImmutableMap<String, String>)ImmutableMap.builder().put((Object)"a.access-key", (Object)"a-accessValue").put((Object)"a.secret-key", (Object)"a-secretValue").put((Object)"unknown", (Object)"value").buildOrThrow());
    }

    private static void assertInvalidLoad(String message, ImmutableMap<String, String> properties) throws IOException {
        try (TempFile tempFile = new TempFile();){
            TestServiceConfig.writeProperties(tempFile, properties);
            Assertions.assertThatThrownBy(() -> ServiceConfig.loadServiceConfigs((File)tempFile.file())).hasMessageContaining(message).isInstanceOf(IllegalArgumentException.class);
        }
    }

    private static void writeProperties(TempFile tempFile, Map<String, String> map) throws IOException {
        try (FileOutputStream out = new FileOutputStream(tempFile.file());){
            Properties properties = new Properties();
            properties.putAll(map);
            properties.store(out, "test");
        }
    }
}

