/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.plugin.hive.fs.BaseCachingDirectoryListerTest;
import io.trino.plugin.hive.fs.CachingDirectoryLister;
import io.trino.plugin.hive.fs.DirectoryListingCacheKey;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.testing.QueryRunner;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCachingDirectoryListerRecursiveFilesOnly
extends BaseCachingDirectoryListerTest<CachingDirectoryLister> {
    @Override
    protected CachingDirectoryLister createDirectoryLister() {
        return new CachingDirectoryLister(Duration.valueOf((String)"5m"), 1000000L, List.of("tpch.*"));
    }

    @Override
    protected QueryRunner createQueryRunner() throws Exception {
        return this.createQueryRunner((Map<String, String>)ImmutableMap.of((Object)"hive.allow-register-partition-procedure", (Object)"true", (Object)"hive.recursive-directories", (Object)"true"));
    }

    @Override
    protected boolean isCached(CachingDirectoryLister directoryLister, Path path) {
        return directoryLister.isCached(new DirectoryListingCacheKey(path, true));
    }

    @Test
    public void testRecursiveDirectories() {
        this.assertUpdate("CREATE TABLE recursive_directories (clicks bigint, day date, country varchar) WITH (format = 'ORC', partitioned_by = ARRAY['day', 'country'])");
        this.assertUpdate("INSERT INTO recursive_directories VALUES (1000, DATE '2022-02-01', 'US'), (2000, DATE '2022-02-01', 'US'), (4000, DATE '2022-02-02', 'US'), (1500, DATE '2022-02-01', 'AT'), (2500, DATE '2022-02-02', 'AT')", 5L);
        Table partitionedTable = this.getTable("tpch", "recursive_directories").orElseThrow(() -> new NoSuchElementException(String.format("Failed to read table %s.%s", "tpch", "recursive_directories")));
        this.dropTable("tpch", "recursive_directories", false);
        Table testTable = Table.builder((Table)partitionedTable).setPartitionColumns((List)ImmutableList.of()).build();
        this.createTable(testTable, testTable.getOwner().map(MetastoreUtil::buildInitialPrivilegeSet).orElse(PrincipalPrivileges.NO_PRIVILEGES));
        this.assertQuery("SELECT sum(clicks) FROM recursive_directories", "VALUES (11000)");
        Path tableLocation = this.getTableLocation("tpch", "recursive_directories");
        Assert.assertTrue((boolean)this.isCached(tableLocation));
        this.assertUpdate("INSERT INTO recursive_directories VALUES (1000)", 1L);
        Assert.assertFalse((boolean)this.isCached(tableLocation));
        this.assertQuery("SELECT sum(clicks) FROM recursive_directories", "VALUES (12000)");
        this.assertUpdate("DROP TABLE recursive_directories");
        Assert.assertFalse((boolean)this.isCached(tableLocation));
    }
}

