/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import io.trino.plugin.hive.fs.HiveFileIterator;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiveFileIterator {
    @Test
    public void testRelativeHiddenPathDetection() {
        String root = new Path("file:///root-path").toUri().getPath();
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Path)new Path(root, ".hidden/child"), (String)root));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Path)new Path(root, "_hidden.txt"), (String)root));
        String rootWithinHidden = new Path("file:///root/.hidden/listing-root").toUri().getPath();
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Path)new Path(rootWithinHidden, "file.txt"), (String)rootWithinHidden));
        String rootHiddenEnding = new Path("file:///root/hidden-ending_").toUri().getPath();
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenOrWithinHiddenParentDirectory((Path)new Path(rootHiddenEnding, "file.txt"), (String)rootHiddenEnding));
    }

    @Test
    public void testHiddenFileNameDetection() {
        Assert.assertFalse((boolean)HiveFileIterator.isHiddenFileOrDirectory((Path)new Path("file:///parent/.hidden/ignore-parent-directories.txt")));
        Assert.assertTrue((boolean)HiveFileIterator.isHiddenFileOrDirectory((Path)new Path("file:///parent/visible/_hidden-file.txt")));
    }

    @Test
    public void testHiddenDetectionEdgeCases() {
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"/.leading-slash-hidden-directory/", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"_root-hidden/directory/", (int)0));
        Assert.assertFalse((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root//multi-slash/", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/file.txt", (int)0));
        Assert.assertTrue((boolean)HiveFileIterator.containsHiddenPathPartAfterIndex((String)"root/child/.slash-hidden/parent/file.txt", (int)0));
    }
}

