/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.fs.BaseCachingDirectoryListerTest;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.FileSystemDirectoryLister;
import io.trino.plugin.hive.fs.TransactionScopeCachingDirectoryLister;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.util.HiveBucketing;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestTransactionScopeCachingDirectoryLister
extends BaseCachingDirectoryListerTest<TransactionScopeCachingDirectoryLister> {
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"));
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), Optional.of("location"), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), HiveBucketing.BucketingVersion.BUCKETING_V1, 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)))), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"));
    private static final Table TABLE = new Table("database", "table", Optional.of("owner"), "table_type", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.of("original_text"), Optional.of("expanded_text"), OptionalLong.empty());

    @Override
    protected TransactionScopeCachingDirectoryLister createDirectoryLister() {
        return new TransactionScopeCachingDirectoryLister((DirectoryLister)new FileSystemDirectoryLister(), 1000000L);
    }

    @Override
    protected boolean isCached(TransactionScopeCachingDirectoryLister directoryLister, Path path) {
        return directoryLister.isCached(path);
    }

    @Test
    public void testConcurrentDirectoryListing() throws IOException {
        TrinoFileStatus firstFile = new TrinoFileStatus((List)ImmutableList.of(), new Path("x"), false, 1L, 1L);
        TrinoFileStatus secondFile = new TrinoFileStatus((List)ImmutableList.of(), new Path("y"), false, 1L, 1L);
        TrinoFileStatus thirdFile = new TrinoFileStatus((List)ImmutableList.of(), new Path("z"), false, 1L, 1L);
        Path path1 = new Path("x");
        Path path2 = new Path("y");
        CountingDirectoryLister countingLister = new CountingDirectoryLister((Map<Path, List<TrinoFileStatus>>)ImmutableMap.of((Object)path1, (Object)ImmutableList.of((Object)firstFile, (Object)secondFile), (Object)path2, (Object)ImmutableList.of((Object)thirdFile)));
        TransactionScopeCachingDirectoryLister cachingLister = new TransactionScopeCachingDirectoryLister((DirectoryLister)countingLister, 2L);
        this.assertFiles((RemoteIterator<TrinoFileStatus>)cachingLister.list(null, TABLE, path2), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        Assertions.assertThat((boolean)cachingLister.isCached(path2)).isTrue();
        this.assertFiles((RemoteIterator<TrinoFileStatus>)cachingLister.list(null, TABLE, path2), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        RemoteIterator path1FilesA = cachingLister.list(null, TABLE, path1);
        RemoteIterator path1FilesB = cachingLister.list(null, TABLE, path1);
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesA.next())).isEqualTo((Object)firstFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesB.next())).isEqualTo((Object)firstFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesB.next())).isEqualTo((Object)secondFile);
        Assertions.assertThat((Comparable)((TrinoFileStatus)path1FilesA.next())).isEqualTo((Object)secondFile);
        Assertions.assertThat((boolean)path1FilesA.hasNext()).isFalse();
        Assertions.assertThat((boolean)path1FilesB.hasNext()).isFalse();
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThat((boolean)cachingLister.isCached(path2)).isFalse();
        this.assertFiles((RemoteIterator<TrinoFileStatus>)cachingLister.list(null, TABLE, path2), (List<TrinoFileStatus>)ImmutableList.of((Object)thirdFile));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(3);
    }

    @Test
    public void testConcurrentDirectoryListingException() throws IOException {
        TrinoFileStatus file = new TrinoFileStatus((List)ImmutableList.of(), new Path("x"), false, 1L, 1L);
        Path path = new Path("x");
        CountingDirectoryLister countingLister = new CountingDirectoryLister((Map<Path, List<TrinoFileStatus>>)ImmutableMap.of((Object)path, (Object)ImmutableList.of((Object)file)));
        TransactionScopeCachingDirectoryLister cachingLister = new TransactionScopeCachingDirectoryLister((DirectoryLister)countingLister, 1L);
        countingLister.setThrowException(true);
        RemoteIterator filesA = cachingLister.list(null, TABLE, path);
        RemoteIterator filesB = cachingLister.list(null, TABLE, path);
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(1);
        Assertions.assertThatThrownBy(() -> ((RemoteIterator)filesA).hasNext()).isInstanceOf(IOException.class);
        countingLister.setThrowException(false);
        this.assertFiles((RemoteIterator<TrinoFileStatus>)cachingLister.list(null, TABLE, path), (List<TrinoFileStatus>)ImmutableList.of((Object)file));
        Assertions.assertThat((int)countingLister.getListCount()).isEqualTo(2);
        Assertions.assertThatThrownBy(() -> ((RemoteIterator)filesB).hasNext()).isInstanceOf(IOException.class);
    }

    private void assertFiles(RemoteIterator<TrinoFileStatus> iterator, List<TrinoFileStatus> expectedFiles) throws IOException {
        ImmutableList.Builder actualFiles = ImmutableList.builder();
        while (iterator.hasNext()) {
            actualFiles.add((Object)((TrinoFileStatus)iterator.next()));
        }
        Assertions.assertThat((List)actualFiles.build()).isEqualTo(expectedFiles);
    }

    static RemoteIterator<TrinoFileStatus> throwingRemoteIterator(final List<TrinoFileStatus> files, final boolean throwException) {
        return new RemoteIterator<TrinoFileStatus>(){
            private final Iterator<TrinoFileStatus> iterator;
            {
                this.iterator = ImmutableList.copyOf((Collection)files).iterator();
            }

            public boolean hasNext() throws IOException {
                if (throwException) {
                    throw new IOException();
                }
                return this.iterator.hasNext();
            }

            public TrinoFileStatus next() {
                return this.iterator.next();
            }
        };
    }

    private static class CountingDirectoryLister
    implements DirectoryLister {
        private final Map<Path, List<TrinoFileStatus>> fileStatuses;
        private int listCount;
        private boolean throwException;

        public CountingDirectoryLister(Map<Path, List<TrinoFileStatus>> fileStatuses) {
            this.fileStatuses = Objects.requireNonNull(fileStatuses, "fileStatuses is null");
        }

        public RemoteIterator<TrinoFileStatus> list(FileSystem fs, Table table, Path path) throws IOException {
            ++this.listCount;
            return TestTransactionScopeCachingDirectoryLister.throwingRemoteIterator(Objects.requireNonNull(this.fileStatuses.get(path)), this.throwException);
        }

        public RemoteIterator<TrinoFileStatus> listFilesRecursively(FileSystem fs, Table table, Path path) throws IOException {
            return this.list(fs, table, path);
        }

        public void setThrowException(boolean throwException) {
            this.throwException = throwException;
        }

        public int getListCount() {
            return this.listCount;
        }

        public void invalidate(Partition partition) {
        }

        public void invalidate(Table table) {
        }
    }
}

