/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.gcs;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.plugin.hive.gcs.HiveGcsConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestHiveGcsConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveGcsConfig)ConfigAssertions.recordDefaults(HiveGcsConfig.class)).setJsonKeyFilePath(null).setUseGcsAccessToken(false));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path jsonKeyFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.gcs.json-key-file-path", (Object)jsonKeyFile.toString()).put((Object)"hive.gcs.use-access-token", (Object)"true").buildOrThrow();
        HiveGcsConfig expected = new HiveGcsConfig().setJsonKeyFilePath(jsonKeyFile.toString()).setUseGcsAccessToken(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

