/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CountingAccessHiveMetastore
implements HiveMetastore {
    private final HiveMetastore delegate;
    private final ConcurrentHashMultiset<Methods> methodInvocations = ConcurrentHashMultiset.create();

    public CountingAccessHiveMetastore(HiveMetastore delegate) {
        this.delegate = delegate;
    }

    public Multiset<Methods> getMethodInvocations() {
        return ImmutableMultiset.copyOf(this.methodInvocations);
    }

    public void resetCounters() {
        this.methodInvocations.clear();
    }

    public Optional<Table> getTable(String databaseName, String tableName) {
        this.methodInvocations.add((Object)Methods.GET_TABLE);
        return this.delegate.getTable(databaseName, tableName);
    }

    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllDatabases() {
        this.methodInvocations.add((Object)Methods.GET_ALL_DATABASES);
        return this.delegate.getAllDatabases();
    }

    public Optional<Database> getDatabase(String databaseName) {
        this.methodInvocations.add((Object)Methods.GET_DATABASE);
        return this.delegate.getDatabase(databaseName);
    }

    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        this.methodInvocations.add((Object)Methods.GET_TABLE_WITH_PARAMETER);
        return this.delegate.getTablesWithParameter(databaseName, parameterKey, parameterValue);
    }

    public List<String> getAllViews(String databaseName) {
        throw new UnsupportedOperationException();
    }

    public void createDatabase(Database database) {
        this.methodInvocations.add((Object)Methods.CREATE_DATABASE);
        this.delegate.createDatabase(database);
    }

    public void dropDatabase(String databaseName, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void renameDatabase(String databaseName, String newDatabaseName) {
        throw new UnsupportedOperationException();
    }

    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        this.methodInvocations.add((Object)Methods.CREATE_TABLE);
        this.delegate.createTable(table, principalPrivileges);
    }

    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.methodInvocations.add((Object)Methods.DROP_TABLE);
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    public void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        this.methodInvocations.add((Object)Methods.REPLACE_TABLE);
        this.delegate.replaceTable(databaseName, tableName, newTable, principalPrivileges);
    }

    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        throw new UnsupportedOperationException();
    }

    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        throw new UnsupportedOperationException();
    }

    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        throw new UnsupportedOperationException();
    }

    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        throw new UnsupportedOperationException();
    }

    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        throw new UnsupportedOperationException();
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
        throw new UnsupportedOperationException();
    }

    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
        throw new UnsupportedOperationException();
    }

    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        throw new UnsupportedOperationException();
    }

    public void createRole(String role, String grantor) {
        throw new UnsupportedOperationException();
    }

    public void dropRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<String> listRoles() {
        throw new UnsupportedOperationException();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        throw new UnsupportedOperationException();
    }

    public PartitionStatistics getTableStatistics(Table table) {
        this.methodInvocations.add((Object)Methods.GET_TABLE_STATISTICS);
        return this.delegate.getTableStatistics(table);
    }

    public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
        throw new UnsupportedOperationException();
    }

    public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        throw new UnsupportedOperationException();
    }

    public void updatePartitionStatistics(Table table, Map<String, Function<PartitionStatistics, PartitionStatistics>> updates) {
        throw new UnsupportedOperationException();
    }

    public List<String> getAllTables(String databaseName) {
        throw new UnsupportedOperationException();
    }

    public static enum Methods {
        CREATE_DATABASE,
        CREATE_TABLE,
        GET_ALL_DATABASES,
        GET_DATABASE,
        GET_TABLE,
        GET_TABLE_WITH_PARAMETER,
        GET_TABLE_STATISTICS,
        REPLACE_TABLE,
        DROP_TABLE;

    }
}

