/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TableInvalidationCallback;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.fs.FileSystemDirectoryLister;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.UnimplementedHiveMetastore;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.testing.TestingConnectorSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.apache.hadoop.fs.Path;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestSemiTransactionalHiveMetastore {
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"));
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), Optional.of("location"), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), HiveBucketing.BucketingVersion.BUCKETING_V1, 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)))), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"));
    private CountDownLatch countDownLatch;

    @Test
    public void testParallelPartitionDrops() {
        int partitionsToDrop = 5;
        IntStream dropThreadsConfig = IntStream.of(1, 2);
        dropThreadsConfig.forEach(dropThreads -> {
            this.countDownLatch = new CountDownLatch(dropThreads);
            SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = this.getSemiTransactionalHiveMetastoreWithDropExecutor(Executors.newFixedThreadPool(dropThreads));
            IntStream.range(0, partitionsToDrop).forEach(i -> semiTransactionalHiveMetastore.dropPartition(TestingConnectorSession.SESSION, "test", "test", (List)ImmutableList.of((Object)String.valueOf(i)), true));
            semiTransactionalHiveMetastore.commit();
        });
    }

    private SemiTransactionalHiveMetastore getSemiTransactionalHiveMetastoreWithDropExecutor(Executor dropExecutor) {
        return new SemiTransactionalHiveMetastore(HiveTestUtils.HDFS_ENVIRONMENT, new HiveMetastoreClosure((HiveMetastore)new TestingHiveMetastore()), MoreExecutors.directExecutor(), dropExecutor, MoreExecutors.directExecutor(), false, false, true, Optional.empty(), Executors.newScheduledThreadPool(1), (TableInvalidationCallback)new FileSystemDirectoryLister());
    }

    @Test
    public void testParallelUpdateStatisticsOperations() {
        int tablesToUpdate = 5;
        IntStream updateThreadsConfig = IntStream.of(1, 2);
        updateThreadsConfig.forEach(updateThreads -> {
            this.countDownLatch = new CountDownLatch(updateThreads);
            SemiTransactionalHiveMetastore semiTransactionalHiveMetastore = updateThreads == 1 ? this.getSemiTransactionalHiveMetastoreWithUpdateExecutor(MoreExecutors.directExecutor()) : this.getSemiTransactionalHiveMetastoreWithUpdateExecutor(Executors.newFixedThreadPool(updateThreads));
            IntStream.range(0, tablesToUpdate).forEach(i -> semiTransactionalHiveMetastore.finishChangingExistingTable(AcidOperation.INSERT, TestingConnectorSession.SESSION, "database", "table_" + i, new Path("location"), (List)ImmutableList.of(), PartitionStatistics.empty(), false));
            semiTransactionalHiveMetastore.commit();
        });
    }

    private SemiTransactionalHiveMetastore getSemiTransactionalHiveMetastoreWithUpdateExecutor(Executor updateExecutor) {
        return new SemiTransactionalHiveMetastore(HiveTestUtils.HDFS_ENVIRONMENT, new HiveMetastoreClosure((HiveMetastore)new TestingHiveMetastore()), MoreExecutors.directExecutor(), MoreExecutors.directExecutor(), updateExecutor, false, false, true, Optional.empty(), Executors.newScheduledThreadPool(1), (TableInvalidationCallback)new FileSystemDirectoryLister());
    }

    private class TestingHiveMetastore
    extends UnimplementedHiveMetastore {
        private TestingHiveMetastore() {
        }

        @Override
        public Optional<Table> getTable(String databaseName, String tableName) {
            if (databaseName.equals("database")) {
                return Optional.of(new Table("database", tableName, Optional.of("owner"), "table_type", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.of("original_text"), Optional.of("expanded_text"), OptionalLong.empty()));
            }
            return Optional.empty();
        }

        @Override
        public PartitionStatistics getTableStatistics(Table table) {
            return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }

        @Override
        public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
            this.assertCountDownLatch();
        }

        @Override
        public void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
            this.assertCountDownLatch();
        }

        private void assertCountDownLatch() {
            try {
                TestSemiTransactionalHiveMetastore.this.countDownLatch.countDown();
                Assert.assertTrue((boolean)TestSemiTransactionalHiveMetastore.this.countDownLatch.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

