/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.alluxio;

import alluxio.grpc.table.Database;
import alluxio.grpc.table.FieldSchema;
import alluxio.grpc.table.Layout;
import alluxio.grpc.table.TableInfo;
import alluxio.grpc.table.layout.hive.HiveBucketProperty;
import alluxio.grpc.table.layout.hive.PartitionInfo;
import alluxio.grpc.table.layout.hive.SortingColumn;
import alluxio.grpc.table.layout.hive.StorageFormat;
import alluxio.shaded.client.com.google.protobuf.ByteString;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.alluxio.ProtoUtils;
import io.trino.plugin.hive.metastore.alluxio.TestingAlluxioMetastoreObjects;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.TrinoException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestProtoUtils {
    @Test
    public void testDatabaseNameLocation() {
        Database db = ProtoUtils.fromProto((alluxio.grpc.table.Database)TestingAlluxioMetastoreObjects.getTestingDatabase().build());
        Assert.assertEquals((String)"test_db", (String)db.getDatabaseName());
        Assert.assertEquals((String)"alluxio:///", (String)((String)db.getLocation().get()));
        Database.Builder alluxioDb = TestingAlluxioMetastoreObjects.getTestingDatabase().clearLocation();
        Assert.assertEquals(Optional.empty(), (Object)ProtoUtils.fromProto((alluxio.grpc.table.Database)alluxioDb.build()).getLocation());
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testTableMissingLayout() {
        ProtoUtils.fromProto((TableInfo)TestingAlluxioMetastoreObjects.getTestingTableInfo().clearLayout().build());
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testTableNonHiveLayout() {
        TableInfo.Builder alluxioTable = TableInfo.newBuilder().setLayout(TestingAlluxioMetastoreObjects.getTestingNonHiveLayout());
        ProtoUtils.fromProto((TableInfo)alluxioTable.build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testTableBadLayoutBytes() {
        Layout.Builder alluxioLayout = TestingAlluxioMetastoreObjects.getTestingHiveLayout().setLayoutData(ByteString.copyFrom((byte[])new byte[]{122, 122, 122}));
        TableInfo.Builder alluxioTable = TestingAlluxioMetastoreObjects.getTestingTableInfo().setLayout(alluxioLayout);
        ProtoUtils.fromProto((TableInfo)alluxioTable.build());
    }

    @Test
    public void testTable() {
        TableInfo.Builder table = TestingAlluxioMetastoreObjects.getTestingTableInfo();
        FieldSchema fieldSchema = TestingAlluxioMetastoreObjects.getTestingFieldSchema().build();
        Table t = ProtoUtils.fromProto((TableInfo)table.build());
        Column c = (Column)t.getColumn("test_owner").get();
        Assert.assertEquals((String)table.getDbName(), (String)t.getDatabaseName());
        Assert.assertEquals((String)table.getTableName(), (String)t.getTableName());
        Assert.assertEquals((String)table.getOwner(), (String)t.getOwner().orElse(null));
        Assert.assertEquals((String)table.getType().toString(), (String)t.getTableType());
        Assert.assertEquals((int)0, (int)t.getDataColumns().size());
        Assert.assertEquals((int)1, (int)t.getPartitionColumns().size());
        Assert.assertEquals((Map)table.getParametersMap(), (Map)t.getParameters());
        Assert.assertEquals(Optional.empty(), (Object)t.getViewOriginalText());
        Assert.assertEquals(Optional.empty(), (Object)t.getViewExpandedText());
        Assert.assertEquals((String)fieldSchema.getName(), (String)c.getName());
        Assert.assertEquals((String)fieldSchema.getComment(), (String)((String)c.getComment().get()));
        Assert.assertEquals((String)fieldSchema.getType(), (String)c.getType().toString());
        Storage s = t.getStorage();
        alluxio.grpc.table.layout.hive.Storage storage = TestingAlluxioMetastoreObjects.getTestingPartitionInfo().getStorage();
        Assert.assertEquals((boolean)storage.getSkewed(), (boolean)s.isSkewed());
        Assert.assertEquals((Object)ProtoUtils.fromProto((alluxio.grpc.table.layout.hive.StorageFormat)storage.getStorageFormat()), (Object)s.getStorageFormat());
        Assert.assertEquals((String)storage.getLocation(), (String)s.getLocation());
        Assert.assertEquals((Object)ProtoUtils.fromProto((Map)table.getParametersMap(), (alluxio.grpc.table.layout.hive.HiveBucketProperty)storage.getBucketProperty()), (Object)s.getBucketProperty());
        Assert.assertEquals((Map)storage.getStorageFormat().getSerdelibParametersMap(), (Map)s.getSerdeParameters());
    }

    @Test
    public void testSortingColumn() {
        SortingColumn.Builder column = TestingAlluxioMetastoreObjects.getTestingSortingColumn();
        SortingColumn c = ProtoUtils.fromProto((alluxio.grpc.table.layout.hive.SortingColumn)column.build());
        Assert.assertEquals((String)column.getColumnName(), (String)c.getColumnName());
        Assert.assertEquals((Object)SortingColumn.Order.valueOf((String)column.getOrder().toString()), (Object)c.getOrder());
    }

    @Test
    public void testBucketProperty() {
        HiveBucketProperty.Builder bucketProperty = TestingAlluxioMetastoreObjects.getTestingHiveBucketProperty();
        Optional bp = ProtoUtils.fromProto((Map)TestingAlluxioMetastoreObjects.getTestingTableInfo().getParametersMap(), (alluxio.grpc.table.layout.hive.HiveBucketProperty)bucketProperty.build());
        Assert.assertTrue((boolean)bp.isPresent());
        Assert.assertEquals(Collections.singletonList(ProtoUtils.fromProto((alluxio.grpc.table.layout.hive.SortingColumn)TestingAlluxioMetastoreObjects.getTestingSortingColumn().build())), (Collection)((HiveBucketProperty)bp.get()).getSortedBy());
        Assert.assertEquals((int)1, (int)((HiveBucketProperty)bp.get()).getSortedBy().size());
        Assert.assertEquals((int)bucketProperty.getBucketedByCount(), (int)((HiveBucketProperty)bp.get()).getBucketCount());
        Assert.assertEquals((Object)HiveBucketing.BucketingVersion.BUCKETING_V1, (Object)((HiveBucketProperty)bp.get()).getBucketingVersion());
    }

    @Test
    public void testBucketPropertyNoBuckets() {
        HiveBucketProperty.Builder bucketProperty = TestingAlluxioMetastoreObjects.getTestingHiveBucketProperty();
        bucketProperty.clearBucketCount();
        Map tableParameters = TestingAlluxioMetastoreObjects.getTestingTableInfo().getParametersMap();
        Optional bp = ProtoUtils.fromProto((Map)tableParameters, (alluxio.grpc.table.layout.hive.HiveBucketProperty)bucketProperty.build());
        Assert.assertFalse((boolean)bp.isPresent());
        bucketProperty = TestingAlluxioMetastoreObjects.getTestingHiveBucketProperty();
        bucketProperty.setBucketCount(0L);
        bp = ProtoUtils.fromProto((Map)tableParameters, (alluxio.grpc.table.layout.hive.HiveBucketProperty)bucketProperty.build());
        Assert.assertFalse((boolean)bp.isPresent());
    }

    @Test
    public void testStorageFormat() {
        StorageFormat.Builder storageFormat = TestingAlluxioMetastoreObjects.getTestingStorageFormat();
        StorageFormat fmt = ProtoUtils.fromProto((alluxio.grpc.table.layout.hive.StorageFormat)storageFormat.build());
        Assert.assertEquals((String)storageFormat.getSerde(), (String)fmt.getSerde());
        Assert.assertEquals((String)storageFormat.getInputFormat(), (String)fmt.getInputFormat());
        Assert.assertEquals((String)storageFormat.getOutputFormat(), (String)fmt.getOutputFormat());
    }

    @Test
    public void testColumn() {
        FieldSchema.Builder fieldSchema = TestingAlluxioMetastoreObjects.getTestingFieldSchema();
        Column column = ProtoUtils.fromProto((FieldSchema)fieldSchema.build());
        Assert.assertTrue((boolean)column.getComment().isPresent());
        Assert.assertEquals((String)fieldSchema.getComment(), (String)((String)column.getComment().get()));
        Assert.assertEquals((String)fieldSchema.getName(), (String)column.getName());
        Assert.assertEquals((Object)HiveType.valueOf((String)fieldSchema.getType()), (Object)column.getType());
    }

    @Test
    public void testColumnNoComment() {
        FieldSchema.Builder fieldSchema = TestingAlluxioMetastoreObjects.getTestingFieldSchema();
        fieldSchema.clearComment();
        Column column = ProtoUtils.fromProto((FieldSchema)fieldSchema.build());
        Assert.assertFalse((boolean)column.getComment().isPresent());
        Assert.assertEquals((String)fieldSchema.getName(), (String)column.getName());
        Assert.assertEquals((Object)HiveType.valueOf((String)fieldSchema.getType()), (Object)column.getType());
    }

    @Test
    public void testPartition() {
        PartitionInfo.Builder partitionInfo = TestingAlluxioMetastoreObjects.getTestingPartitionInfo();
        Partition partition = ProtoUtils.fromProto((PartitionInfo)partitionInfo.build());
        Assert.assertEquals((Collection)partitionInfo.getDataColsList().stream().map(ProtoUtils::fromProto).collect(Collectors.toList()), (Collection)partition.getColumns());
        Assert.assertEquals((String)partitionInfo.getDbName(), (String)partition.getDatabaseName());
        Assert.assertEquals((Map)partitionInfo.getParametersMap(), (Map)partition.getParameters());
        Assert.assertEquals((Collection)partitionInfo.getValuesList(), (Collection)partition.getValues());
        Assert.assertEquals((String)partitionInfo.getTableName(), (String)partition.getTableName());
        Storage s = partition.getStorage();
        alluxio.grpc.table.layout.hive.Storage storage = TestingAlluxioMetastoreObjects.getTestingPartitionInfo().getStorage();
        Assert.assertEquals((boolean)storage.getSkewed(), (boolean)s.isSkewed());
        Assert.assertEquals((Object)ProtoUtils.fromProto((alluxio.grpc.table.layout.hive.StorageFormat)storage.getStorageFormat()), (Object)s.getStorageFormat());
        Assert.assertEquals((String)storage.getLocation(), (String)s.getLocation());
        Assert.assertEquals((Object)ProtoUtils.fromProto((Map)partitionInfo.getParametersMap(), (alluxio.grpc.table.layout.hive.HiveBucketProperty)storage.getBucketProperty()), (Object)s.getBucketProperty());
        Assert.assertEquals((Map)storage.getStorageFormat().getSerdelibParametersMap(), (Map)s.getSerdeParameters());
    }
}

