/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveMetastoreClosure;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.TestingThriftHiveMetastoreBuilder;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.UnimplementedHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.MockThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreStats;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DataProviders;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.thrift.TException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.OptionalAssert;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestCachingHiveMetastore {
    private static final Logger log = Logger.get(TestCachingHiveMetastore.class);
    private static final PartitionStatistics TEST_STATS = PartitionStatistics.builder().setColumnStatistics((Map)ImmutableMap.of((Object)"column", (Object)HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty()))).build();
    private MockThriftMetastoreClient mockClient;
    private ListeningExecutorService executor;
    private CachingHiveMetastore metastore;
    private CachingHiveMetastore statsCacheMetastore;
    private ThriftMetastoreStats stats;

    @BeforeMethod
    public void setUp() {
        this.mockClient = new MockThriftMetastoreClient();
        ThriftMetastore thriftHiveMetastore = this.createThriftHiveMetastore();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s"))));
        this.metastore = CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(thriftHiveMetastore)).executor((Executor)this.executor).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(new Duration(5.0, TimeUnit.MINUTES)).refreshInterval(new Duration(1.0, TimeUnit.MINUTES)).maximumSize(1000L).partitionCacheEnabled(true).build();
        this.statsCacheMetastore = CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(thriftHiveMetastore)).executor((Executor)this.executor).metadataCacheEnabled(false).statsCacheEnabled(true).cacheTtl(new Duration(5.0, TimeUnit.MINUTES)).refreshInterval(new Duration(1.0, TimeUnit.MINUTES)).maximumSize(1000L).partitionCacheEnabled(true).build();
        this.stats = ((ThriftHiveMetastore)thriftHiveMetastore).getStats();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.metastore = null;
    }

    private ThriftMetastore createThriftHiveMetastore() {
        return TestCachingHiveMetastore.createThriftHiveMetastore(this.mockClient);
    }

    private static ThriftMetastore createThriftHiveMetastore(ThriftMetastoreClient client) {
        return TestingThriftHiveMetastoreBuilder.testingThriftHiveMetastoreBuilder().metastoreClient(client).build();
    }

    @Test
    public void testCachingWithOnlyPartitionsCacheEnabled() {
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(CachingHiveMetastore::getAllDatabases).usesCache();
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getAllTables("testdb")).usesCache();
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getTable("testdb", "testtbl")).usesCache();
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> testedMetastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all())).doesNotUseCache();
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> {
            Optional table = testedMetastore.getTable("testdb", "testtbl");
            testedMetastore.getPartition((Table)table.orElseThrow(), MockThriftMetastoreClient.TEST_PARTITION_VALUES1);
        }).omitsCacheForNumberOfOperations(1);
        PartitionCachingAssertions.assertThatCachingWithDisabledPartitionCache().whenExecuting(testedMetastore -> {
            Optional table = testedMetastore.getTable("testdb", "testtbl");
            testedMetastore.getPartitionsByNames((Table)table.orElseThrow(), MockThriftMetastoreClient.TEST_PARTITION_VALUES1);
        }).omitsCacheForNumberOfOperations(1);
    }

    @Test
    public void testGetAllDatabases() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getDatabaseNamesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getDatabaseNamesStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testGetAllTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getTableNamesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableNamesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.getAllTables("testdb"), (Collection)ImmutableList.of((Object)"testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableNamesStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableNamesStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testInvalidDbGetAllTAbles() {
        Assert.assertTrue((boolean)this.metastore.getAllTables("baddb").isEmpty());
    }

    @Test
    public void testGetTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.3333333333333333);
    }

    @Test
    public void testSetTableAuthorization() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertNotNull((Object)this.metastore.getDatabase("testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.setTableOwner("testdb", "testtbl", new HivePrincipal(PrincipalType.USER, "ignore"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertNotNull((Object)this.metastore.getDatabase("testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    @Test
    public void testInvalidDbGetTable() {
        Assert.assertFalse((boolean)this.metastore.getTable("baddb", "testtbl").isPresent());
        Assert.assertEquals((long)this.stats.getGetTable().getThriftExceptions().getTotalCount(), (long)0L);
        Assert.assertEquals((long)this.stats.getGetTable().getTotalFailures().getTotalCount(), (long)0L);
    }

    @Test
    public void testGetPartitionNames() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2", (Object)"key=testpartition3");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testGetPartitionThenGetPartitions() {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Optional firstRead = this.metastore.getPartition(table, List.of("testpartition1"));
        Assertions.assertThat((Optional)firstRead).isPresent();
        Assertions.assertThat((List)((Partition)firstRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
        Map byName = this.metastore.getPartitionsByNames(table, List.of("key=testpartition1"));
        Assertions.assertThat((Map)byName).containsOnlyKeys((Object[])new String[]{"key=testpartition1"});
        Optional secondRead = (Optional)byName.get("key=testpartition1");
        Assertions.assertThat((Optional)secondRead).isPresent();
        Assertions.assertThat((List)((Partition)secondRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, invocationCount=20)
    public void testGetPartitionThenGetPartitionsRacingWithInvalidation() throws Exception {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Optional firstRead = this.metastore.getPartition(table, List.of("testpartition1"));
        Assertions.assertThat((Optional)firstRead).isPresent();
        Assertions.assertThat((List)((Partition)firstRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CyclicBarrier barrier = new CyclicBarrier(2);
            Future<Object> invalidation = executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                this.metastore.flushCache();
                return null;
            });
            Future<Map> read = executor.submit(() -> {
                barrier.await(10L, TimeUnit.SECONDS);
                return this.metastore.getPartitionsByNames(table, List.of("key=testpartition1"));
            });
            Map byName = read.get();
            Assertions.assertThat((Map)byName).containsOnlyKeys((Object[])new String[]{"key=testpartition1"});
            Optional secondRead = (Optional)byName.get("key=testpartition1");
            Assertions.assertThat((Optional)secondRead).isPresent();
            Assertions.assertThat((List)((Partition)secondRead.get()).getValues()).isEqualTo(List.of("testpartition1"));
            invalidation.get();
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testInvalidGetPartitionNamesByFilterAll() {
        Assert.assertTrue((boolean)this.metastore.getPartitionNamesByFilter("baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).isEmpty());
    }

    @Test
    public void testGetPartitionNamesByParts() {
        ImmutableList expectedPartitions = ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2", (Object)"key=testpartition3");
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getPartitionFilterStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getPartitionFilterStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)((Collection)this.metastore.getPartitionNamesByFilter("testdb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).orElseThrow()), (Collection)expectedPartitions);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getPartitionFilterStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getPartitionFilterStats().getHitRate(), (Object)0.3333333333333333);
        ImmutableList partitionColumnNames = ImmutableList.of((Object)"date_key", (Object)"key");
        HiveColumnHandle dateKeyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(0)), (int)0, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        HiveColumnHandle keyColumn = HiveColumnHandle.createBaseColumn((String)((String)partitionColumnNames.get(1)), (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.PARTITION_KEY, Optional.empty());
        ImmutableList partitionColumns = ImmutableList.of((Object)dateKeyColumn, (Object)keyColumn);
        TupleDomain withNoFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.all());
        TupleDomain withSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.of((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val"), (Object[])new Object[0]), (boolean)false)).buildOrThrow()));
        TupleDomain withNoSingleValueFilter = MetastoreUtil.computePartitionKeyFilter((List)partitionColumns, (TupleDomain)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)dateKeyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2020-10-01")), (Range[])new Range[0]), (boolean)false)).put((Object)keyColumn, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"val1"), (boolean)true, (Object)Slices.utf8Slice((String)"val2"), (boolean)true), (Range[])new Range[0]), (boolean)false)).buildOrThrow()));
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)0.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withNoFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)0.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withSingleValueFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)1.0);
        this.metastore.getPartitionNamesByFilter("testdb", "testtbl", (List)partitionColumnNames, withNoSingleValueFilter);
        Assert.assertEquals((Object)this.stats.getGetPartitionNamesByParts().getTime().getAllTime().getCount(), (Object)2.0);
    }

    @Test
    public void testInvalidGetPartitionNamesByParts() {
        Assert.assertFalse((boolean)this.metastore.getPartitionNamesByFilter("baddb", "testtbl", MockThriftMetastoreClient.PARTITION_COLUMN_NAMES, TupleDomain.all()).isPresent());
    }

    @Test
    public void testGetPartitionsByNames() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition2")).size(), (int)1);
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.flushCache();
        Assert.assertEquals((int)this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=testpartition1", (Object)"key=testpartition2")).size(), (int)2);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
    }

    @Test
    public void testListRoles() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getRolesStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getRolesStats().getHitRate(), (Object)0.5);
        this.metastore.flushCache();
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.createRole("role", "grantor");
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        this.metastore.dropRole("testrole");
        Assert.assertEquals((Collection)this.metastore.listRoles(), MockThriftMetastoreClient.TEST_ROLES);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertEquals((long)this.metastore.getRolesStats().getRequestCount(), (long)5L);
        Assert.assertEquals((Object)this.metastore.getRolesStats().getHitRate(), (Object)0.2);
    }

    @Test
    public void testGetTableStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Object)this.metastore.getTableStatistics(table), (Object)TEST_STATS);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((Object)this.metastore.getTableStatistics(table), (Object)TEST_STATS);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.metastore.getTableStatisticsStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getTableStatisticsStats().getHitRate(), (Object)0.5);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)1L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.0);
        Table emptyColumnListTable = Table.builder((Table)table).setDataColumns((List)ImmutableList.of()).build();
        Assertions.assertThat((Object)this.metastore.getTableStatistics(emptyColumnListTable).getBasicStatistics()).isEqualTo((Object)TEST_STATS.getBasicStatistics());
        Assert.assertEquals((long)this.metastore.getTableStatisticsStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getTableStatisticsStats().getHitRate(), (Object)0.6666666666666666);
        this.mockClient.mockColumnStats("testdb", "testtbl", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(1L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(2L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(3L))));
        Table tableCol1 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_LONG, Optional.empty()))).build();
        Assertions.assertThat((Map)this.metastore.getTableStatistics(tableCol1).getColumnStatistics()).containsEntry((Object)"col1", (Object)TestCachingHiveMetastore.intColumnStats(1));
        Table tableCol2 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col2", HiveType.HIVE_LONG, Optional.empty()))).build();
        Assertions.assertThat((Map)this.metastore.getTableStatistics(tableCol2).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2));
        Table tableCol23 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col2", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("col3", HiveType.HIVE_LONG, Optional.empty()))).build();
        ((MapAssert)Assertions.assertThat((Map)this.metastore.getTableStatistics(tableCol23).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
    }

    @Test
    public void testGetTableStatisticsWithoutMetadataCache() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.statsCacheMetastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Object)this.statsCacheMetastore.getTableStatistics(table), (Object)TEST_STATS);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((Object)this.statsCacheMetastore.getTableStatistics(table), (Object)TEST_STATS);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((long)this.statsCacheMetastore.getTableStatisticsStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.statsCacheMetastore.getTableStatisticsStats().getHitRate(), (Object)0.5);
        Assert.assertEquals((long)this.statsCacheMetastore.getTableStats().getRequestCount(), (long)0L);
        Assert.assertEquals((Object)this.statsCacheMetastore.getTableStats().getHitRate(), (Object)1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidateWithLoadInProgress() throws Exception {
        final CountDownLatch loadInProgress = new CountDownLatch(1);
        final CountDownLatch invalidateDone = new CountDownLatch(1);
        MockThriftMetastoreClient mockClient = new MockThriftMetastoreClient(){

            @Override
            public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
                loadInProgress.countDown();
                List<ColumnStatisticsObj> result = super.getTableColumnStatistics(databaseName, tableName, columnNames);
                try {
                    invalidateDone.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        };
        CachingHiveMetastore metastore = this.createMetastore(mockClient);
        Table table = (Table)metastore.getTable("testdb", "testtbl").orElseThrow();
        ExecutorService executorService = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("invalidation-%d").build());
        try {
            Future<?> invalidateFuture = executorService.submit(() -> {
                try {
                    loadInProgress.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                metastore.flushCache();
                invalidateDone.countDown();
            });
            Assert.assertEquals((Object)metastore.getTableStatistics(table), (Object)TEST_STATS);
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)2);
            Assert.assertEquals((Object)metastore.getTableStatistics(table), (Object)TEST_STATS);
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)3);
            invalidateFuture.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    @Test
    public void testGetPartitionStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Partition partition = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1).orElseThrow();
        String partitionName = MetastoreUtil.makePartitionName((Table)table, (Partition)partition);
        Partition partition2 = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES2).orElseThrow();
        String partition2Name = MetastoreUtil.makePartitionName((Table)table, (Partition)partition2);
        Partition partition3 = (Partition)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES3).orElseThrow();
        String partition3Name = MetastoreUtil.makePartitionName((Table)table, (Partition)partition3);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertEquals((Map)this.metastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
        Assert.assertEquals((long)this.metastore.getPartitionStatisticsStats().getRequestCount(), (long)1L);
        Assert.assertEquals((Map)this.metastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
        Assert.assertEquals((long)this.metastore.getPartitionStatisticsStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.metastore.getPartitionStatisticsStats().getHitRate(), (Object)0.5);
        Assert.assertEquals((long)this.metastore.getTableStats().getRequestCount(), (long)1L);
        Assert.assertEquals((Object)this.metastore.getTableStats().getHitRate(), (Object)0.0);
        Assert.assertEquals((long)this.metastore.getPartitionStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getPartitionStats().getHitRate(), (Object)0.0);
        Table emptyColumnListTable = Table.builder((Table)table).setDataColumns((List)ImmutableList.of()).build();
        Map partitionStatistics = this.metastore.getPartitionStatistics(emptyColumnListTable, (List)ImmutableList.of((Object)partition));
        Assertions.assertThat((Map)partitionStatistics).containsOnlyKeys((Object[])new String[]{"key=testpartition1"});
        Assertions.assertThat((Object)((PartitionStatistics)partitionStatistics.get("key=testpartition1")).getBasicStatistics()).isEqualTo((Object)TEST_STATS.getBasicStatistics());
        Assert.assertEquals((long)this.metastore.getPartitionStatisticsStats().getRequestCount(), (long)3L);
        Assert.assertEquals((Object)this.metastore.getPartitionStatisticsStats().getHitRate(), (Object)0.6666666666666666);
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition1", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(1L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(2L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(3L))));
        Table tableCol1 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col1", HiveType.HIVE_LONG, Optional.empty()))).build();
        Map tableCol1PartitionStatistics = this.metastore.getPartitionStatistics(tableCol1, (List)ImmutableList.of((Object)partition));
        Assertions.assertThat((Map)tableCol1PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        Assertions.assertThat((Map)((PartitionStatistics)tableCol1PartitionStatistics.get(partitionName)).getColumnStatistics()).containsEntry((Object)"col1", (Object)TestCachingHiveMetastore.intColumnStats(1));
        Table tableCol2 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col2", HiveType.HIVE_LONG, Optional.empty()))).build();
        Map tableCol2PartitionStatistics = this.metastore.getPartitionStatistics(tableCol2, (List)ImmutableList.of((Object)partition));
        Assertions.assertThat((Map)tableCol2PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        Assertions.assertThat((Map)((PartitionStatistics)tableCol2PartitionStatistics.get(partitionName)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2));
        Table tableCol23 = Table.builder((Table)table).setDataColumns((List)ImmutableList.of((Object)new Column("col2", HiveType.HIVE_LONG, Optional.empty()), (Object)new Column("col3", HiveType.HIVE_LONG, Optional.empty()))).build();
        Map tableCol23PartitionStatistics = this.metastore.getPartitionStatistics(tableCol23, (List)ImmutableList.of((Object)partition));
        Assertions.assertThat((Map)tableCol23PartitionStatistics).containsOnlyKeys((Object[])new String[]{partitionName});
        ((MapAssert)Assertions.assertThat((Map)((PartitionStatistics)tableCol23PartitionStatistics.get(partitionName)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition2", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(21L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(22L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(23L))));
        this.mockClient.mockPartitionColumnStats("testdb", "testtbl", "key=testpartition3", (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)"col1", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(31L)), (Object)"col2", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(32L)), (Object)"col3", (Object)ColumnStatisticsData.longStats((LongColumnStatsData)new LongColumnStatsData().setNumNulls(33L))));
        Map tableCol2Partition2Statistics = this.metastore.getPartitionStatistics(tableCol2, (List)ImmutableList.of((Object)partition2));
        Assertions.assertThat((Map)tableCol2Partition2Statistics).containsOnlyKeys((Object[])new String[]{partition2Name});
        Assertions.assertThat((Map)((PartitionStatistics)tableCol2Partition2Statistics.get(partition2Name)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(22));
        Map tableCol23Partition123Statistics = this.metastore.getPartitionStatistics(tableCol23, (List)ImmutableList.of((Object)partition, (Object)partition2, (Object)partition3));
        Assertions.assertThat((Map)tableCol23Partition123Statistics).containsOnlyKeys((Object[])new String[]{partitionName, partition2Name, partition3Name});
        ((MapAssert)Assertions.assertThat((Map)((PartitionStatistics)tableCol23Partition123Statistics.get(partitionName)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(2))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(3));
        ((MapAssert)Assertions.assertThat((Map)((PartitionStatistics)tableCol23Partition123Statistics.get(partition2Name)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(22))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(23));
        ((MapAssert)Assertions.assertThat((Map)((PartitionStatistics)tableCol23Partition123Statistics.get(partition3Name)).getColumnStatistics()).containsEntry((Object)"col2", (Object)TestCachingHiveMetastore.intColumnStats(32))).containsEntry((Object)"col3", (Object)TestCachingHiveMetastore.intColumnStats(33));
    }

    @Test
    public void testGetPartitionStatisticsWithoutMetadataCache() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.statsCacheMetastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Partition partition = (Partition)this.statsCacheMetastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1).orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertEquals((Map)this.statsCacheMetastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((Map)this.statsCacheMetastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)3);
        Assert.assertEquals((long)this.statsCacheMetastore.getPartitionStatisticsStats().getRequestCount(), (long)2L);
        Assert.assertEquals((Object)this.statsCacheMetastore.getPartitionStatisticsStats().getHitRate(), (Object)0.5);
        Assert.assertEquals((long)this.statsCacheMetastore.getTableStats().getRequestCount(), (long)0L);
        Assert.assertEquals((Object)this.statsCacheMetastore.getTableStats().getHitRate(), (Object)1.0);
        Assert.assertEquals((long)this.statsCacheMetastore.getPartitionStats().getRequestCount(), (long)0L);
        Assert.assertEquals((Object)this.statsCacheMetastore.getPartitionStats().getHitRate(), (Object)1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidatePartitionStatsWithLoadInProgress() throws Exception {
        final CountDownLatch loadInProgress = new CountDownLatch(1);
        final CountDownLatch invalidateDone = new CountDownLatch(1);
        MockThriftMetastoreClient mockClient = new MockThriftMetastoreClient(){

            @Override
            public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
                loadInProgress.countDown();
                Map<String, List<ColumnStatisticsObj>> result = super.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
                try {
                    invalidateDone.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        };
        CachingHiveMetastore metastore = this.createMetastore(mockClient);
        Table table = (Table)metastore.getTable("testdb", "testtbl").orElseThrow();
        Partition partition = (Partition)metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1).orElseThrow();
        ExecutorService executorService = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("invalidation-%d").build());
        try {
            Future<?> invalidateFuture = executorService.submit(() -> {
                try {
                    loadInProgress.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                metastore.flushCache();
                invalidateDone.countDown();
            });
            Assert.assertEquals((Map)metastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)3);
            Assert.assertEquals((Map)metastore.getPartitionStatistics(table, (List)ImmutableList.of((Object)partition)), (Map)ImmutableMap.of((Object)"key=testpartition1", (Object)TEST_STATS));
            Assert.assertEquals((int)mockClient.getAccessCount(), (int)4);
            invalidateFuture.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private CachingHiveMetastore createMetastore(MockThriftMetastoreClient mockClient) {
        return CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(TestCachingHiveMetastore.createThriftHiveMetastore(mockClient))).executor((Executor)this.executor).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(new Duration(5.0, TimeUnit.MINUTES)).refreshInterval(new Duration(1.0, TimeUnit.MINUTES)).maximumSize(1000L).partitionCacheEnabled(true).build();
    }

    @Test
    public void testUpdatePartitionStatistics() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        HiveMetastoreClosure hiveMetastoreClosure = new HiveMetastoreClosure((HiveMetastore)this.metastore);
        Table table = (Table)hiveMetastoreClosure.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        hiveMetastoreClosure.updatePartitionStatistics(table.getDatabaseName(), table.getTableName(), "key=testpartition1", Function.identity());
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
    }

    @Test
    public void testInvalidGetPartitionsByNames() {
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Map partitionsByNames = this.metastore.getPartitionsByNames(table, (List)ImmutableList.of((Object)"key=badpartition1"));
        Assert.assertEquals((int)partitionsByNames.size(), (int)1);
        Optional onlyElement = (Optional)Iterables.getOnlyElement(partitionsByNames.values());
        Assert.assertFalse((boolean)onlyElement.isPresent());
    }

    @Test
    public void testNoCacheExceptions() {
        this.mockClient.setThrowException(true);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        try {
            this.metastore.getAllDatabases();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
    }

    @Test
    public void testCachingHiveMetastoreCreationWithTtlOnly() {
        CachingHiveMetastoreConfig config = new CachingHiveMetastoreConfig();
        config.setMetastoreCacheTtl(new Duration(10.0, TimeUnit.MILLISECONDS));
        CachingHiveMetastore metastore = this.createMetastoreWithDirectExecutor(config);
        Assertions.assertThat((Object)metastore).isNotNull();
    }

    @Test
    public void testCachingHiveMetastoreCreationViaMemoize() {
        ThriftMetastore thriftHiveMetastore = this.createThriftHiveMetastore();
        this.metastore = CachingHiveMetastore.memoizeMetastore((HiveMetastore)new BridgingHiveMetastore(thriftHiveMetastore), (long)1000L);
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((Collection)this.metastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"testdb"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertEquals((long)this.metastore.getDatabaseNamesStats().getRequestCount(), (long)0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=60000L, dataProviderClass=DataProviders.class, dataProvider="trueFalse")
    public void testLoadAfterInvalidate(boolean invalidateAll) throws Exception {
        final CopyOnWriteArrayList<Column> tableColumns = new CopyOnWriteArrayList<Column>();
        final ConcurrentHashMap<Object, Partition> tablePartitionsByName = new ConcurrentHashMap<Object, Partition>();
        final ConcurrentHashMap<String, String> tableParameters = new ConcurrentHashMap<String, String>();
        tableParameters.put("frequent-changing-table-parameter", "parameter initial value");
        String databaseName = "my_database";
        String tableName = "my_table_name";
        tableColumns.add(new Column("value", HiveType.toHiveType((Type)VarcharType.VARCHAR), Optional.empty()));
        tableColumns.add(new Column("pk", HiveType.toHiveType((Type)VarcharType.VARCHAR), Optional.empty()));
        ArrayList<CallSite> partitionNames = new ArrayList<CallSite>();
        for (int i = 0; i < 10; ++i) {
            String partitionName = "pk=" + i;
            tablePartitionsByName.put(partitionName, Partition.builder().setDatabaseName(databaseName).setTableName(tableName).setColumns((List)ImmutableList.copyOf(tableColumns)).setValues(List.of(Integer.toString(i))).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE))).setParameters(Map.of("frequent-changing-partition-parameter", "parameter initial value")).build());
            partitionNames.add((CallSite)((Object)partitionName));
        }
        final CountDownLatch getTableEnteredLatch = new CountDownLatch(1);
        final CountDownLatch getTableReturnLatch = new CountDownLatch(1);
        CountDownLatch getTableFinishedLatch = new CountDownLatch(1);
        final CountDownLatch getPartitionsByNamesEnteredLatch = new CountDownLatch(1);
        final CountDownLatch getPartitionsByNamesReturnLatch = new CountDownLatch(1);
        CountDownLatch getPartitionsByNamesFinishedLatch = new CountDownLatch(1);
        UnimplementedHiveMetastore mockMetastore = new UnimplementedHiveMetastore(){

            @Override
            public Optional<Table> getTable(String databaseName, String tableName) {
                Optional<Table> table = Optional.of(Table.builder().setDatabaseName(databaseName).setTableName(tableName).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns((List)tableColumns).setParameters((Map)ImmutableMap.copyOf((Map)tableParameters)).withStorage(storage -> storage.setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE))).setOwner(Optional.empty()).build());
                getTableEnteredLatch.countDown();
                TestCachingHiveMetastore.await(getTableReturnLatch, 10L, TimeUnit.SECONDS);
                return table;
            }

            @Override
            public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
                HashMap<String, Optional<Partition>> result = new HashMap<String, Optional<Partition>>();
                for (String partitionName : partitionNames) {
                    result.put(partitionName, Optional.ofNullable((Partition)tablePartitionsByName.get(partitionName)));
                }
                getPartitionsByNamesEnteredLatch.countDown();
                TestCachingHiveMetastore.await(getPartitionsByNamesReturnLatch, 10L, TimeUnit.SECONDS);
                return result;
            }
        };
        this.metastore = CachingHiveMetastore.builder().delegate((HiveMetastore)mockMetastore).executor((Executor)this.executor).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(new Duration(5.0, TimeUnit.MINUTES)).refreshInterval(new Duration(1.0, TimeUnit.MINUTES)).maximumSize(1000L).partitionCacheEnabled(true).build();
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            Future<Void> future = executor.submit(() -> {
                try {
                    Table table = (Table)this.metastore.getTable(databaseName, tableName).orElseThrow();
                    getTableFinishedLatch.countDown();
                    this.metastore.getPartitionsByNames(table, partitionNames);
                    getPartitionsByNamesFinishedLatch.countDown();
                    return null;
                }
                catch (Throwable e) {
                    log.error(e);
                    throw e;
                }
            });
            TestCachingHiveMetastore.await(getTableEnteredLatch, 10L, TimeUnit.SECONDS);
            tableParameters.put("frequent-changing-table-parameter", "main-thread-put-xyz");
            if (invalidateAll) {
                this.metastore.flushCache();
            } else {
                this.metastore.invalidateTable(databaseName, tableName);
            }
            getTableReturnLatch.countDown();
            TestCachingHiveMetastore.await(getTableFinishedLatch, 10L, TimeUnit.SECONDS);
            Table table = (Table)this.metastore.getTable(databaseName, tableName).orElseThrow();
            Assertions.assertThat((Map)table.getParameters()).isEqualTo(Map.of("frequent-changing-table-parameter", "main-thread-put-xyz"));
            TestCachingHiveMetastore.await(getPartitionsByNamesEnteredLatch, 10L, TimeUnit.SECONDS);
            String partitionName = (String)partitionNames.get(2);
            Map<String, String> newPartitionParameters = Map.of("frequent-changing-partition-parameter", "main-thread-put-alice");
            tablePartitionsByName.put(partitionName, Partition.builder((Partition)((Partition)tablePartitionsByName.get(partitionName))).setParameters(newPartitionParameters).build());
            if (invalidateAll) {
                this.metastore.flushCache();
            } else {
                this.metastore.invalidateTable(databaseName, tableName);
            }
            getPartitionsByNamesReturnLatch.countDown();
            TestCachingHiveMetastore.await(getPartitionsByNamesFinishedLatch, 10L, TimeUnit.SECONDS);
            Map loadedPartitions = this.metastore.getPartitionsByNames(table, partitionNames);
            ((OptionalAssert)((OptionalAssert)Assertions.assertThat((Optional)((Optional)loadedPartitions.get(partitionName))).isNotNull()).isPresent()).hasValueSatisfying(partition -> Assertions.assertThat((Map)partition.getParameters()).isEqualTo((Object)newPartitionParameters));
            future.get(10L, TimeUnit.SECONDS);
        }
        finally {
            getTableEnteredLatch.countDown();
            getTableReturnLatch.countDown();
            getTableFinishedLatch.countDown();
            getPartitionsByNamesEnteredLatch.countDown();
            getPartitionsByNamesReturnLatch.countDown();
            getPartitionsByNamesFinishedLatch.countDown();
            executor.shutdownNow();
            executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }

    @Test
    public void testDropTable() {
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)0);
        Table table = (Table)this.metastore.getTable("testdb", "testtbl").orElseThrow();
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)1);
        Assert.assertNotNull((Object)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        Assert.assertNotNull((Object)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)2);
        this.metastore.dropTable("testdb", "testtbl", false);
        Assert.assertNotNull((Object)this.metastore.getTable("testdb", "testtbl"));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)4);
        Assert.assertNotNull((Object)this.metastore.getPartition(table, MockThriftMetastoreClient.TEST_PARTITION_VALUES1));
        Assert.assertEquals((int)this.mockClient.getAccessCount(), (int)5);
    }

    private static HiveColumnStatistics intColumnStats(int nullsCount) {
        return HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.empty(), (OptionalLong)OptionalLong.of(nullsCount), (OptionalLong)OptionalLong.empty());
    }

    private static void await(CountDownLatch latch, long timeout, TimeUnit unit) {
        try {
            boolean awaited = latch.await(timeout, unit);
            Preconditions.checkState((boolean)awaited, (Object)"wait timed out");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException();
        }
    }

    private CachingHiveMetastore createMetastoreWithDirectExecutor(CachingHiveMetastoreConfig config) {
        return CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(this.createThriftHiveMetastore())).executor(MoreExecutors.directExecutor()).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(config.getMetastoreCacheTtl()).refreshInterval(config.getMetastoreRefreshInterval()).maximumSize(config.getMetastoreCacheMaximumSize()).partitionCacheEnabled(config.isPartitionCacheEnabled()).build();
    }

    static class PartitionCachingAssertions {
        private final CachingHiveMetastore cachingHiveMetastore;
        private final MockThriftMetastoreClient thriftClient;
        private Consumer<CachingHiveMetastore> metastoreInteractions = hiveMetastore -> {};

        static PartitionCachingAssertions assertThatCachingWithDisabledPartitionCache() {
            return new PartitionCachingAssertions();
        }

        private PartitionCachingAssertions() {
            this.thriftClient = new MockThriftMetastoreClient();
            this.cachingHiveMetastore = CachingHiveMetastore.builder().delegate((HiveMetastore)new BridgingHiveMetastore(TestCachingHiveMetastore.createThriftHiveMetastore(this.thriftClient))).executor((Executor)MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s")))).metadataCacheEnabled(true).statsCacheEnabled(true).cacheTtl(new Duration(5.0, TimeUnit.MINUTES)).refreshInterval(new Duration(1.0, TimeUnit.MINUTES)).maximumSize(1000L).partitionCacheEnabled(false).build();
        }

        PartitionCachingAssertions whenExecuting(Consumer<CachingHiveMetastore> interactions) {
            this.metastoreInteractions = interactions;
            return this;
        }

        void usesCache() {
            for (int i = 0; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                Assert.assertEquals((int)this.thriftClient.getAccessCount(), (int)1, (String)"Metastore is expected to use cache, but it does not.");
            }
        }

        void doesNotUseCache() {
            for (int i = 1; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                Assert.assertEquals((int)this.thriftClient.getAccessCount(), (int)i, (String)"Metastore is expected to not use cache, but it does.");
            }
        }

        void omitsCacheForNumberOfOperations(int expectedCacheOmittingOperations) {
            this.metastoreInteractions.accept(this.cachingHiveMetastore);
            int startingAccessCount = this.thriftClient.getAccessCount();
            for (int i = 1; i < 5; ++i) {
                this.metastoreInteractions.accept(this.cachingHiveMetastore);
                int currentAccessCount = this.thriftClient.getAccessCount();
                int timesCacheHasBeenOmitted = (currentAccessCount - startingAccessCount) / i;
                Assert.assertEquals((int)timesCacheHasBeenOmitted, (int)expectedCacheOmittingOperations, (String)String.format("Metastore is expected to not use cache %s times, but it does not use it %s times.", expectedCacheOmittingOperations, timesCacheHasBeenOmitted));
            }
        }
    }
}

