/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.cache;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastoreConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestCachingHiveMetastoreConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((CachingHiveMetastoreConfig)ConfigAssertions.recordDefaults(CachingHiveMetastoreConfig.class)).setMetastoreCacheTtl(new Duration(0.0, TimeUnit.SECONDS)).setStatsCacheTtl(new Duration(5.0, TimeUnit.MINUTES)).setMetastoreRefreshInterval(null).setMetastoreCacheMaximumSize(10000L).setMaxMetastoreRefreshThreads(10).setPartitionCacheEnabled(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.metastore-cache-ttl", (Object)"2h").put((Object)"hive.metastore-stats-cache-ttl", (Object)"10m").put((Object)"hive.metastore-refresh-interval", (Object)"30m").put((Object)"hive.metastore-cache-maximum-size", (Object)"5000").put((Object)"hive.metastore-refresh-max-threads", (Object)"2500").put((Object)"hive.metastore-cache.cache-partitions", (Object)"false").buildOrThrow();
        CachingHiveMetastoreConfig expected = new CachingHiveMetastoreConfig().setMetastoreCacheTtl(new Duration(2.0, TimeUnit.HOURS)).setStatsCacheTtl(new Duration(10.0, TimeUnit.MINUTES)).setMetastoreRefreshInterval(new Duration(30.0, TimeUnit.MINUTES)).setMetastoreCacheMaximumSize(5000L).setMaxMetastoreRefreshThreads(2500).setPartitionCacheEnabled(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

