/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.recording;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.plugin.base.TypeDeserializer;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveBucketProperty;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.RecordingMetastoreConfig;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveColumnStatistics;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.IntegerStatistics;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.SortingColumn;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.UnimplementedHiveMetastore;
import io.trino.plugin.hive.metastore.recording.HiveMetastoreRecording;
import io.trino.plugin.hive.metastore.recording.RecordingHiveMetastore;
import io.trino.plugin.hive.util.HiveBlockEncodingSerde;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockJsonSerde;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRecordingHiveMetastore {
    private static final Database DATABASE = new Database("database", Optional.of("location"), Optional.of("owner"), Optional.of(PrincipalType.USER), Optional.of("comment"), (Map)ImmutableMap.of((Object)"param", (Object)"value"));
    private static final Column TABLE_COLUMN = new Column("column", HiveType.HIVE_INT, Optional.of("comment"));
    private static final Storage TABLE_STORAGE = new Storage(StorageFormat.create((String)"serde", (String)"input", (String)"output"), Optional.of("location"), Optional.of(new HiveBucketProperty((List)ImmutableList.of((Object)"column"), HiveBucketing.BucketingVersion.BUCKETING_V1, 10, (List)ImmutableList.of((Object)new SortingColumn("column", SortingColumn.Order.ASCENDING)))), true, (Map)ImmutableMap.of((Object)"param", (Object)"value2"));
    private static final Table TABLE = new Table("database", "table", Optional.of("owner"), "table_type", TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value3"), Optional.of("original_text"), Optional.of("expanded_text"), OptionalLong.empty());
    private static final Partition PARTITION = new Partition("database", "table", (List)ImmutableList.of((Object)"value"), TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value4"));
    private static final Partition OTHER_PARTITION = new Partition("database", "table", (List)ImmutableList.of((Object)"other_value"), TABLE_STORAGE, (List)ImmutableList.of((Object)TABLE_COLUMN), (Map)ImmutableMap.of((Object)"param", (Object)"value4"));
    private static final PartitionStatistics PARTITION_STATISTICS = new PartitionStatistics(new HiveBasicStatistics(10L, 11L, 10000L, 10001L), (Map)ImmutableMap.of((Object)"column", (Object)new HiveColumnStatistics(Optional.of(new IntegerStatistics(OptionalLong.of(-100L), OptionalLong.of(102L))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), OptionalLong.of(1234L), OptionalLong.of(1235L), OptionalLong.of(1L), OptionalLong.of(8L))));
    private static final HivePrivilegeInfo PRIVILEGE_INFO = new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.SELECT, true, new HivePrincipal(PrincipalType.USER, "grantor"), new HivePrincipal(PrincipalType.USER, "grantee"));
    private static final RoleGrant ROLE_GRANT = new RoleGrant(new TrinoPrincipal(PrincipalType.USER, "grantee"), "role", true);
    private static final List<String> PARTITION_COLUMN_NAMES = ImmutableList.of((Object)TABLE_COLUMN.getName());
    private static final Domain PARTITION_COLUMN_EQUAL_DOMAIN = Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"value1"));
    private static final TupleDomain<String> TUPLE_DOMAIN = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TABLE_COLUMN.getName(), (Object)PARTITION_COLUMN_EQUAL_DOMAIN));

    @Test
    public void testRecordingHiveMetastore() throws IOException {
        RecordingMetastoreConfig recordingConfig = new RecordingMetastoreConfig().setRecordingPath(File.createTempFile("recording_test", "json").getAbsolutePath()).setRecordingDuration(new Duration(10.0, TimeUnit.MINUTES));
        JsonCodec<HiveMetastoreRecording.Recording> jsonCodec = TestRecordingHiveMetastore.createJsonCodec();
        HiveMetastoreRecording recording = new HiveMetastoreRecording(recordingConfig, jsonCodec);
        RecordingHiveMetastore recordingHiveMetastore = new RecordingHiveMetastore((HiveMetastore)new TestingHiveMetastore(), recording);
        this.validateMetadata((HiveMetastore)recordingHiveMetastore);
        recordingHiveMetastore.dropDatabase("other_database", true);
        recording.writeRecording();
        RecordingMetastoreConfig replayingConfig = recordingConfig.setReplay(true);
        recording = new HiveMetastoreRecording(replayingConfig, jsonCodec);
        recordingHiveMetastore = new RecordingHiveMetastore((HiveMetastore)new UnimplementedHiveMetastore(), recording);
        recording.loadRecording();
        this.validateMetadata((HiveMetastore)recordingHiveMetastore);
        this.validatePartitionSubset((HiveMetastore)recordingHiveMetastore);
    }

    public static JsonCodec<HiveMetastoreRecording.Recording> createJsonCodec() {
        ObjectMapperProvider objectMapperProvider = new ObjectMapperProvider();
        TypeDeserializer typeDeserializer = new TypeDeserializer((TypeManager)new TestingTypeManager());
        objectMapperProvider.setJsonDeserializers((Map)ImmutableMap.of(Block.class, (Object)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)new HiveBlockEncodingSerde()), Type.class, (Object)typeDeserializer));
        objectMapperProvider.setJsonSerializers((Map)ImmutableMap.of(Block.class, (Object)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)new HiveBlockEncodingSerde())));
        JsonCodec jsonCodec = new JsonCodecFactory((Provider)objectMapperProvider).jsonCodec(HiveMetastoreRecording.Recording.class);
        return jsonCodec;
    }

    private void validateMetadata(HiveMetastore hiveMetastore) {
        Assert.assertEquals((Object)hiveMetastore.getDatabase("database"), Optional.of(DATABASE));
        Assert.assertEquals((Collection)hiveMetastore.getAllDatabases(), (Collection)ImmutableList.of((Object)"database"));
        Assert.assertEquals((Object)hiveMetastore.getTable("database", "table"), Optional.of(TABLE));
        Assert.assertEquals((Object)hiveMetastore.getTableStatistics(TABLE), (Object)PARTITION_STATISTICS);
        Assert.assertEquals((Map)hiveMetastore.getPartitionStatistics(TABLE, (List)ImmutableList.of((Object)PARTITION, (Object)OTHER_PARTITION)), (Map)ImmutableMap.of((Object)"column=value", (Object)PARTITION_STATISTICS, (Object)"column=other_value", (Object)PARTITION_STATISTICS));
        Assert.assertEquals((Collection)hiveMetastore.getAllTables("database"), (Collection)ImmutableList.of((Object)"table"));
        Assert.assertEquals((Collection)hiveMetastore.getTablesWithParameter("database", "param", "value3"), (Collection)ImmutableList.of((Object)"table"));
        Assert.assertEquals((Collection)hiveMetastore.getAllViews("database"), (Collection)ImmutableList.of());
        Assert.assertEquals((Object)hiveMetastore.getPartition(TABLE, (List)ImmutableList.of((Object)"value")), Optional.of(PARTITION));
        Assert.assertEquals((Object)hiveMetastore.getPartitionNamesByFilter("database", "table", PARTITION_COLUMN_NAMES, TupleDomain.all()), Optional.of(ImmutableList.of((Object)"value")));
        Assert.assertEquals((Object)hiveMetastore.getPartitionNamesByFilter("database", "table", PARTITION_COLUMN_NAMES, TUPLE_DOMAIN), Optional.of(ImmutableList.of((Object)"value")));
        Assert.assertEquals((Map)hiveMetastore.getPartitionsByNames(TABLE, (List)ImmutableList.of((Object)"column=value", (Object)"column=other_value")), (Map)ImmutableMap.of((Object)"column=value", Optional.of(PARTITION), (Object)"column=other_value", Optional.of(OTHER_PARTITION)));
        Assert.assertEquals((Set)hiveMetastore.listTablePrivileges("database", "table", Optional.of("owner"), Optional.of(new HivePrincipal(PrincipalType.USER, "user"))), (Set)ImmutableSet.of((Object)PRIVILEGE_INFO));
        Assert.assertEquals((Set)hiveMetastore.listRoles(), (Set)ImmutableSet.of((Object)"role"));
        Assert.assertEquals((Set)hiveMetastore.listRoleGrants(new HivePrincipal(PrincipalType.USER, "user")), (Set)ImmutableSet.of((Object)ROLE_GRANT));
        Assert.assertEquals((Set)hiveMetastore.listGrantedPrincipals("role"), (Set)ImmutableSet.of((Object)ROLE_GRANT));
    }

    private void validatePartitionSubset(HiveMetastore hiveMetastore) {
        Assert.assertEquals((Map)hiveMetastore.getPartitionStatistics(TABLE, (List)ImmutableList.of((Object)PARTITION)), (Map)ImmutableMap.of((Object)"column=value", (Object)PARTITION_STATISTICS));
        Assert.assertEquals((Map)hiveMetastore.getPartitionStatistics(TABLE, (List)ImmutableList.of((Object)OTHER_PARTITION)), (Map)ImmutableMap.of((Object)"column=other_value", (Object)PARTITION_STATISTICS));
        Assert.assertEquals((Map)hiveMetastore.getPartitionsByNames(TABLE, (List)ImmutableList.of((Object)"column=value")), (Map)ImmutableMap.of((Object)"column=value", Optional.of(PARTITION)));
        Assert.assertEquals((Map)hiveMetastore.getPartitionsByNames(TABLE, (List)ImmutableList.of((Object)"column=other_value")), (Map)ImmutableMap.of((Object)"column=other_value", Optional.of(OTHER_PARTITION)));
    }

    private static class TestingHiveMetastore
    extends UnimplementedHiveMetastore {
        private TestingHiveMetastore() {
        }

        @Override
        public Optional<Database> getDatabase(String databaseName) {
            if (databaseName.equals("database")) {
                return Optional.of(DATABASE);
            }
            return Optional.empty();
        }

        @Override
        public List<String> getAllDatabases() {
            return ImmutableList.of((Object)"database");
        }

        @Override
        public Optional<Table> getTable(String databaseName, String tableName) {
            if (databaseName.equals("database") && tableName.equals("table")) {
                return Optional.of(TABLE);
            }
            return Optional.empty();
        }

        @Override
        public PartitionStatistics getTableStatistics(Table table) {
            if (table.getDatabaseName().equals("database") && table.getTableName().equals("table")) {
                return PARTITION_STATISTICS;
            }
            return new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }

        @Override
        public Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<Partition> partitions) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            if (table.getDatabaseName().equals("database") && table.getTableName().equals("table")) {
                if (partitions.stream().anyMatch(partition -> ((String)partition.getValues().get(0)).equals("value"))) {
                    result.put((Object)"column=value", (Object)PARTITION_STATISTICS);
                }
                if (partitions.stream().anyMatch(partition -> ((String)partition.getValues().get(0)).equals("other_value"))) {
                    result.put((Object)"column=other_value", (Object)PARTITION_STATISTICS);
                }
            }
            return result.buildOrThrow();
        }

        @Override
        public List<String> getAllTables(String databaseName) {
            if (databaseName.equals("database")) {
                return ImmutableList.of((Object)"table");
            }
            return ImmutableList.of();
        }

        @Override
        public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
            if (databaseName.equals("database") && parameterKey.equals("param") && parameterValue.equals("value3")) {
                return ImmutableList.of((Object)"table");
            }
            return ImmutableList.of();
        }

        @Override
        public List<String> getAllViews(String databaseName) {
            return ImmutableList.of();
        }

        @Override
        public void dropDatabase(String databaseName, boolean deleteData) {
        }

        @Override
        public Optional<Partition> getPartition(Table table, List<String> partitionValues) {
            if (table.getDatabaseName().equals("database") && table.getTableName().equals("table")) {
                if (partitionValues.equals(ImmutableList.of((Object)"value"))) {
                    return Optional.of(PARTITION);
                }
                if (partitionValues.equals(ImmutableList.of((Object)"other_value"))) {
                    return Optional.of(OTHER_PARTITION);
                }
            }
            return Optional.empty();
        }

        @Override
        public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
            Domain filterDomain = (Domain)((Map)partitionKeysFilter.getDomains().get()).get(TABLE_COLUMN.getName());
            if (databaseName.equals("database") && tableName.equals("table") && (filterDomain == null || filterDomain.equals((Object)PARTITION_COLUMN_EQUAL_DOMAIN))) {
                return Optional.of(ImmutableList.of((Object)"value"));
            }
            return Optional.empty();
        }

        @Override
        public Map<String, Optional<Partition>> getPartitionsByNames(Table table, List<String> partitionNames) {
            ImmutableMap.Builder result = ImmutableMap.builder();
            if (table.getDatabaseName().equals("database") && table.getTableName().equals("table")) {
                if (partitionNames.contains("column=value")) {
                    result.put((Object)"column=value", Optional.of(PARTITION));
                }
                if (partitionNames.contains("column=other_value")) {
                    result.put((Object)"column=other_value", Optional.of(OTHER_PARTITION));
                }
            }
            return result.buildOrThrow();
        }

        @Override
        public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
            if (databaseName.equals("database") && tableName.equals("table") && principal.get().getType() == PrincipalType.USER && principal.get().getName().equals("user")) {
                return ImmutableSet.of((Object)PRIVILEGE_INFO);
            }
            return ImmutableSet.of();
        }

        @Override
        public Set<String> listRoles() {
            return ImmutableSet.of((Object)"role");
        }

        @Override
        public Set<RoleGrant> listGrantedPrincipals(String role) {
            return ImmutableSet.of((Object)ROLE_GRANT);
        }

        @Override
        public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
            return ImmutableSet.of((Object)ROLE_GRANT);
        }
    }
}

