/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.PrincipalPrivilegeSet;
import io.trino.hive.thrift.metastore.PrincipalType;
import io.trino.hive.thrift.metastore.Table;
import io.trino.plugin.hive.HiveBasicStatistics;
import io.trino.plugin.hive.HiveColumnStatisticType;
import io.trino.plugin.hive.PartitionStatistics;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.PartitionWithStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.type.Type;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.metastore.TableType;

public class InMemoryThriftMetastore
implements ThriftMetastore {
    @GuardedBy(value="this")
    private final Map<String, Database> databases = new HashMap<String, Database>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Table> relations = new HashMap<SchemaTableName, Table>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Table> views = new HashMap<SchemaTableName, Table>();
    @GuardedBy(value="this")
    private final Map<PartitionName, io.trino.hive.thrift.metastore.Partition> partitions = new HashMap<PartitionName, io.trino.hive.thrift.metastore.Partition>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, PartitionStatistics> columnStatistics = new HashMap<SchemaTableName, PartitionStatistics>();
    @GuardedBy(value="this")
    private final Map<PartitionName, PartitionStatistics> partitionColumnStatistics = new HashMap<PartitionName, PartitionStatistics>();
    @GuardedBy(value="this")
    private final Map<PrincipalTableKey, Set<HivePrivilegeInfo>> tablePrivileges = new HashMap<PrincipalTableKey, Set<HivePrivilegeInfo>>();
    private final File baseDirectory;
    private final boolean assumeCanonicalPartitionKeys;

    public InMemoryThriftMetastore(File baseDirectory, ThriftMetastoreConfig metastoreConfig) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory, "baseDirectory is null");
        this.assumeCanonicalPartitionKeys = Objects.requireNonNull(metastoreConfig).isAssumeCanonicalPartitionKeys();
        Preconditions.checkArgument((!baseDirectory.exists() ? 1 : 0) != 0, (Object)"Base directory already exists");
        Preconditions.checkArgument((boolean)baseDirectory.mkdirs(), (Object)"Could not create base directory");
    }

    public synchronized void createDatabase(Database database) {
        File directory;
        Objects.requireNonNull(database, "database is null");
        if (database.getLocationUri() != null) {
            directory = new File(URI.create(database.getLocationUri()));
        } else {
            directory = new File(this.baseDirectory, database.getName() + ".db");
            database = database.deepCopy();
            database.setLocationUri(directory.toURI().toString());
        }
        Preconditions.checkArgument((!directory.exists() ? 1 : 0) != 0, (Object)"Database directory already exists");
        Preconditions.checkArgument((boolean)InMemoryThriftMetastore.isParentDir(directory, this.baseDirectory), (Object)"Database directory must be inside of the metastore base directory");
        Preconditions.checkArgument((boolean)directory.mkdirs(), (Object)"Could not create database directory");
        if (this.databases.putIfAbsent(database.getName(), database) != null) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
    }

    public synchronized void dropDatabase(String databaseName, boolean deleteData) {
        if (!this.databases.containsKey(databaseName)) {
            throw new SchemaNotFoundException(databaseName);
        }
        if (!this.getAllTables(databaseName).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + databaseName);
        }
        this.databases.remove(databaseName);
    }

    public synchronized void alterDatabase(String databaseName, Database newDatabase) {
        String newDatabaseName = newDatabase.getName();
        if (databaseName.equals(newDatabaseName)) {
            if (this.databases.replace(databaseName, newDatabase) == null) {
                throw new SchemaNotFoundException(databaseName);
            }
            return;
        }
        Database database = this.databases.get(databaseName);
        if (database == null) {
            throw new SchemaNotFoundException(databaseName);
        }
        if (this.databases.putIfAbsent(newDatabaseName, database) != null) {
            throw new SchemaAlreadyExistsException(newDatabaseName);
        }
        this.databases.remove(databaseName);
        InMemoryThriftMetastore.rewriteKeys(this.relations, name -> new SchemaTableName(newDatabaseName, name.getTableName()));
        InMemoryThriftMetastore.rewriteKeys(this.views, name -> new SchemaTableName(newDatabaseName, name.getTableName()));
        InMemoryThriftMetastore.rewriteKeys(this.partitions, name -> name.withSchemaName(newDatabaseName));
        InMemoryThriftMetastore.rewriteKeys(this.tablePrivileges, name -> name.withDatabase(newDatabaseName));
    }

    public synchronized List<String> getAllDatabases() {
        return ImmutableList.copyOf(this.databases.keySet());
    }

    public synchronized void createTable(Table table) {
        PrincipalPrivilegeSet privileges;
        TableType tableType = TableType.valueOf((String)table.getTableType());
        Preconditions.checkArgument((boolean)EnumSet.of(TableType.MANAGED_TABLE, TableType.EXTERNAL_TABLE, TableType.VIRTUAL_VIEW).contains(tableType), (String)"Invalid table type: %s", (Object)tableType);
        if (tableType == TableType.VIRTUAL_VIEW) {
            Preconditions.checkArgument((table.getSd().getLocation() == null ? 1 : 0) != 0, (Object)"Storage location for view must be null");
        } else {
            File directory = new File(new Path(table.getSd().getLocation()).toUri());
            Preconditions.checkArgument((boolean)directory.exists(), (Object)"Table directory does not exist");
            if (tableType == TableType.MANAGED_TABLE) {
                Preconditions.checkArgument((boolean)InMemoryThriftMetastore.isParentDir(directory, this.baseDirectory), (Object)"Table directory must be inside of the metastore base directory");
            }
        }
        SchemaTableName schemaTableName = new SchemaTableName(table.getDbName(), table.getTableName());
        Table tableCopy = table.deepCopy();
        if (this.relations.putIfAbsent(schemaTableName, tableCopy) != null) {
            throw new TableAlreadyExistsException(schemaTableName);
        }
        if (tableType == TableType.VIRTUAL_VIEW) {
            this.views.put(schemaTableName, tableCopy);
        }
        if ((privileges = table.getPrivileges()) != null) {
            throw new UnsupportedOperationException();
        }
    }

    public synchronized void dropTable(String databaseName, String tableName, boolean deleteData) {
        List<String> locations = InMemoryThriftMetastore.listAllDataPaths(this, databaseName, tableName);
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        Table table = this.relations.remove(schemaTableName);
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        this.views.remove(schemaTableName);
        this.partitions.keySet().removeIf(partitionName -> partitionName.matches(databaseName, tableName));
        if (deleteData && table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
            for (String location : locations) {
                if (location == null) continue;
                File directory = new File(new Path(location).toUri());
                Preconditions.checkArgument((boolean)InMemoryThriftMetastore.isParentDir(directory, this.baseDirectory), (Object)"Table directory must be inside of the metastore base directory");
                InMemoryThriftMetastore.deleteDirectory(directory);
            }
        }
    }

    private static List<String> listAllDataPaths(ThriftMetastore metastore, String schemaName, String tableName) {
        List partitionColumnNames;
        Optional partitionNames;
        ImmutableList.Builder locations = ImmutableList.builder();
        Table table = (Table)metastore.getTable(schemaName, tableName).get();
        if (table.getSd().getLocation() != null) {
            locations.add((Object)table.getSd().getLocation());
        }
        if ((partitionNames = metastore.getPartitionNamesByFilter(schemaName, tableName, partitionColumnNames = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList()), TupleDomain.all())).isPresent()) {
            metastore.getPartitionsByNames(schemaName, tableName, (List)partitionNames.get()).stream().map(partition -> partition.getSd().getLocation()).filter(location -> !location.startsWith(table.getSd().getLocation())).forEach(arg_0 -> ((ImmutableList.Builder)locations).add(arg_0));
        }
        return locations.build();
    }

    public synchronized void alterTable(String databaseName, String tableName, Table newTable) {
        SchemaTableName oldName = new SchemaTableName(databaseName, tableName);
        SchemaTableName newName = new SchemaTableName(newTable.getDbName(), newTable.getTableName());
        if (oldName.equals((Object)newName)) {
            if (this.relations.replace(oldName, newTable) == null) {
                throw new TableNotFoundException(oldName);
            }
            return;
        }
        Table table = this.relations.get(oldName);
        if (table == null) {
            throw new TableNotFoundException(oldName);
        }
        if (this.relations.putIfAbsent(newName, newTable) != null) {
            throw new TableAlreadyExistsException(newName);
        }
        this.relations.remove(oldName);
    }

    public void alterTransactionalTable(Table table, long transactionId, long writeId) {
        this.alterTable(table.getDbName(), table.getTableName(), table);
    }

    public synchronized List<String> getAllTables(String databaseName) {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.relations.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return tables.build();
    }

    public synchronized List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        Objects.requireNonNull(parameterKey, "parameterKey is null");
        Objects.requireNonNull(parameterValue, "parameterValue is null");
        return (List)this.relations.entrySet().stream().filter(entry -> ((SchemaTableName)entry.getKey()).getSchemaName().equals(databaseName) && parameterValue.equals(((Table)entry.getValue()).getParameters().get(parameterKey))).map(entry -> ((SchemaTableName)entry.getKey()).getTableName()).collect(ImmutableList.toImmutableList());
    }

    public synchronized List<String> getAllViews(String databaseName) {
        ImmutableList.Builder tables = ImmutableList.builder();
        for (SchemaTableName schemaTableName : this.views.keySet()) {
            if (!schemaTableName.getSchemaName().equals(databaseName)) continue;
            tables.add((Object)schemaTableName.getTableName());
        }
        return tables.build();
    }

    public synchronized Optional<Database> getDatabase(String databaseName) {
        return Optional.ofNullable(this.databases.get(databaseName));
    }

    public synchronized void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        for (PartitionWithStatistics partitionWithStatistics : partitionsWithStatistics) {
            io.trino.hive.thrift.metastore.Partition partition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partitionWithStatistics.getPartition());
            if (partition.getParameters() == null) {
                partition.setParameters((Map)ImmutableMap.of());
            }
            PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionWithStatistics.getPartitionName());
            this.partitions.put(partitionKey, partition);
            this.partitionColumnStatistics.put(partitionKey, partitionWithStatistics.getStatistics());
        }
    }

    public synchronized void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.partitions.entrySet().removeIf(entry -> ((PartitionName)entry.getKey()).matches(databaseName, tableName) && ((io.trino.hive.thrift.metastore.Partition)entry.getValue()).getValues().equals(parts));
    }

    public synchronized void alterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        io.trino.hive.thrift.metastore.Partition partition = ThriftMetastoreUtil.toMetastoreApiPartition((Partition)partitionWithStatistics.getPartition());
        if (partition.getParameters() == null) {
            partition.setParameters((Map)ImmutableMap.of());
        }
        PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionWithStatistics.getPartitionName());
        this.partitions.put(partitionKey, partition);
        this.partitionColumnStatistics.put(partitionKey, partitionWithStatistics.getStatistics());
    }

    public synchronized Optional<io.trino.hive.thrift.metastore.Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        PartitionName name = PartitionName.partition(databaseName, tableName, partitionValues);
        io.trino.hive.thrift.metastore.Partition partition = this.partitions.get(name);
        if (partition == null) {
            return Optional.empty();
        }
        return Optional.of(partition.deepCopy());
    }

    public synchronized Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        Optional parts = MetastoreUtil.partitionKeyFilterToStringList(columnNames, partitionKeysFilter, (boolean)this.assumeCanonicalPartitionKeys);
        if (parts.isEmpty()) {
            return Optional.of(ImmutableList.of());
        }
        return Optional.of((List)this.partitions.entrySet().stream().filter(entry -> InMemoryThriftMetastore.partitionMatches((io.trino.hive.thrift.metastore.Partition)entry.getValue(), databaseName, tableName, (List)parts.get())).map(entry -> ((PartitionName)entry.getKey()).getPartitionName()).collect(ImmutableList.toImmutableList()));
    }

    private static boolean partitionMatches(io.trino.hive.thrift.metastore.Partition partition, String databaseName, String tableName, List<String> parts) {
        if (!partition.getDbName().equals(databaseName) || !partition.getTableName().equals(tableName)) {
            return false;
        }
        List values = partition.getValues();
        if (values.size() != parts.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty() || ((String)values.get(i)).equals(part)) continue;
            return false;
        }
        return true;
    }

    public synchronized List<io.trino.hive.thrift.metastore.Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String name : partitionNames) {
            PartitionName partitionName = PartitionName.partition(databaseName, tableName, name);
            io.trino.hive.thrift.metastore.Partition partition = this.partitions.get(partitionName);
            if (partition == null) {
                return ImmutableList.of();
            }
            builder.add((Object)partition.deepCopy());
        }
        return builder.build();
    }

    public synchronized Optional<Table> getTable(String databaseName, String tableName) {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        return Optional.ofNullable(this.relations.get(schemaTableName));
    }

    public Set<HiveColumnStatisticType> getSupportedColumnStatistics(Type type) {
        return ThriftMetastoreUtil.getSupportedColumnStatistics((Type)type);
    }

    public synchronized PartitionStatistics getTableStatistics(Table table) {
        return this.getTableStatistics(table.getDbName(), table.getTableName());
    }

    private synchronized PartitionStatistics getTableStatistics(String databaseName, String tableName) {
        SchemaTableName schemaTableName = new SchemaTableName(databaseName, tableName);
        PartitionStatistics statistics = this.columnStatistics.get(schemaTableName);
        if (statistics == null) {
            statistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
        }
        return statistics;
    }

    public synchronized Map<String, PartitionStatistics> getPartitionStatistics(Table table, List<io.trino.hive.thrift.metastore.Partition> partitions) {
        List partitionColumns = (List)table.getPartitionKeys().stream().map(FieldSchema::getName).collect(ImmutableList.toImmutableList());
        Set partitionNames = (Set)partitions.stream().map(partition -> FileUtils.makePartName((List)partitionColumns, (List)partition.getValues())).collect(ImmutableSet.toImmutableSet());
        return this.getPartitionStatistics(table.getDbName(), table.getTableName(), partitionNames);
    }

    private synchronized Map<String, PartitionStatistics> getPartitionStatistics(String databaseName, String tableName, Set<String> partitionNames) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            PartitionName partitionKey = PartitionName.partition(databaseName, tableName, partitionName);
            PartitionStatistics statistics = this.partitionColumnStatistics.get(partitionKey);
            if (statistics == null) {
                statistics = new PartitionStatistics(HiveBasicStatistics.createEmptyStatistics(), (Map)ImmutableMap.of());
            }
            result.put((Object)partitionName, (Object)statistics);
        }
        return result.buildOrThrow();
    }

    public synchronized void updateTableStatistics(String databaseName, String tableName, AcidTransaction transaction, Function<PartitionStatistics, PartitionStatistics> update) {
        this.columnStatistics.put(new SchemaTableName(databaseName, tableName), update.apply(this.getTableStatistics(databaseName, tableName)));
    }

    public synchronized void updatePartitionStatistics(Table table, String partitionName, Function<PartitionStatistics, PartitionStatistics> update) {
        PartitionName partitionKey = PartitionName.partition(table.getDbName(), table.getTableName(), partitionName);
        this.partitionColumnStatistics.put(partitionKey, update.apply(this.getPartitionStatistics(table.getDbName(), table.getTableName(), (Set<String>)ImmutableSet.of((Object)partitionName)).get(partitionName)));
    }

    public void createRole(String role, String grantor) {
        throw new UnsupportedOperationException();
    }

    public void dropRole(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<String> listRoles() {
        throw new UnsupportedOperationException();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listGrantedPrincipals(String role) {
        throw new UnsupportedOperationException();
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        throw new UnsupportedOperationException();
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return ImmutableSet.of();
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    private static boolean isParentDir(File directory, File baseDirectory) {
        for (File parent = directory.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(baseDirectory)) continue;
            return true;
        }
        return false;
    }

    private static void deleteDirectory(File dir) {
        try {
            MoreFiles.deleteRecursively((java.nio.file.Path)dir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <K, V> void rewriteKeys(Map<K, V> map, Function<K, K> keyRewriter) {
        for (Object key : ImmutableSet.copyOf(map.keySet())) {
            K newKey = keyRewriter.apply(key);
            if (newKey.equals(key)) continue;
            map.put(newKey, map.remove(key));
        }
    }

    private static class PartitionName {
        private final String schemaName;
        private final String tableName;
        private final List<String> partitionValues;
        private final String partitionName;

        private PartitionName(String schemaName, String tableName, List<String> partitionValues, String partitionName) {
            this.schemaName = schemaName.toLowerCase(Locale.US);
            this.tableName = tableName.toLowerCase(Locale.US);
            this.partitionValues = Objects.requireNonNull(partitionValues, "partitionValues is null");
            this.partitionName = partitionName;
        }

        public static PartitionName partition(String schemaName, String tableName, String partitionName) {
            return new PartitionName(schemaName.toLowerCase(Locale.US), tableName.toLowerCase(Locale.US), HiveUtil.toPartitionValues((String)partitionName), partitionName);
        }

        public static PartitionName partition(String schemaName, String tableName, List<String> partitionValues) {
            return new PartitionName(schemaName.toLowerCase(Locale.US), tableName.toLowerCase(Locale.US), partitionValues, null);
        }

        public String getPartitionName() {
            return Objects.requireNonNull(this.partitionName, "partitionName is null");
        }

        public boolean matches(String schemaName, String tableName) {
            return this.schemaName.equals(schemaName) && this.tableName.equals(tableName);
        }

        public PartitionName withSchemaName(String schemaName) {
            return new PartitionName(schemaName, this.tableName, this.partitionValues, this.partitionName);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.tableName, this.partitionValues);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PartitionName other = (PartitionName)obj;
            return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.partitionValues, other.partitionValues);
        }

        public String toString() {
            return this.schemaName + "/" + this.tableName + "/" + this.partitionName;
        }
    }

    private static class PrincipalTableKey {
        private final String principalName;
        private final PrincipalType principalType;
        private final String database;
        private final String table;

        public PrincipalTableKey(String principalName, PrincipalType principalType, String table, String database) {
            this.principalName = Objects.requireNonNull(principalName, "principalName is null");
            this.principalType = Objects.requireNonNull(principalType, "principalType is null");
            this.table = Objects.requireNonNull(table, "table is null");
            this.database = Objects.requireNonNull(database, "database is null");
        }

        public PrincipalTableKey withDatabase(String database) {
            return new PrincipalTableKey(this.principalName, this.principalType, this.table, database);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrincipalTableKey that = (PrincipalTableKey)o;
            return Objects.equals(this.principalName, that.principalName) && this.principalType == that.principalType && Objects.equals(this.table, that.table) && Objects.equals(this.database, that.database);
        }

        public int hashCode() {
            return Objects.hash(this.principalName, this.principalType, this.table, this.database);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("principalName", (Object)this.principalName).add("principalType", (Object)this.principalType).add("table", (Object)this.table).add("database", (Object)this.database).toString();
        }
    }
}

