/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.hive.thrift.metastore.ColumnStatisticsData;
import io.trino.hive.thrift.metastore.ColumnStatisticsObj;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.EnvironmentContext;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.HiveObjectPrivilege;
import io.trino.hive.thrift.metastore.HiveObjectRef;
import io.trino.hive.thrift.metastore.LockRequest;
import io.trino.hive.thrift.metastore.LockResponse;
import io.trino.hive.thrift.metastore.LongColumnStatsData;
import io.trino.hive.thrift.metastore.NoSuchObjectException;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.PrincipalType;
import io.trino.hive.thrift.metastore.PrivilegeBag;
import io.trino.hive.thrift.metastore.Role;
import io.trino.hive.thrift.metastore.RolePrincipalGrant;
import io.trino.hive.thrift.metastore.SerDeInfo;
import io.trino.hive.thrift.metastore.StorageDescriptor;
import io.trino.hive.thrift.metastore.Table;
import io.trino.plugin.hive.acid.AcidOperation;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.spi.connector.SchemaTableName;
import io.trino.testng.services.ManageTestResources;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;

@ManageTestResources.Suppress(because="close() is no-op and instance's resources are negligible")
public class MockThriftMetastoreClient
implements ThriftMetastoreClient {
    public static final String TEST_DATABASE = "testdb";
    public static final String BAD_DATABASE = "baddb";
    public static final String TEST_TABLE = "testtbl";
    public static final String TEST_PARTITION1_VALUE = "testpartition1";
    public static final String TEST_PARTITION1 = "key=testpartition1";
    public static final String TEST_COLUMN = "column";
    public static final String TEST_PARTITION2 = "key=testpartition2";
    public static final String TEST_PARTITION3 = "key=testpartition3";
    public static final String BAD_PARTITION = "key=badpartition1";
    public static final List<String> TEST_PARTITION_VALUES1 = ImmutableList.of((Object)"testpartition1");
    public static final List<String> TEST_PARTITION_VALUES2 = ImmutableList.of((Object)"testpartition2");
    public static final List<String> TEST_PARTITION_VALUES3 = ImmutableList.of((Object)"testpartition3");
    public static final List<String> TEST_ROLES = ImmutableList.of((Object)"testrole");
    private static final List<RolePrincipalGrant> TEST_ROLE_GRANTS = ImmutableList.of((Object)new RolePrincipalGrant("role1", "user", PrincipalType.USER, false, 0, "grantor1", PrincipalType.USER), (Object)new RolePrincipalGrant("role2", "role1", PrincipalType.ROLE, true, 0, "grantor2", PrincipalType.ROLE));
    public static final List<String> PARTITION_COLUMN_NAMES = ImmutableList.of((Object)"column");
    private static final StorageDescriptor DEFAULT_STORAGE_DESCRIPTOR = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("column", "bigint", "")), "", null, null, false, 0, new SerDeInfo("testtbl", null, (Map)ImmutableMap.of()), null, null, (Map)ImmutableMap.of());
    private final AtomicInteger accessCount = new AtomicInteger();
    private final Map<SchemaTableName, Map<String, ColumnStatisticsObj>> columnStatistics = new HashMap<SchemaTableName, Map<String, ColumnStatisticsObj>>();
    private final Map<SchemaTableName, Map<String, Map<String, ColumnStatisticsObj>>> databaseTablePartitionColumnStatistics = new HashMap<SchemaTableName, Map<String, Map<String, ColumnStatisticsObj>>>();
    private boolean throwException;

    public MockThriftMetastoreClient() {
        this.mockColumnStats(TEST_DATABASE, TEST_TABLE, (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)TEST_COLUMN, (Object)MockThriftMetastoreClient.createLongColumnStats()));
        this.mockPartitionColumnStats(TEST_DATABASE, TEST_TABLE, TEST_PARTITION1, (Map<String, ColumnStatisticsData>)ImmutableMap.of((Object)TEST_COLUMN, (Object)MockThriftMetastoreClient.createLongColumnStats()));
    }

    public void mockColumnStats(String database, String table, Map<String, ColumnStatisticsData> columnStatistics) {
        this.columnStatistics.compute(new SchemaTableName(database, table), (ignored, oldColumnStats) -> {
            if (oldColumnStats == null) {
                oldColumnStats = new HashMap();
            }
            oldColumnStats.putAll(Maps.transformEntries((Map)columnStatistics, (columnName, stats) -> {
                ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
                statsObj.setColName(columnName);
                statsObj.setStatsData(stats);
                return statsObj;
            }));
            return oldColumnStats;
        });
    }

    public void mockPartitionColumnStats(String database, String table, String partitionName, Map<String, ColumnStatisticsData> columnStatistics) {
        Map tablePartitionColumnStatistics = this.databaseTablePartitionColumnStatistics.computeIfAbsent(new SchemaTableName(database, table), key -> new HashMap());
        tablePartitionColumnStatistics.compute(partitionName, (ignored, oldColumnStats) -> {
            if (oldColumnStats == null) {
                oldColumnStats = new HashMap();
            }
            oldColumnStats.putAll(Maps.transformEntries((Map)columnStatistics, (columnName, stats) -> {
                ColumnStatisticsObj statsObj = new ColumnStatisticsObj();
                statsObj.setColName(columnName);
                statsObj.setStatsData(stats);
                return statsObj;
            }));
            return oldColumnStats;
        });
    }

    private static ColumnStatisticsData createLongColumnStats() {
        ColumnStatisticsData data = new ColumnStatisticsData();
        data.setLongStats(new LongColumnStatsData());
        return data;
    }

    private static ColumnStatisticsObj createTestStats() {
        ColumnStatisticsObj stats = new ColumnStatisticsObj();
        ColumnStatisticsData data = new ColumnStatisticsData();
        data.setLongStats(new LongColumnStatsData());
        stats.setStatsData(data);
        stats.setColName(TEST_COLUMN);
        return stats;
    }

    public void setThrowException(boolean throwException) {
        this.throwException = throwException;
    }

    public int getAccessCount() {
        return this.accessCount.get();
    }

    public List<String> getAllDatabases() {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return ImmutableList.of((Object)TEST_DATABASE);
    }

    public List<String> getAllTables(String dbName) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE)) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)TEST_TABLE);
    }

    public List<String> getAllViews(String databaseName) {
        throw new UnsupportedOperationException();
    }

    public List<String> getTablesWithParameter(String databaseName, String parameterKey, String parameterValue) {
        throw new UnsupportedOperationException();
    }

    public Database getDatabase(String name) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!name.equals(TEST_DATABASE)) {
            throw new NoSuchObjectException();
        }
        return new Database(TEST_DATABASE, null, null, null);
    }

    public Table getTable(String dbName, String tableName) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return new Table(TEST_TABLE, TEST_DATABASE, "", 0, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (List)ImmutableList.of((Object)new FieldSchema("key", "string", null)), (Map)ImmutableMap.of(), "", "", TableType.MANAGED_TABLE.name());
    }

    public List<FieldSchema> getFields(String databaseName, String tableName) {
        return ImmutableList.of((Object)new FieldSchema("key", "string", null));
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String databaseName, String tableName, List<String> columnNames) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        Map<String, ColumnStatisticsObj> columnStatistics = this.columnStatistics.get(new SchemaTableName(databaseName, tableName));
        if (columnStatistics == null || !columnStatistics.keySet().containsAll(columnNames)) {
            throw new NoSuchObjectException();
        }
        return (List)columnNames.stream().map(columnStatistics::get).collect(ImmutableList.toImmutableList());
    }

    public void setTableColumnStatistics(String databaseName, String tableName, List<ColumnStatisticsObj> statistics) {
        throw new UnsupportedOperationException();
    }

    public void deleteTableColumnStatistics(String databaseName, String tableName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String databaseName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        Map<String, Map<String, ColumnStatisticsObj>> tablePartitionColumnStatistics = this.databaseTablePartitionColumnStatistics.get(new SchemaTableName(databaseName, tableName));
        if (tablePartitionColumnStatistics == null) {
            throw new NoSuchObjectException();
        }
        for (String partition : partitionNames) {
            Map<String, ColumnStatisticsObj> columnStatistics = tablePartitionColumnStatistics.get(partition);
            if (columnStatistics == null || !columnStatistics.keySet().containsAll(columnNames)) {
                throw new NoSuchObjectException();
            }
            result.put((Object)partition, (Object)ImmutableList.copyOf(columnStatistics.values()));
        }
        return result.buildOrThrow();
    }

    public void setPartitionColumnStatistics(String databaseName, String tableName, String partitionName, List<ColumnStatisticsObj> statistics) {
        this.accessCount.incrementAndGet();
    }

    public void deletePartitionColumnStatistics(String databaseName, String tableName, String partitionName, String columnName) {
        throw new UnsupportedOperationException();
    }

    public List<String> getPartitionNames(String dbName, String tableName) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2, (Object)TEST_PARTITION3);
    }

    public List<String> getPartitionNamesFiltered(String dbName, String tableName, List<String> partValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!dbName.equals(TEST_DATABASE) || !tableName.equals(TEST_TABLE)) {
            throw new NoSuchObjectException();
        }
        return ImmutableList.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2, (Object)TEST_PARTITION3);
    }

    public Partition getPartition(String dbName, String tableName, List<String> partitionValues) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of(TEST_PARTITION_VALUES1, TEST_PARTITION_VALUES2, TEST_PARTITION_VALUES3).contains(partitionValues))) {
            throw new NoSuchObjectException();
        }
        return new Partition(partitionValues, TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
    }

    public List<Partition> getPartitionsByNames(String dbName, String tableName, List<String> names) throws TException {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new RuntimeException();
        }
        if (!(dbName.equals(TEST_DATABASE) && tableName.equals(TEST_TABLE) && ImmutableSet.of((Object)TEST_PARTITION1, (Object)TEST_PARTITION2, (Object)TEST_PARTITION3).containsAll(names))) {
            throw new NoSuchObjectException();
        }
        return (List)names.stream().map(MockThriftMetastoreClient::getPartitionsByNamesUnchecked).collect(ImmutableList.toImmutableList());
    }

    private static Partition getPartitionsByNamesUnchecked(String name) {
        try {
            return new Partition((List)ImmutableList.copyOf((Collection)Warehouse.getPartValuesFromPartName((String)name)), TEST_DATABASE, TEST_TABLE, 0, 0, DEFAULT_STORAGE_DESCRIPTOR, (Map)ImmutableMap.of());
        }
        catch (MetaException e) {
            throw new RuntimeException(e);
        }
    }

    public void createDatabase(Database database) {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String databaseName, boolean deleteData, boolean cascade) {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String databaseName, Database database) {
        throw new UnsupportedOperationException();
    }

    public void createTable(Table table) {
        throw new UnsupportedOperationException();
    }

    public void dropTable(String databaseName, String name, boolean deleteData) {
    }

    public void alterTableWithEnvironmentContext(String databaseName, String tableName, Table newTable, EnvironmentContext context) {
    }

    public int addPartitions(List<Partition> newPartitions) {
        throw new UnsupportedOperationException();
    }

    public boolean dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(String databaseName, String tableName, Partition partition) {
        this.accessCount.incrementAndGet();
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        throw new UnsupportedOperationException();
    }

    public List<HiveObjectPrivilege> listPrivileges(String principalName, PrincipalType principalType, HiveObjectRef hiveObjectRef) {
        throw new UnsupportedOperationException();
    }

    public List<String> getRoleNames() {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return TEST_ROLES;
    }

    public void createRole(String role, String grantor) {
    }

    public void dropRole(String role) {
    }

    public boolean grantPrivileges(PrivilegeBag privilegeBag) {
        throw new UnsupportedOperationException();
    }

    public boolean revokePrivileges(PrivilegeBag privilegeBag, boolean revokeGrantOption) {
        throw new UnsupportedOperationException();
    }

    public void grantRole(String role, String granteeName, PrincipalType granteeType, String grantorName, PrincipalType grantorType, boolean grantOption) {
    }

    public void revokeRole(String role, String granteeName, PrincipalType granteeType, boolean grantOption) {
    }

    public List<RolePrincipalGrant> listGrantedPrincipals(String role) {
        throw new UnsupportedOperationException();
    }

    public List<RolePrincipalGrant> listRoleGrants(String name, PrincipalType principalType) {
        this.accessCount.incrementAndGet();
        if (this.throwException) {
            throw new IllegalStateException();
        }
        return TEST_ROLE_GRANTS;
    }

    public void close() {
    }

    public void setUGI(String userName) {
    }

    public long openTransaction(String user) {
        throw new UnsupportedOperationException();
    }

    public void commitTransaction(long transactionId) {
        throw new UnsupportedOperationException();
    }

    public void sendTransactionHeartbeat(long transactionId) {
        throw new UnsupportedOperationException();
    }

    public LockResponse acquireLock(LockRequest lockRequest) {
        throw new UnsupportedOperationException();
    }

    public LockResponse checkLock(long lockId) {
        throw new UnsupportedOperationException();
    }

    public void unlock(long lockId) {
        throw new UnsupportedOperationException();
    }

    public String getValidWriteIds(List<String> tableList, long currentTransactionId) {
        throw new UnsupportedOperationException();
    }

    public String getConfigValue(String name, String defaultValue) {
        throw new UnsupportedOperationException();
    }

    public void alterPartitions(String dbName, String tableName, List<Partition> partitions, long writeId) {
        throw new UnsupportedOperationException();
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        throw new UnsupportedOperationException();
    }

    public void alterTransactionalTable(Table table, long transactionId, long writeId, EnvironmentContext context) {
        throw new UnsupportedOperationException();
    }

    public String getDelegationToken(String userName) {
        throw new UnsupportedOperationException();
    }
}

