/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import org.apache.thrift.transport.TTransportException;

public class MockThriftMetastoreClientFactory
implements ThriftMetastoreClientFactory {
    private final Map<HostAndPort, Optional<ThriftMetastoreClient>> clients;

    public MockThriftMetastoreClientFactory(Map<String, Optional<ThriftMetastoreClient>> clients) {
        this.clients = (Map)clients.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> MockThriftMetastoreClientFactory.createHostAndPort((String)entry.getKey()), Map.Entry::getValue));
    }

    public ThriftMetastoreClient create(HostAndPort address, Optional<String> delegationToken) throws TTransportException {
        Preconditions.checkArgument((boolean)delegationToken.isEmpty(), (Object)"delegation token is not supported");
        return (ThriftMetastoreClient)this.clients.getOrDefault(address, Optional.empty()).orElseThrow(() -> new TTransportException(3));
    }

    private static HostAndPort createHostAndPort(String url) {
        URI uri = URI.create(url);
        Preconditions.checkArgument((boolean)"thrift".equals(uri.getScheme()), (String)"Invalid URL: %s", (Object)url);
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort());
    }
}

