/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.metastore.thrift.CoalescingCounter;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCoalescingCounter {
    @Test
    public void test() {
        TestingClock clock = new TestingClock();
        CoalescingCounter counter = new CoalescingCounter((Clock)clock, new Duration(1.0, TimeUnit.SECONDS));
        Assert.assertEquals((long)counter.get(), (long)0L);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)1L);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)1L);
        Assert.assertEquals((long)counter.get(), (long)1L);
        clock.increment(100L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)1L);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)1L);
        Assert.assertEquals((long)counter.get(), (long)1L);
        clock.increment(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)2L);
        Assert.assertEquals((long)counter.incrementAndGet(), (long)2L);
        Assert.assertEquals((long)counter.get(), (long)2L);
    }

    private static final class TestingClock
    extends Clock {
        private final ZoneId zone;
        private Instant instant;

        public TestingClock() {
            this(ZoneOffset.UTC);
        }

        public TestingClock(ZoneId zone) {
            this(zone, Instant.ofEpochMilli(1575000618963L));
        }

        private TestingClock(ZoneId zone, Instant instant) {
            this.zone = Objects.requireNonNull(zone, "zone is null");
            this.instant = Objects.requireNonNull(instant, "instant is null");
        }

        @Override
        public ZoneId getZone() {
            return this.zone;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return new TestingClock(zone, this.instant);
        }

        @Override
        public Instant instant() {
            return this.instant;
        }

        public void increment(long delta, TimeUnit unit) {
            Preconditions.checkArgument((delta >= 0L ? 1 : 0) != 0, (Object)"delta is negative");
            this.instant = this.instant.plusNanos(unit.toNanos(delta));
        }
    }
}

