/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import io.trino.hive.thrift.metastore.GetOpenTxnsResponse;
import io.trino.plugin.hive.metastore.thrift.TxnUtils;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTxnUtils {
    @Test
    public void testCreateValidReadTxnList() {
        BitSet aborted = new BitSet();
        aborted.set(2, 4);
        ByteBuffer abortedBits = ByteBuffer.wrap(aborted.toByteArray());
        long currentTxn = 7L;
        GetOpenTxnsResponse trinoResponse = new GetOpenTxnsResponse(6L, List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)), abortedBits);
        String trinoValue = TxnUtils.createValidReadTxnList((GetOpenTxnsResponse)trinoResponse, (long)currentTxn);
        org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse hiveResponse = new org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse(trinoResponse.getTxnHighWaterMark(), trinoResponse.getOpenTxns(), trinoResponse.bufferForAbortedBits());
        String hiveValue = org.apache.hadoop.hive.metastore.txn.TxnUtils.createValidReadTxnList((org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse)hiveResponse, (long)currentTxn).toString();
        Assertions.assertThat((String)trinoValue).isEqualTo(hiveValue).isEqualTo("6:1:1,2,0:3");
    }

    @Test
    public void testCreateValidTxnWriteIdList() {
        BitSet aborted = new BitSet();
        aborted.set(2, 4);
        ByteBuffer abortedBits = ByteBuffer.wrap(aborted.toByteArray());
        long currentTxn = 7L;
        io.trino.hive.thrift.metastore.TableValidWriteIds table1 = new io.trino.hive.thrift.metastore.TableValidWriteIds("abc.xyz", 6L, List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)), abortedBits);
        io.trino.hive.thrift.metastore.TableValidWriteIds table2 = new io.trino.hive.thrift.metastore.TableValidWriteIds("foo.bar", 5L, List.of(Long.valueOf(3L), Long.valueOf(4L)), ByteBuffer.wrap(new byte[0]));
        table2.setMinOpenWriteId(2L);
        List<io.trino.hive.thrift.metastore.TableValidWriteIds> trinoIds = List.of(table1, table2);
        String trinoValue = TxnUtils.createValidTxnWriteIdList((long)currentTxn, trinoIds);
        List<TableValidWriteIds> hiveIds = trinoIds.stream().map(TestTxnUtils::toHiveTableValidWriteIds).toList();
        String hiveValue = org.apache.hadoop.hive.metastore.txn.TxnUtils.createValidTxnWriteIdList((Long)currentTxn, hiveIds).toString();
        Assertions.assertThat((String)trinoValue).isEqualTo(hiveValue).isEqualTo("7$foo.bar:5:2:3,4:$abc.xyz:6:9223372036854775807:1,2:3");
    }

    @Test
    public void testCreateValidWriteIdList() {
        BitSet aborted = new BitSet();
        aborted.set(2, 4);
        ByteBuffer abortedBits = ByteBuffer.wrap(aborted.toByteArray());
        io.trino.hive.thrift.metastore.TableValidWriteIds trinoIds = new io.trino.hive.thrift.metastore.TableValidWriteIds("abc.xyz", 6L, List.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)), abortedBits);
        String trinoValue = TxnUtils.createValidWriteIdList((io.trino.hive.thrift.metastore.TableValidWriteIds)trinoIds);
        TableValidWriteIds hiveIds = TestTxnUtils.toHiveTableValidWriteIds(trinoIds);
        String hiveValue = org.apache.hadoop.hive.metastore.txn.TxnUtils.createValidReaderWriteIdList((TableValidWriteIds)hiveIds).toString();
        Assertions.assertThat((String)trinoValue).isEqualTo(hiveValue).isEqualTo("abc.xyz:6:9223372036854775807:1,2:3");
    }

    private static TableValidWriteIds toHiveTableValidWriteIds(io.trino.hive.thrift.metastore.TableValidWriteIds ids) {
        TableValidWriteIds result = new TableValidWriteIds(ids.getFullTableName(), ids.getWriteIdHighWaterMark(), ids.getInvalidWriteIds(), ids.bufferForAbortedBits());
        if (ids.isSetMinOpenWriteId()) {
            result.setMinOpenWriteId(ids.getMinOpenWriteId());
        }
        return result;
    }
}

