/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.trino.filesystem.TrinoInputFile;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcDeleteDeltaPageSource {
    @Test
    public void testReadingDeletedRows() throws Exception {
        File deleteDeltaFile = new File(Resources.getResource((String)"fullacid_delete_delta_test/delete_delta_0000004_0000004_0000/bucket_00000").toURI());
        TrinoInputFile inputFile = HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY.create(ConnectorIdentity.ofUser((String)"test")).newInputFile(deleteDeltaFile.toURI().toString());
        OrcDeleteDeltaPageSourceFactory pageSourceFactory = new OrcDeleteDeltaPageSourceFactory(new OrcReaderOptions(), new FileFormatDataSourceStats());
        ConnectorPageSource pageSource = (ConnectorPageSource)pageSourceFactory.createPageSource(inputFile).orElseThrow();
        MaterializedResult materializedRows = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT));
        Assert.assertEquals((int)materializedRows.getRowCount(), (int)1);
        AcidOutputFormat.Options bucketOptions = new AcidOutputFormat.Options(ConfigurationInstantiator.newEmptyConfiguration()).bucket(0);
        Assert.assertEquals(materializedRows.getMaterializedRows().get(0), (Object)new MaterializedRow(5, new Object[]{2L, BucketCodec.V1.encode(bucketOptions), 0L}));
    }
}

