/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.testing.MaterializedResult;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOrcDeletedRows {
    private Path partitionDirectory;
    private Block rowIdBlock;
    private Block bucketBlock;

    @BeforeClass
    public void setUp() {
        this.partitionDirectory = new Path(TestOrcDeletedRows.class.getClassLoader().getResource("fullacid_delete_delta_test") + "/");
        this.rowIdBlock = BigintType.BIGINT.createFixedSizeBlockBuilder(1).writeLong(0L).build();
        this.bucketBlock = IntegerType.INTEGER.createFixedSizeBlockBuilder(1).writeInt(0x20000000).build();
    }

    @Test
    public void testDeleteLocations() {
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 4L, 4L, OptionalInt.of(0), this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 7L, 7L, OptionalInt.of(0), this.partitionDirectory);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows((AcidInfo)acidInfoBuilder.build().orElseThrow(), "bucket_00000");
        Page testPage = this.createTestPage(0, 10);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)8);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)7L, (Object[])new Long[]{8L, 9L}));
        testPage = this.createTestPage(10, 20);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)10);
    }

    @Test
    public void testDeletedLocationsOriginalFiles() {
        Path path = new Path(TestOrcDeletedRows.class.getClassLoader().getResource("dummy_id_data_orc") + "/");
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)path);
        this.addDeleteDelta(acidInfoBuilder, 10000001L, 10000001L, OptionalInt.of(0), path);
        acidInfoBuilder.addOriginalFile(new Path(path, "000000_0"), 743L, 0);
        acidInfoBuilder.addOriginalFile(new Path(path, "000001_0"), 730L, 0);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows(acidInfoBuilder.buildWithRequiredOriginalFiles(0), "000000_0");
        Page testPage = this.createTestPage(0, 8);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.of(0L)).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)7);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object[])new Long[]{7L}));
        testPage = this.createTestPage(5, 9);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)4);
    }

    @Test
    public void testDeletedLocationsAfterMinorCompaction() {
        AcidInfo.Builder acidInfoBuilder = AcidInfo.builder((Path)this.partitionDirectory);
        this.addDeleteDelta(acidInfoBuilder, 4L, 4L, OptionalInt.empty(), this.partitionDirectory);
        OrcDeletedRows deletedRows = TestOrcDeletedRows.createOrcDeletedRows((AcidInfo)acidInfoBuilder.build().orElseThrow(), "bucket_00000");
        Page testPage = this.createTestPage(0, 10);
        Block block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(0));
        Set validRows = MaterializedResult.resultBuilder((ConnectorSession)HiveTestUtils.SESSION, (Type[])new Type[]{BigintType.BIGINT}).page(new Page(new Block[]{block})).build().getOnlyColumnAsSet();
        Assert.assertEquals((int)validRows.size(), (int)9);
        Assert.assertEquals((Set)validRows, (Set)ImmutableSet.of((Object)0L, (Object)1L, (Object)3L, (Object)4L, (Object)5L, (Object)6L, (Object[])new Long[]{7L, 8L, 9L}));
        testPage = this.createTestPage(10, 20);
        block = deletedRows.getMaskDeletedRowsFunction(testPage, OptionalLong.empty()).apply(testPage.getBlock(1));
        Assert.assertEquals((int)block.getPositionCount(), (int)10);
    }

    private void addDeleteDelta(AcidInfo.Builder acidInfoBuilder, long minWriteId, long maxWriteId, OptionalInt statementId, Path path) {
        Path deleteDeltaPath = statementId.isPresent() ? new Path(path, AcidUtils.deleteDeltaSubdir((long)minWriteId, (long)maxWriteId, (int)statementId.getAsInt())) : new Path(path, AcidUtils.deleteDeltaSubdir((long)minWriteId, (long)maxWriteId));
        acidInfoBuilder.addDeleteDelta(deleteDeltaPath);
    }

    private static OrcDeletedRows createOrcDeletedRows(AcidInfo acidInfo, String sourceFileName) {
        OrcDeleteDeltaPageSourceFactory pageSourceFactory = new OrcDeleteDeltaPageSourceFactory(new OrcReaderOptions(), new FileFormatDataSourceStats());
        OrcDeletedRows deletedRows = new OrcDeletedRows(sourceFileName, pageSourceFactory, ConnectorIdentity.ofUser((String)"test"), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, acidInfo, OptionalInt.of(0), AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        while (!deletedRows.loadOrYield()) {
        }
        return deletedRows;
    }

    private Page createTestPage(int originalTransactionStart, int originalTransactionEnd) {
        int size = originalTransactionEnd - originalTransactionStart;
        BlockBuilder originalTransaction = BigintType.BIGINT.createFixedSizeBlockBuilder(size);
        for (long i = (long)originalTransactionStart; i < (long)originalTransactionEnd; ++i) {
            originalTransaction.writeLong(i);
        }
        return new Page(size, new Block[]{originalTransaction.build(), RunLengthEncodedBlock.create((Block)this.bucketBlock, (int)size), RunLengthEncodedBlock.create((Block)this.rowIdBlock, (int)size)});
    }
}

