/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.AbstractTestHiveFileFormats;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.TableToPartitionMapping;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.testing.StructuralTestUtil;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestOrcPredicates
extends AbstractTestHiveFileFormats {
    private static final int NUM_ROWS = 50000;
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final AbstractTestHiveFileFormats.TestColumn columnPrimitiveInteger = new AbstractTestHiveFileFormats.TestColumn("column_primitive_integer", (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, 3, 3);
    private static final AbstractTestHiveFileFormats.TestColumn columnStruct = new AbstractTestHiveFileFormats.TestColumn("column1_struct", (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)"field0", (Object)"field1"), (List)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Object)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), new Long[]{4L, 5L}, StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT), (Object[])new Object[]{4L, 5L}));
    private static final AbstractTestHiveFileFormats.TestColumn columnPrimitiveBigInt = new AbstractTestHiveFileFormats.TestColumn("column_primitive_bigint", (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, 6L, 6L);

    @Test
    public void testOrcPredicates() throws Exception {
        this.testOrcPredicates((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true)));
        this.testOrcPredicates((ConnectorSession)HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOrcPredicates(ConnectorSession session) throws Exception {
        ImmutableList columnsToWrite = ImmutableList.of((Object)columnPrimitiveInteger, (Object)columnStruct, (Object)columnPrimitiveBigInt);
        File file = File.createTempFile("test", "orc_predicate");
        file.delete();
        try {
            OrcFileWriterFactory writerFactory = new OrcFileWriterFactory(InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), STATS, new OrcWriterOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY);
            FileSplit split = TestOrcPredicates.createTestFileTrino(file.getAbsolutePath(), HiveStorageFormat.ORC, HiveCompressionCodec.NONE, (List<AbstractTestHiveFileFormats.TestColumn>)columnsToWrite, session, 50000, (HiveFileWriterFactory)writerFactory);
            ImmutableList columnsToRead = columnsToWrite;
            TupleDomain testingPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnPrimitiveBigInt, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L)));
            this.assertFilteredRows((TupleDomain<AbstractTestHiveFileFormats.TestColumn>)testingPredicate, (List<AbstractTestHiveFileFormats.TestColumn>)columnsToRead, session, split, 50000);
            testingPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)columnPrimitiveBigInt, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
            this.assertFilteredRows((TupleDomain<AbstractTestHiveFileFormats.TestColumn>)testingPredicate, (List<AbstractTestHiveFileFormats.TestColumn>)columnsToRead, session, split, 0);
            AbstractTestHiveFileFormats.TestColumn projectedColumn = new AbstractTestHiveFileFormats.TestColumn(columnStruct.getBaseName(), columnStruct.getBaseObjectInspector(), (List<String>)ImmutableList.of((Object)"field1"), (List<Integer>)ImmutableList.of((Object)1), (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, 5L, 5L, false);
            columnsToRead = ImmutableList.of((Object)columnPrimitiveBigInt, (Object)projectedColumn);
            testingPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)5L)));
            this.assertFilteredRows((TupleDomain<AbstractTestHiveFileFormats.TestColumn>)testingPredicate, (List<AbstractTestHiveFileFormats.TestColumn>)columnsToRead, session, split, 50000);
            testingPredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)projectedColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)6L)));
            this.assertFilteredRows((TupleDomain<AbstractTestHiveFileFormats.TestColumn>)testingPredicate, (List<AbstractTestHiveFileFormats.TestColumn>)columnsToRead, session, split, 0);
        }
        finally {
            file.delete();
        }
    }

    private void assertFilteredRows(TupleDomain<AbstractTestHiveFileFormats.TestColumn> effectivePredicate, List<AbstractTestHiveFileFormats.TestColumn> columnsToRead, ConnectorSession session, FileSplit split, int expectedRows) {
        ConnectorPageSource pageSource = this.createPageSource(effectivePredicate, columnsToRead, session, split);
        int filteredRows = 0;
        while (!pageSource.isFinished()) {
            Page page = pageSource.getNextPage();
            if (page == null) continue;
            filteredRows += page.getPositionCount();
        }
        Assert.assertEquals((int)filteredRows, (int)expectedRows);
    }

    private ConnectorPageSource createPageSource(TupleDomain<AbstractTestHiveFileFormats.TestColumn> effectivePredicate, List<AbstractTestHiveFileFormats.TestColumn> columnsToRead, ConnectorSession session, FileSplit split) {
        OrcPageSourceFactory readerFactory = new OrcPageSourceFactory(new OrcReaderOptions(), (TrinoFileSystemFactory)HiveTestUtils.HDFS_FILE_SYSTEM_FACTORY, STATS, DateTimeZone.UTC);
        Properties splitProperties = new Properties();
        splitProperties.setProperty("file.inputformat", HiveStorageFormat.ORC.getInputFormat());
        splitProperties.setProperty("serialization.lib", HiveStorageFormat.ORC.getSerde());
        ImmutableList.Builder splitPropertiesColumnNames = ImmutableList.builder();
        ImmutableList.Builder splitPropertiesColumnTypes = ImmutableList.builder();
        HashSet<String> baseColumnNames = new HashSet<String>();
        for (AbstractTestHiveFileFormats.TestColumn columnToRead : columnsToRead) {
            String name = columnToRead.getBaseName();
            if (baseColumnNames.contains(name) || columnToRead.isPartitionKey()) continue;
            baseColumnNames.add(name);
            splitPropertiesColumnNames.add((Object)name);
            splitPropertiesColumnTypes.add((Object)columnToRead.getBaseObjectInspector().getTypeName());
        }
        splitProperties.setProperty("columns", splitPropertiesColumnNames.build().stream().collect(Collectors.joining(",")));
        splitProperties.setProperty("columns.types", splitPropertiesColumnTypes.build().stream().collect(Collectors.joining(",")));
        List partitionKeys = columnsToRead.stream().filter(AbstractTestHiveFileFormats.TestColumn::isPartitionKey).map(input -> new HivePartitionKey(input.getName(), (String)input.getWriteValue())).collect(Collectors.toList());
        String partitionName = String.join((CharSequence)"/", (Iterable)partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.getName(), partitionKey.getValue())).collect(ImmutableList.toImmutableList()));
        List<HiveColumnHandle> columnHandles = this.getColumnHandles(columnsToRead);
        TupleDomain predicate = effectivePredicate.transformKeys(testColumn -> {
            Optional<HiveColumnHandle> handle = columnHandles.stream().filter(column -> testColumn.getName().equals(column.getName())).findFirst();
            Preconditions.checkState((boolean)handle.isPresent(), (Object)"Predicate on invalid column");
            return handle.get();
        });
        List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)partitionName, partitionKeys, columnHandles, (List)ImmutableList.of(), (TableToPartitionMapping)TableToPartitionMapping.empty(), (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getLength(), (long)Instant.now().toEpochMilli());
        Optional pageSource = HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)readerFactory), (Set)ImmutableSet.of(), (Configuration)ConfigurationInstantiator.newEmptyConfiguration(), (ConnectorSession)session, (Path)split.getPath(), (OptionalInt)OptionalInt.empty(), (long)split.getStart(), (long)split.getLength(), (long)split.getLength(), (Properties)splitProperties, (TupleDomain)predicate, columnHandles, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), (boolean)false, Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings);
        Assert.assertTrue((boolean)pageSource.isPresent());
        return (ConnectorPageSource)pageSource.get();
    }
}

