/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestOrcReaderConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OrcReaderConfig)ConfigAssertions.recordDefaults(OrcReaderConfig.class)).setUseColumnNames(false).setBloomFiltersEnabled(false).setMaxMergeDistance(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxBufferSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setStreamBufferSize(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setTinyStripeThreshold(DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setMaxBlockSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setLazyReadSmallRanges(true).setNestedLazy(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.orc.use-column-names", (Object)"true").put((Object)"hive.orc.bloom-filters.enabled", (Object)"true").put((Object)"hive.orc.max-merge-distance", (Object)"22kB").put((Object)"hive.orc.max-buffer-size", (Object)"44kB").put((Object)"hive.orc.stream-buffer-size", (Object)"55kB").put((Object)"hive.orc.tiny-stripe-threshold", (Object)"61kB").put((Object)"hive.orc.max-read-block-size", (Object)"66kB").put((Object)"hive.orc.lazy-read-small-ranges", (Object)"false").put((Object)"hive.orc.nested-lazy", (Object)"false").buildOrThrow();
        OrcReaderConfig expected = new OrcReaderConfig().setUseColumnNames(true).setBloomFiltersEnabled(true).setMaxMergeDistance(DataSize.of((long)22L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxBufferSize(DataSize.of((long)44L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setStreamBufferSize(DataSize.of((long)55L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setTinyStripeThreshold(DataSize.of((long)61L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setMaxBlockSize(DataSize.of((long)66L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setLazyReadSmallRanges(false).setNestedLazy(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

