/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.airlift.units.DataSize;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.util.HiveUtil;
import java.util.Properties;
import org.assertj.core.api.AssertionsForClassTypes;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestOrcWriterOptions {
    @Test
    public void testDefaultOrcWriterOptions() {
        OrcWriterOptions orcWriterOptions = new OrcWriterOptions();
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getWriterIdentification()).isEqualTo((Object)OrcWriterOptions.WriterIdentification.TRINO);
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getStripeMinSize()).isEqualTo((Object)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getStripeMaxSize()).isEqualTo((Object)DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        AssertionsForClassTypes.assertThat((int)orcWriterOptions.getStripeMaxRowCount()).isEqualTo(10000000);
        AssertionsForClassTypes.assertThat((int)orcWriterOptions.getRowGroupMaxRowCount()).isEqualTo(10000);
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getDictionaryMaxMemory()).isEqualTo((Object)DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getMaxStringStatisticsLimit()).isEqualTo((Object)DataSize.ofBytes((long)64L));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getMaxCompressionBufferSize()).isEqualTo((Object)DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.KILOBYTE));
        AssertionsForClassTypes.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.05);
        AssertionsForClassTypes.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsFromOrcWriterConfig() {
        OrcWriterConfig orcWriterConfig = new OrcWriterConfig().setWriterIdentification(OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE).setStripeMinSize(DataSize.ofBytes((long)32L)).setStripeMaxSize(DataSize.ofBytes((long)64L)).setStripeMaxRowCount(100).setRowGroupMaxRowCount(10).setDictionaryMaxMemory(DataSize.ofBytes((long)16L)).setStringStatisticsLimit(DataSize.ofBytes((long)16L)).setMaxCompressionBufferSize(DataSize.ofBytes((long)256L)).setDefaultBloomFilterFpp(0.5);
        OrcWriterOptions orcWriterOptions = orcWriterConfig.toOrcWriterOptions();
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getWriterIdentification()).isEqualTo((Object)OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE);
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getStripeMinSize()).isEqualTo((Object)DataSize.ofBytes((long)32L));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getStripeMaxSize()).isEqualTo((Object)DataSize.ofBytes((long)64L));
        AssertionsForClassTypes.assertThat((int)orcWriterOptions.getStripeMaxRowCount()).isEqualTo(100);
        AssertionsForClassTypes.assertThat((int)orcWriterOptions.getRowGroupMaxRowCount()).isEqualTo(10);
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getDictionaryMaxMemory()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getMaxStringStatisticsLimit()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        AssertionsForClassTypes.assertThat((Object)orcWriterOptions.getMaxCompressionBufferSize()).isEqualTo((Object)DataSize.ofBytes((long)256L));
        AssertionsForClassTypes.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.5);
        AssertionsForClassTypes.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsFromTableProperties() {
        Properties tableProperties = new Properties();
        tableProperties.setProperty("orc.bloom.filter.columns", "column_a, column_b");
        tableProperties.setProperty("orc.bloom.filter.fpp", "0.5");
        OrcWriterOptions orcWriterOptions = HiveUtil.getOrcWriterOptions((Properties)tableProperties, (OrcWriterOptions)new OrcWriterOptions());
        AssertionsForClassTypes.assertThat((double)orcWriterOptions.getBloomFilterFpp()).isEqualTo(0.5);
        AssertionsForClassTypes.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("column_a")).isTrue();
        AssertionsForClassTypes.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("column_b")).isTrue();
        AssertionsForClassTypes.assertThat((boolean)orcWriterOptions.isBloomFilterColumn("unknown_column")).isFalse();
    }

    @Test
    public void testOrcWriterOptionsWithInvalidFPPValue() {
        Properties tableProperties = new Properties();
        tableProperties.setProperty("orc.bloom.filter.columns", "column_with_bloom_filter");
        tableProperties.setProperty("orc.bloom.filter.fpp", "abc");
        AssertionsForClassTypes.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions((Properties)tableProperties, (OrcWriterOptions)new OrcWriterOptions())).hasMessage("Invalid value for orc_bloom_filter_fpp property: abc");
    }

    @Test(dataProvider="invalidBloomFilterFpp")
    public void testOrcBloomFilterWithInvalidRange(String fpp) {
        Properties tableProperties = new Properties();
        tableProperties.setProperty("orc.bloom.filter.columns", "column_with_bloom_filter");
        tableProperties.setProperty("orc.bloom.filter.fpp", fpp);
        AssertionsForClassTypes.assertThatThrownBy(() -> HiveUtil.getOrcWriterOptions((Properties)tableProperties, (OrcWriterOptions)new OrcWriterOptions())).hasMessage("bloomFilterFpp should be > 0.0 & < 1.0");
    }

    @DataProvider
    public Object[][] invalidBloomFilterFpp() {
        return new Object[][]{{"100"}, {"-100"}, {"0"}, {"1"}};
    }
}

