/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.primitives.Shorts;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DataProviders;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.StructuralTestUtil;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public abstract class AbstractTestParquetReader {
    private static final int MAX_PRECISION_INT32 = Math.toIntExact(AbstractTestParquetReader.maxPrecision(4));
    private static final int MAX_PRECISION_INT64 = Math.toIntExact(AbstractTestParquetReader.maxPrecision(8));
    private Logger parquetLogger;
    private final ParquetTester tester;

    protected AbstractTestParquetReader(ParquetTester tester) {
        this.tester = tester;
    }

    @BeforeClass
    public void setUp() {
        Assert.assertEquals((Object)DateTimeZone.getDefault(), (Object)DateTimeZone.forID((String)"America/Bahia_Banderas"));
        this.parquetLogger = Logger.getLogger("org.apache.parquet.hadoop");
        this.parquetLogger.setLevel(Level.WARNING);
    }

    @Test
    public void testArray() throws Exception {
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER));
    }

    @Test
    public void testEmptyArrays() throws Exception {
        Iterable values = Iterables.limit((Iterable)Iterables.cycle(Collections.singletonList(Collections.emptyList())), (int)30000);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER));
    }

    @Test
    public void testNestedArrays() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ArrayType type = new ArrayType((Type)IntegerType.INTEGER);
        Iterable values = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)3210);
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createNullableTestArrays(values);
            objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)objectInspector);
            type = new ArrayType((Type)type);
        }
        values = this.createTestArrays(values);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, values, values, (Type)type);
    }

    @Test
    public void testSingleLevelSchemaNestedArrays() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ArrayType type = new ArrayType((Type)IntegerType.INTEGER);
        Object values = AbstractTestParquetReader.intsBetween(0, 31234);
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createTestArrays((Iterable)values);
            objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)objectInspector);
            type = new ArrayType((Type)type);
        }
        values = this.createTestArrays((Iterable)values);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, (Iterable<?>)values, (Iterable<?>)values, (Type)type);
    }

    @Test
    public void testArrayOfStructs() throws Exception {
        Iterable<List<?>> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString), AbstractTestParquetReader.longsBetween(0L, 31234L)});
        List<List<List<?>>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testCustomSchemaArrayOfStructs() throws Exception {
        MessageType customSchemaArrayOfStructs = MessageTypeParser.parseMessageType((String)"message ParquetSchema {   optional group self (LIST) {     repeated group self_tuple {       optional int64 a;       optional boolean b;       required binary c (UTF8);     }   } }");
        Iterable aValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
        Iterable bValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)30000);
        Iterable cValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString);
        List<List<?>> structs = this.createTestStructs(aValues, bValues, cValues);
        List<List<List<?>>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("a", "b", "c");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BooleanType.BOOLEAN), RowType.field((String)"c", (Type)VarcharType.VARCHAR)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, "self", (Type)new ArrayType((Type)structType), Optional.of(customSchemaArrayOfStructs), ParquetTester.ParquetSchemaOptions.withSingleLevelArray());
    }

    @Test
    public void testSingleLevelSchemaArrayOfStructs() throws Exception {
        Iterable aValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1L, null, 3L, 5L, null, null, null, 7L, 11L, null, 13L, 17L)), (int)30000);
        Iterable bValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)30000);
        Iterable cValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString);
        List<List<?>> structs = this.createTestStructs(aValues, bValues, cValues);
        List<List<List<?>>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Arrays.asList("a", "b", "c");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BooleanType.BOOLEAN), RowType.field((String)"c", (Type)VarcharType.VARCHAR)));
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaLongObjectInspector, PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector)));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testArrayOfArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable<List<?>> structs = this.createNullableTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, 7, 11, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        Iterable<List<List<?>>> arrays = this.createNullableTestArrays(structs);
        List<List<List<List<?>>>> values = this.createTestArrays(arrays);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)new ArrayType((Type)new ArrayType((Type)structType)));
    }

    @Test
    public void testSingleLevelSchemaArrayOfArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<?>> structs = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, 7, 11, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List<?>>> arrays = this.createTestArrays(structs);
        List<List<List<List<?>>>> values = this.createTestArrays(arrays);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)new ArrayType((Type)new ArrayType((Type)structType)));
    }

    @Test
    public void testArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable<List<?>> structs = this.createNullableTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, 3, null, 5, 7, null, 11, 13, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List<?>>> values = this.createTestArrays(structs);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testSingleLevelSchemaArrayOfStructOfArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<?>> structs = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, 3, null, 5, 7, null, 11, 13, null, 17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<List<List<?>>> values = this.createTestArrays(structs);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testMap() throws Exception {
        Iterable values = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 100000), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10000L));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT));
    }

    @Test
    public void testNestedMaps() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 3210);
        Iterable maps = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)3210);
        StandardMapObjectInspector objectInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        MapType type = StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR);
        for (int i = 0; i < nestingLevel; ++i) {
            maps = this.createNullableTestMaps((Iterable)keys, maps);
            objectInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)objectInspector);
            type = StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)type);
        }
        maps = this.createTestMaps((Iterable)keys, maps);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, maps, maps, (Type)type);
    }

    @Test
    public void testArrayOfMaps() throws Exception {
        Iterable maps = this.createNullableTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10L));
        List values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector)), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testSingleLevelSchemaArrayOfMaps() throws Exception {
        Iterable maps = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10), Object::toString), (Iterable)AbstractTestParquetReader.longsBetween(0L, 10L));
        List values = this.createTestArrays(maps);
        StandardListObjectInspector objectInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)));
    }

    @Test
    public void testArrayOfMapOfStruct() throws Exception {
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable<List<?>> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 10000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Integer, List<?>>> maps = this.createNullableTestMaps((Iterable)keys, (Iterable)structs);
        List<List<Map<Integer, List<?>>>> values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)structType)));
    }

    @Test
    public void testSingleLevelArrayOfMapOfStruct() throws Exception {
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable<List<?>> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 10000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Integer, List<?>>> maps = this.createTestMaps((Iterable)keys, (Iterable)structs);
        List<List<Map<Integer, List<?>>>> values = this.createTestArrays(maps);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)structType)));
    }

    @Test
    public void testSingleLevelArrayOfStructOfSingleElement() throws Exception {
        List<List<?>> structs = this.createTestStructs(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<List<?>>> values = this.createTestArrays(structs);
        List<String> structFieldNames = Collections.singletonList("test");
        RowType structType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)VarcharType.VARCHAR)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)new ArrayType((Type)structType));
    }

    @Test
    public void testSingleLevelArrayOfStructOfStructOfSingleElement() throws Exception {
        List<List<?>> structs = this.createTestStructs(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<?>> structsOfStructs = this.createTestStructs((Iterable)structs);
        List<List<List<?>>> values = this.createTestArrays(structsOfStructs);
        List<String> structFieldNames = Collections.singletonList("test");
        List<String> structsOfStructsFieldNames = Collections.singletonList("test");
        RowType structType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)VarcharType.VARCHAR)));
        RowType structsOfStructsType = RowType.from(Collections.singletonList(RowType.field((String)"test", (Type)structType)));
        StandardStructObjectInspector structObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structsOfStructsFieldNames, Collections.singletonList(structObjectInspector))), values, values, (Type)new ArrayType((Type)structsOfStructsType));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structsOfStructsFieldNames, Collections.singletonList(structObjectInspector))), values, values, (Type)new ArrayType((Type)structsOfStructsType));
    }

    @Test
    public void testArrayOfMapOfArray() throws Exception {
        Iterable arrays = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)10000));
        Iterable keys = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString);
        Iterable maps = this.createNullableTestMaps(keys, arrays);
        List values = this.createTestArrays(maps);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)IntegerType.INTEGER))));
    }

    @Test
    public void testSingleLevelArrayOfMapOfArray() throws Exception {
        Iterable<List<Integer>> arrays = this.createNullableTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 10000));
        Iterable keys = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 10000), Object::toString);
        Iterable maps = this.createTestMaps(keys, arrays);
        List values = this.createTestArrays(maps);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)IntegerType.INTEGER))));
    }

    @Test
    public void testMapOfArrayValues() throws Exception {
        Iterable arrays = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable values = this.createTestMaps((Iterable)keys, arrays);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMapOfArrayKeys() throws Exception {
        List mapKeys = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        ContiguousSet<Integer> mapValues = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable testMaps = this.createTestMaps(mapKeys, (Iterable)mapValues);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), testMaps, testMaps, (Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER));
    }

    @Test
    public void testMapOfSingleLevelArray() throws Exception {
        Iterable<List<Integer>> arrays = this.createNullableTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 30000));
        ContiguousSet<Integer> keys = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable<Map<Integer, List<Integer>>> values = this.createTestMaps((Iterable)keys, (Iterable)arrays);
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER)));
    }

    @Test
    public void testMapOfStruct() throws Exception {
        ContiguousSet<Long> keys = AbstractTestParquetReader.longsBetween(0L, 30000L);
        Iterable<List<?>> structs = this.createNullableTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString), AbstractTestParquetReader.longsBetween(0L, 30000L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        Iterable<Map<Long, List<?>>> values = this.createTestMaps((Iterable)keys, (Iterable)structs);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector))), values, values, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)structType));
    }

    @Test
    public void testMapWithNullValues() throws Exception {
        ContiguousSet<Integer> mapKeys = AbstractTestParquetReader.intsBetween(0, 31234);
        Iterable mapValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)31234);
        Iterable values = this.createTestMaps((Iterable)mapKeys, mapValues);
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR));
    }

    @Test
    public void testStruct() throws Exception {
        List<List<?>> values = this.createTestStructs(new Iterable[]{Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString), AbstractTestParquetReader.longsBetween(0L, 31234L)});
        List<String> structFieldNames = Arrays.asList("stringField", "longField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringField", (Type)VarcharType.VARCHAR), RowType.field((String)"longField", (Type)BigintType.BIGINT)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaLongObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testNestedStructs() throws Exception {
        int nestingLevel = ThreadLocalRandom.current().nextInt(1, 15);
        Optional<List<String>> structFieldNames = Optional.of(Collections.singletonList("structField"));
        Iterable<List<?>> values = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)3210);
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames.get(), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        RowType type = RowType.from(Collections.singletonList(RowType.field((String)"structField", (Type)IntegerType.INTEGER)));
        for (int i = 0; i < nestingLevel; ++i) {
            values = this.createNullableTestStructs(values);
            objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames.get(), Collections.singletonList(objectInspector));
            type = RowType.from(Collections.singletonList(RowType.field((String)"structField", (Type)type)));
        }
        values = this.createTestStructs((Iterable)values);
        this.tester.testRoundTrip((ObjectInspector)objectInspector, values, values, (Type)type);
    }

    @Test
    public void testComplexNestedStructs() throws Exception {
        int n = 30;
        ContiguousSet<Integer> mapKeys = AbstractTestParquetReader.intsBetween(0, n);
        Iterable intPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)n);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)n);
        Iterable doublePrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1.1, null, 3.3, null, 5.5, null, 7.7, null, null, null, 11.11, null, 13.13)), (int)n);
        Iterable booleanPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, true, false, null, null, true, false)), (int)n);
        Iterable mapStringKeys = Stream.generate(() -> UUID.randomUUID().toString()).limit(n).collect(Collectors.toList());
        Iterable mapsIntString = this.createNullableTestMaps((Iterable)mapKeys, stringPrimitives);
        Iterable arraysString = this.createNullableTestArrays(stringPrimitives);
        Iterable mapsIntDouble = this.createNullableTestMaps((Iterable)mapKeys, doublePrimitives);
        Iterable arraysBoolean = this.createNullableTestArrays(booleanPrimitives);
        Iterable mapsStringString = this.createNullableTestMaps(mapStringKeys, stringPrimitives);
        List<String> struct1FieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "intField");
        Iterable<List<?>> structs1 = this.createNullableTestStructs(mapsIntString, arraysString, intPrimitives);
        StandardStructObjectInspector struct1ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct1FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        RowType struct1Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        List<String> struct2FieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "structField");
        Iterable<List<?>> structs2 = this.createNullableTestStructs(mapsIntString, arraysString, structs1);
        StandardStructObjectInspector struct2ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct2FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), struct1ObjectInspector));
        RowType struct2Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"structField", (Type)struct1Type)));
        List<String> struct3FieldNames = Arrays.asList("mapIntDoubleField", "booleanArrayField", "booleanField");
        Iterable<List<?>> structs3 = this.createNullableTestStructs(mapsIntDouble, arraysBoolean, booleanPrimitives);
        StandardStructObjectInspector struct3ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct3FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), PrimitiveObjectInspectorFactory.javaBooleanObjectInspector));
        RowType struct3Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntDoubleField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)), RowType.field((String)"booleanArrayField", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), RowType.field((String)"booleanField", (Type)BooleanType.BOOLEAN)));
        List<String> struct4FieldNames = Arrays.asList("mapIntDoubleField", "booleanArrayField", "structField");
        Iterable<List<?>> structs4 = this.createNullableTestStructs(mapsIntDouble, arraysBoolean, structs3);
        StandardStructObjectInspector struct4ObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(struct4FieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), struct3ObjectInspector));
        RowType struct4Type = RowType.from(Arrays.asList(RowType.field((String)"mapIntDoubleField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)), RowType.field((String)"booleanArrayField", (Type)new ArrayType((Type)BooleanType.BOOLEAN)), RowType.field((String)"structField", (Type)struct3Type)));
        List<String> structFieldNames = Arrays.asList("structField1", "structField2", "structField3", "structField4", "mapIntDoubleField", "booleanArrayField", "mapStringStringField");
        List<ObjectInspector> objectInspectors = Arrays.asList(struct1ObjectInspector, struct2ObjectInspector, struct3ObjectInspector, struct4ObjectInspector, ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector), ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        ImmutableList types = ImmutableList.of((Object)struct1Type, (Object)struct2Type, (Object)struct3Type, (Object)struct4Type, (Object)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE), (Object)new ArrayType((Type)BooleanType.BOOLEAN), (Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR));
        Iterable[] values = new Iterable[]{structs1, structs2, structs3, structs4, mapsIntDouble, arraysBoolean, mapsStringString};
        this.tester.assertRoundTrip(objectInspectors, values, values, structFieldNames, (List<Type>)types, Optional.empty(), ParquetTester.ParquetSchemaOptions.defaultOptions());
    }

    @Test
    public void testStructOfMaps() throws Exception {
        Iterable mapKeys = Stream.generate(() -> ThreadLocalRandom.current().nextInt(10000)).limit(10000L).collect(Collectors.toList());
        Iterable intPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, null, 5, null, 7, null, null, null, 11, null, 13)), (int)10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable maps = this.createNullableTestMaps(mapKeys, stringPrimitives);
        Iterable stringArrayField = this.createNullableTestArrays(stringPrimitives);
        List<List<?>> values = this.createTestStructs(maps, stringArrayField, intPrimitives);
        List<String> structFieldNames = Arrays.asList("mapIntStringField", "stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfNullableMapBetweenNonNullFields() throws Exception {
        ContiguousSet<Integer> intPrimitives = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable maps = this.createNullableTestMaps((Iterable)intPrimitives, stringPrimitives);
        List<List<?>> values = this.createTestStructs(new Iterable[]{intPrimitives, maps, intPrimitives});
        List<String> structFieldNames = Arrays.asList("intField1", "mapIntStringField", "intField2");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField1", (Type)IntegerType.INTEGER), RowType.field((String)"mapIntStringField", (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR)), RowType.field((String)"intField2", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfNullableArrayBetweenNonNullFields() throws Exception {
        ContiguousSet<Integer> intPrimitives = AbstractTestParquetReader.intsBetween(0, 10000);
        Iterable stringPrimitives = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, "value2", "value3", null, null, "value6", "value7")), (int)10000);
        Iterable stringArrayField = this.createNullableTestArrays(stringPrimitives);
        List<List<?>> values = this.createTestStructs(new Iterable[]{intPrimitives, stringArrayField, intPrimitives});
        List<String> structFieldNames = Arrays.asList("intField1", "arrayStringField", "intField2");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField1", (Type)IntegerType.INTEGER), RowType.field((String)"arrayStringField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField2", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfArrayAndPrimitive() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<?>> values = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfSingleLevelArrayAndPrimitive() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        List<List<?>> values = this.createTestStructs(stringArrayField, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234));
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intField", (Type)IntegerType.INTEGER)));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), PrimitiveObjectInspectorFactory.javaIntObjectInspector)), values, values, (Type)structType);
    }

    @Test
    public void testStructOfPrimitiveAndArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable intField = Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234);
        List<List<?>> values = this.createTestStructs(intField, stringArrayField);
        List<String> structFieldNames = Arrays.asList("intField", "stringArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField", (Type)IntegerType.INTEGER), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfPrimitiveAndSingleLevelArray() throws Exception {
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString));
        Iterable intField = Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)31234);
        List<List<?>> values = this.createTestStructs(intField, stringArrayField);
        List<String> structFieldNames = Arrays.asList("intField", "stringArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"intField", (Type)IntegerType.INTEGER), RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR))));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaIntObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000));
        Iterable stringArrayField = this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString));
        List<List<?>> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)IntegerType.INTEGER))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoNestedArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)));
        Iterable stringArrayField = this.createNullableTestArrays(this.createNullableTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString)));
        List<List<?>> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)))), values, values, (Type)structType);
    }

    @Test
    public void testStructOfTwoNestedSingleLevelSchemaArrays() throws Exception {
        Iterable intArrayField = this.createNullableTestArrays(this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000)));
        Iterable stringArrayField = this.createNullableTestArrays(this.createTestArrays(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 31234), Object::toString)));
        List<List<?>> values = this.createTestStructs(stringArrayField, intArrayField);
        List<String> structFieldNames = Arrays.asList("stringArrayField", "intArrayField");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"stringArrayField", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), RowType.field((String)"intArrayField", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))));
        StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector)), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector))));
        this.tester.testSingleLevelArraySchemaRoundTrip((ObjectInspector)objectInspector, values, values, (Type)structType);
    }

    @Test
    public void testBooleanSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaBooleanObjectInspector, Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)true, (Object)false, (Object)false)), (int)30000), (Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testLongSequence() throws Exception {
        this.testRoundTripNumeric((Iterable<Integer>)AbstractTestParquetReader.intsBetween(0, 31234));
    }

    @Test
    public void testLongSequenceWithHoles() throws Exception {
        this.testRoundTripNumeric(AbstractTestParquetReader.skipEvery(5, AbstractTestParquetReader.intsBetween(0, 31234)));
    }

    @Test
    public void testLongDirect() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17)), (int)30000));
    }

    @Test
    public void testLongDirect2() throws Exception {
        ArrayList<Integer> values = new ArrayList<Integer>(31234);
        for (int i = 0; i < 31234; ++i) {
            values.add(i);
        }
        Collections.shuffle(values, new Random(0L));
        this.testRoundTripNumeric(values);
    }

    @Test
    public void testLongShortRepeat() throws Exception {
        this.testRoundTripNumeric(Iterables.limit(AbstractTestParquetReader.repeatEach(4, Iterables.cycle((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17))), (int)30000));
    }

    @Test
    public void testLongPatchedBase() throws Exception {
        this.testRoundTripNumeric(Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.concat(AbstractTestParquetReader.intsBetween(0, 18), (Iterable)ImmutableList.of((Object)30000, (Object)20000))), (int)30000));
    }

    private static long maxPrecision(int numBytes) {
        return Math.round(Math.floor(Math.log10(Math.pow(2.0, 8 * numBytes - 1) - 1.0)));
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoDecimalWithNonMatchingScale() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", 10, 1));
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)ImmutableList.of((Object)10L), (Iterable<?>)ImmutableList.of((Object)SqlDecimal.of((long)100L, (int)10, (int)2)), (Type)DecimalType.createDecimalType((int)10, (int)2), Optional.of(parquetSchema));
    }

    @Test(dataProvider="testDecimalInputProvider")
    public void testDecimals(DecimalInput decimalInput) throws Exception {
        for (int precision = 1; precision <= decimalInput.getMaxSupportedPrecision(); ++precision) {
            int scale = ThreadLocalRandom.current().nextInt(precision);
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional %s test (DECIMAL(%d, %d)); }", decimalInput.getPrimitiveTypeName(precision), precision, scale));
            ImmutableList.Builder expectedValues = ImmutableList.builder();
            ImmutableList.Builder expectedValuesMaxPrecision = ImmutableList.builder();
            ImmutableList.Builder writeValuesBuilder = ImmutableList.builder();
            BigInteger start = BigInteger.valueOf(10L).pow(precision).subtract(BigInteger.ONE).negate();
            BigInteger end = BigInteger.valueOf(10L).pow(precision);
            BigInteger step = BigInteger.valueOf(1L).max(end.subtract(start).divide(BigInteger.valueOf(1500L)));
            BigInteger value = start;
            while (value.compareTo(end) < 0) {
                writeValuesBuilder.add(decimalInput.convertToWriteValue(value, scale));
                expectedValues.add((Object)new SqlDecimal(value, precision, scale));
                expectedValuesMaxPrecision.add((Object)new SqlDecimal(value, 38, scale));
                value = value.add(step);
            }
            ImmutableList writeValues = writeValuesBuilder.build();
            this.tester.testRoundTrip(decimalInput.getParquetObjectInspector(precision, scale), (Iterable<?>)writeValues, (Iterable<?>)expectedValues.build(), (Type)DecimalType.createDecimalType((int)precision, (int)scale), Optional.of(parquetSchema));
            this.tester.testRoundTrip(decimalInput.getParquetObjectInspector(precision, scale), (Iterable<?>)writeValues, (Iterable<?>)expectedValuesMaxPrecision.build(), (Type)DecimalType.createDecimalType((int)38, (int)scale), Optional.of(parquetSchema));
        }
    }

    @DataProvider
    public Object[][] testDecimalInputProvider() {
        return (Object[][])Arrays.stream(DecimalInput.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testParquetLongDecimalWriteToTrinoDecimalWithNonMatchingScale() throws Exception {
        this.tester.testRoundTrip((ObjectInspector)new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(38, 10)), (Iterable<?>)ImmutableList.of((Object)HiveDecimal.create((long)(100L * Decimals.longTenToNth((int)10)), (int)10)), (Iterable<?>)ImmutableList.of((Object)new SqlDecimal(BigInteger.valueOf(100L * Decimals.longTenToNth((int)9)), 38, 9)), (Type)DecimalType.createDecimalType((int)38, (int)9));
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoTinyintBlock() throws Exception {
        for (int precision = 1; precision <= MAX_PRECISION_INT64; ++precision) {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", precision, 0));
            ContiguousSet<Long> longValues = AbstractTestParquetReader.longsBetween(-128L, 127L);
            ImmutableList.Builder expectedValues = ImmutableList.builder();
            for (Long value : longValues) {
                expectedValues.add((Object)value.byteValue());
            }
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, (Iterable<?>)expectedValues.build(), (Type)TinyintType.TINYINT, Optional.of(parquetSchema));
        }
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoSmallintBlock() throws Exception {
        int start = Short.MIN_VALUE;
        int end = Short.MAX_VALUE;
        int step = Math.max((end - start) / 2000, 1);
        ImmutableList.Builder writeValues = ImmutableList.builder();
        for (long value = (long)start; value <= (long)end; value += (long)step) {
            writeValues.add((Object)value);
        }
        ImmutableList longValues = writeValues.build();
        List expectedValues = (List)longValues.stream().map(Long::shortValue).collect(ImmutableList.toImmutableList());
        for (int precision = 1; precision <= MAX_PRECISION_INT64; ++precision) {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", precision, 0));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, expectedValues, (Type)SmallintType.SMALLINT, Optional.of(parquetSchema));
        }
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoIntegerBlock() throws Exception {
        long start = Integer.MIN_VALUE;
        long end = Integer.MAX_VALUE;
        long step = Math.max((end - start) / 2000L, 1L);
        ImmutableList.Builder writeValues = ImmutableList.builder();
        for (long value = start; value <= end; value += step) {
            writeValues.add((Object)value);
        }
        ImmutableList longValues = writeValues.build();
        List expectedValues = (List)longValues.stream().map(Math::toIntExact).collect(ImmutableList.toImmutableList());
        for (int precision = 1; precision <= MAX_PRECISION_INT64; ++precision) {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", precision, 0));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, expectedValues, (Type)IntegerType.INTEGER, Optional.of(parquetSchema));
        }
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoBigintBlock() throws Exception {
        BigInteger start = BigInteger.valueOf(Long.MIN_VALUE);
        BigInteger end = BigInteger.valueOf(Long.MAX_VALUE);
        int valuesCount = 8000;
        long step = end.subtract(start).divide(BigInteger.valueOf(valuesCount)).max(BigInteger.valueOf(1L)).longValueExact();
        ImmutableList.Builder writeValues = ImmutableList.builder();
        long value = Long.MIN_VALUE;
        for (int i = 0; i < valuesCount; ++i) {
            value = Math.addExact(value, step);
            writeValues.add((Object)value);
        }
        ImmutableList longValues = writeValues.build();
        for (int precision = 4; precision <= MAX_PRECISION_INT64; ++precision) {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", precision, 0));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)longValues, (Iterable<?>)longValues, (Type)BigintType.BIGINT, Optional.of(parquetSchema));
        }
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoBigintBlockWithNonZeroScale() {
        Assertions.assertThatThrownBy(() -> {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT64 test (DECIMAL(%d, %d)); }", 10, 1));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, (Iterable<?>)ImmutableList.of((Object)1L), (Iterable<?>)ImmutableList.of((Object)1L), (Type)BigintType.BIGINT, Optional.of(parquetSchema));
        }).hasMessage("Unsupported Trino column type (bigint) for Parquet column ([test] optional int64 test (DECIMAL(10,1)))").isInstanceOf(TrinoException.class);
        Assertions.assertThatThrownBy(() -> {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT32 test (DECIMAL(%d, %d)); }", 8, 1));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Iterable<?>)ImmutableList.of((Object)1), (Iterable<?>)ImmutableList.of((Object)1), (Type)BigintType.BIGINT, Optional.of(parquetSchema));
        }).hasMessage("Unsupported Trino column type (bigint) for Parquet column ([test] optional int32 test (DECIMAL(8,1)))").isInstanceOf(TrinoException.class);
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoIntegerBlockWithNonZeroScale() {
        Assertions.assertThatThrownBy(() -> {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT32 test (DECIMAL(%d, %d)); }", 8, 1));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, (Iterable<?>)ImmutableList.of((Object)1), (Iterable<?>)ImmutableList.of((Object)1), (Type)IntegerType.INTEGER, Optional.of(parquetSchema));
        }).hasMessage("Unsupported Trino column type (integer) for Parquet column ([test] optional int32 test (DECIMAL(8,1)))").isInstanceOf(TrinoException.class);
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoSmallBlockWithNonZeroScale() {
        Assertions.assertThatThrownBy(() -> {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT32 test (DECIMAL(%d, %d)); }", 8, 1));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, (Iterable<?>)ImmutableList.of((Object)1), (Iterable<?>)ImmutableList.of((Object)1), (Type)SmallintType.SMALLINT, Optional.of(parquetSchema));
        }).hasMessage("Unsupported Trino column type (smallint) for Parquet column ([test] optional int32 test (DECIMAL(8,1)))").isInstanceOf(TrinoException.class);
    }

    @Test
    public void testParquetShortDecimalWriteToTrinoTinyBlockWithNonZeroScale() {
        Assertions.assertThatThrownBy(() -> {
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)String.format("message hive_decimal { optional INT32 test (DECIMAL(%d, %d)); }", 8, 1));
            this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, (Iterable<?>)ImmutableList.of((Object)1), (Iterable<?>)ImmutableList.of((Object)1), (Type)TinyintType.TINYINT, Optional.of(parquetSchema));
        }).hasMessage("Unsupported Trino column type (tinyint) for Parquet column ([test] optional int32 test (DECIMAL(8,1)))").isInstanceOf(TrinoException.class);
    }

    @Test(dataProvider="timestampPrecision")
    public void testTimestamp(HiveTimestampPrecision precision) throws Exception {
        List epochMillisValues = (List)ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(-1000L), (Comparable)Long.valueOf(1000L)), (DiscreteDomain)DiscreteDomain.longs()).stream().map(millis -> System.currentTimeMillis() + millis).collect(ImmutableList.toImmutableList());
        List writeValues = (List)epochMillisValues.stream().map(AbstractTestParquetReader::longToTimestamp).collect(ImmutableList.toImmutableList());
        List readValues = (List)epochMillisValues.stream().map(epochMillis -> SqlTimestamp.newInstance((int)precision.getPrecision(), (long)(epochMillis * 1000L), (int)0)).collect(ImmutableList.toImmutableList());
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, writeValues, readValues, (Type)TimestampType.createTimestampType((int)precision.getPrecision()), Optional.empty());
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, writeValues, readValues, (String)Iterables.getOnlyElement(ParquetTester.TEST_COLUMN), (Type)TimestampType.createTimestampType((int)precision.getPrecision()), Optional.empty(), ParquetTester.ParquetSchemaOptions.withInt64BackedTimestamps());
    }

    @DataProvider
    public Object[][] timestampPrecision() {
        return (Object[][])Stream.of(HiveTimestampPrecision.values()).collect(DataProviders.toDataProvider());
    }

    @Test
    public void testSchemaWithRepeatedOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group address_book {    required binary owner (UTF8);    optional group owner_phone_numbers (LIST) {      repeated group bag {        optional binary array_element (UTF8);      }    }    optional group contacts (LIST) {      repeated group bag {        optional group array_element {          required binary name (UTF8);          optional binary phone_number (UTF8);        }      }    }  }} ");
        Iterable owner = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("owner1", "owner2", "owner3")), (int)50000);
        Iterable ownerPhoneNumbers = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(null, Arrays.asList("phoneNumber2", "phoneNumber3", null), Arrays.asList(null, "phoneNumber6", "phoneNumber7"))), (int)50000);
        List<String> name = Arrays.asList("name1", "name2", "name3", "name4", "name5", "name6", "name7");
        List<String> phoneNumber = Arrays.asList(null, "phoneNumber2", "phoneNumber3", null, null, "phoneNumber6", "phoneNumber7");
        Iterable<List<?>> contact = this.createNullableTestStructs(name, phoneNumber);
        Iterable contacts = this.createNullableTestArrays(Iterables.limit((Iterable)Iterables.cycle(contact), (int)50000));
        List<List<?>> values = this.createTestStructs(owner, ownerPhoneNumbers, contacts);
        List<String> addressBookFieldNames = Arrays.asList("owner", "owner_phone_numbers", "contacts");
        List<String> contactsFieldNames = Arrays.asList("name", "phone_number");
        ArrayType contactsType = new ArrayType((Type)RowType.from(Arrays.asList(RowType.field((String)"name", (Type)VarcharType.VARCHAR), RowType.field((String)"phone_number", (Type)VarcharType.VARCHAR))));
        RowType addressBookType = RowType.from(Arrays.asList(RowType.field((String)"owner", (Type)VarcharType.VARCHAR), RowType.field((String)"owner_phone_numbers", (Type)new ArrayType((Type)VarcharType.VARCHAR)), RowType.field((String)"contacts", (Type)contactsType)));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(addressBookFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector), ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(contactsFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector))))), values, values, "address_book", (Type)addressBookType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithOptionalOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    optional group b {      optional group c {        required binary d (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List<?>> cValues = this.createNullableTestStructs(dValues);
        Iterable<List<?>> bValues = this.createNullableTestStructs(cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithOptionalRequiredOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    optional group b {      required group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        List<List<?>> cValues = this.createTestStructs((Iterable)dValues);
        Iterable<List<?>> bValues = this.createNullableTestStructs(cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredRequiredOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      required group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        List<List<?>> cValues = this.createTestStructs((Iterable)dValues);
        List<List<?>> bValues = this.createTestStructs((Iterable)cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalOptionalFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        optional int32 d;      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<Integer> dValues = Arrays.asList(111, null, 333, 444, null, 666, 777);
        Iterable<List<?>> cValues = this.createNullableTestStructs(dValues);
        List<List<?>> bValues = this.createTestStructs((Iterable)cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalRequiredFields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        required binary d (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List<?>> cValues = this.createNullableTestStructs(dValues);
        List<List<?>> bValues = this.createTestStructs((Iterable)cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        this.tester.testRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredStruct() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  required group a {    required group b {        required binary c (UTF8);        required int32 d;    }    required binary e (UTF8);  }} ");
        RowType bType = RowType.from(Arrays.asList(RowType.field((String)"c", (Type)VarcharType.VARCHAR), RowType.field((String)"d", (Type)IntegerType.INTEGER)));
        RowType aType = RowType.from(Arrays.asList(RowType.field((String)"b", (Type)bType), RowType.field((String)"e", (Type)VarcharType.VARCHAR)));
        Iterable cValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("c0", "c1", "c2", "c3", "c4", "c5", "c6", "c7")), (int)30000);
        ContiguousSet<Integer> dValues = AbstractTestParquetReader.intsBetween(0, 30000);
        Iterable eValues = Iterables.limit((Iterable)Iterables.cycle(Arrays.asList("e0", "e1", "e2", "e3", "e4", "e5", "e6", "e7")), (int)30000);
        List<List<?>> bValues = this.createTestStructs(new Iterable[]{cValues, dValues});
        List<List<?>> aValues = this.createTestStructs(bValues, eValues);
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("c", "d"), Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaIntObjectInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("b", "e"), Arrays.asList(bInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        this.tester.assertRoundTrip((ObjectInspector)aInspector, aValues, aValues, "a", (Type)aType, Optional.of(parquetSchema));
    }

    @Test
    public void testSchemaWithRequiredOptionalRequired2Fields() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group a {    required group b {      optional group c {        required binary d (UTF8);      }    }  }  optional group e {    required group f {      optional group g {        required binary h (UTF8);      }    }  }} ");
        RowType cType = RowType.from(Collections.singletonList(RowType.field((String)"d", (Type)VarcharType.VARCHAR)));
        RowType bType = RowType.from(Collections.singletonList(RowType.field((String)"c", (Type)cType)));
        RowType aType = RowType.from(Collections.singletonList(RowType.field((String)"b", (Type)bType)));
        List<String> dValues = Arrays.asList("d1", "d2", "d3", "d4", "d5", "d6", "d7");
        Iterable<List<?>> cValues = this.createNullableTestStructs(dValues);
        List<List<?>> bValues = this.createTestStructs((Iterable)cValues);
        List<List<?>> aValues = this.createTestStructs((Iterable)bValues);
        RowType gType = RowType.from(Collections.singletonList(RowType.field((String)"h", (Type)VarcharType.VARCHAR)));
        RowType fType = RowType.from(Collections.singletonList(RowType.field((String)"g", (Type)gType)));
        RowType eType = RowType.from(Collections.singletonList(RowType.field((String)"f", (Type)fType)));
        List<String> hValues = Arrays.asList("h1", "h2", "h3", "h4", "h5", "h6", "h7");
        Iterable<List<?>> gValues = this.createNullableTestStructs(hValues);
        List<List<?>> fValues = this.createTestStructs((Iterable)gValues);
        List<List<?>> eValues = this.createTestStructs((Iterable)fValues);
        StandardStructObjectInspector cInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("d"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector bInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("c"), Collections.singletonList(cInspector));
        StandardStructObjectInspector aInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("b"), Collections.singletonList(bInspector));
        StandardStructObjectInspector gInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("h"), Collections.singletonList(PrimitiveObjectInspectorFactory.javaStringObjectInspector));
        StandardStructObjectInspector fInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("g"), Collections.singletonList(gInspector));
        StandardStructObjectInspector eInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Collections.singletonList("f"), Collections.singletonList(fInspector));
        this.tester.testRoundTrip(Arrays.asList(aInspector, eInspector), new Iterable[]{aValues, eValues}, new Iterable[]{aValues, eValues}, Arrays.asList("a", "e"), Arrays.asList(aType, eType), Optional.of(parquetSchema), ParquetTester.ParquetSchemaOptions.defaultOptions());
    }

    @Test
    public void testOldAvroArray() throws Exception {
        MessageType parquetMrAvroSchema = MessageTypeParser.parseMessageType((String)"message avro_schema_old {  optional group my_list (LIST){        repeated int32 array;  }} ");
        List<List<Integer>> nonNullArrayElements = this.createTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 31234));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nonNullArrayElements, nonNullArrayElements, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrAvroSchema), ParquetTester.ParquetSchemaOptions.withSingleLevelArray());
    }

    @Test
    public void testNewAvroArray() throws Exception {
        MessageType parquetMrAvroSchema = MessageTypeParser.parseMessageType((String)"message avro_schema_new {   optional group my_list (LIST) {     repeated group list {       optional int32 element;     }   } }");
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrAvroSchema));
    }

    @Test
    public void testArraySchemas() throws Exception {
        MessageType parquetMrNullableSpecSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group list {        required int32 element;    }  }} ");
        List<List<Integer>> nonNullArrayElements = this.createTestArrays((Iterable)AbstractTestParquetReader.intsBetween(0, 31234));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nonNullArrayElements, nonNullArrayElements, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrNullableSpecSchema));
        MessageType parquetMrNonNullSpecSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  required group my_list (LIST){    repeated group list {        optional int32 element;    }  }} ");
        List values = this.createTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.assertRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(parquetMrNonNullSpecSchema));
        MessageType sparkSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group list {        optional int32 element;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(sparkSchema));
        MessageType hiveSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group bag {        optional int32 array_element;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(hiveSchema));
        MessageType customNamingSchema = MessageTypeParser.parseMessageType((String)"message hive_schema {  optional group my_list (LIST){    repeated group bag {        optional int32 array;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(customNamingSchema));
        MessageType optimizedParquetWriterOldListSchema = MessageTypeParser.parseMessageType((String)"message trino_schema {  optional group my_list (LIST){    repeated group list {        optional int32 array;    }  }} ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_list", (Type)new ArrayType((Type)IntegerType.INTEGER), Optional.of(optimizedParquetWriterOldListSchema));
    }

    @Test
    public void testMapSchemas() throws Exception {
        Iterable values = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 100000), Object::toString), (Iterable)AbstractTestParquetReader.intsBetween(0, 10000));
        Iterable nullableValues = this.createTestMaps(Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString), Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER));
        MessageType map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP) {     repeated group map {         required binary str (UTF8);           required int32 num;      }    }}   ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP_KEY_VALUE) {     repeated group map {         required binary str (UTF8);           required int32 num;      }    }}   ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP) {     repeated group map {          required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.assertRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP_KEY_VALUE) {     repeated group map {          required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.assertRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP) {     repeated group map {          required binary key (UTF8);             required int32 value;       }     } }  ");
        this.tester.assertRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { required group my_map (MAP_KEY_VALUE) {     repeated group map {          required binary key (UTF8);             required int32 value;       }     } }  ");
        this.tester.assertRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP) {     repeated group map {         required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
        map = MessageTypeParser.parseMessageType((String)"message hive_schema { optional group my_map (MAP_KEY_VALUE) {     repeated group map {         required binary key (UTF8);             optional int32 value;       }     } }  ");
        this.tester.testRoundTrip((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), nullableValues, nullableValues, "my_map", (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER), Optional.of(map));
    }

    @Test
    public void testLongStrideDictionary() throws Exception {
        this.testRoundTripNumeric(Iterables.concat((Iterable)ImmutableList.of((Object)1), Collections.nCopies(9999, 123), (Iterable)ImmutableList.of((Object)2), Collections.nCopies(9999, 123)));
    }

    private void testRoundTripNumeric(Iterable<Integer> writeValues) throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToByte), AbstractTestParquetReader::byteToInt, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToShort), AbstractTestParquetReader::shortToInt, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector, writeValues, (Type)IntegerType.INTEGER);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToLong), (Type)BigintType.BIGINT);
        Iterable timestampValues = Iterables.transform(writeValues, value -> value + 86400000);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaTimestampObjectInspector, Iterables.transform((Iterable)timestampValues, AbstractTestParquetReader::intToTimestamp), Iterables.transform((Iterable)timestampValues, AbstractTestParquetReader::intToSqlTimestamp), (Type)TimestampType.TIMESTAMP_MILLIS);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector, Iterables.transform(writeValues, AbstractTestParquetReader::intToDate), Iterables.transform(writeValues, AbstractTestParquetReader::intToSqlDate), (Type)DateType.DATE);
    }

    @Test
    public void testFloatSequence() throws Exception {
        Iterable<Float> writeValues = AbstractTestParquetReader.floatSequence(0.0, 0.1f, 30000);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, writeValues, (Type)RealType.REAL);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, writeValues, Iterables.transform(writeValues, AbstractTestParquetReader::floatToDouble), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testFloatNaNInfinity() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(1000.0f), (Object)Float.valueOf(-1.23f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(-1000.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.23f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-0.0f), (Object)Float.valueOf(1.0f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-1.0f), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(1.0f)), (Type)RealType.REAL);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY)), (Type)RealType.REAL);
        ImmutableList writeValues = ImmutableList.of((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-1000.0f), (Object)Float.valueOf(-0.0f), (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(Float.POSITIVE_INFINITY));
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector, (Iterable<?>)writeValues, Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::floatToDouble), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testDoubleSequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, AbstractTestParquetReader.doubleSequence(0.0, 0.1, 30000), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testDoubleNaNInfinity() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)1000.0, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)-1000.0, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)0.0, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)-1.0, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)1.0), (Type)DoubleType.DOUBLE);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector, (Iterable<?>)ImmutableList.of((Object)Double.NaN, (Object)Double.NEGATIVE_INFINITY, (Object)Double.POSITIVE_INFINITY), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testStringUnicode() throws Exception {
        Iterable writeValues = Iterables.limit((Iterable)Iterables.cycle((Iterable)ImmutableList.of((Object)"apple", (Object)"apple pie", (Object)"apple\ud835\udc03", (Object)"apple\ufffd")), (int)30000);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createUnboundedVarcharType());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createVarcharType((int)25));
        CharType charType = CharType.createCharType((int)25);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, value -> Chars.padSpaces((String)value, (CharType)charType), (Type)charType);
    }

    @Test
    public void testStringDirectSequence() throws Exception {
        Iterable writeValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), Object::toString);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createUnboundedVarcharType());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createVarcharType((int)5));
        CharType charType = CharType.createCharType((int)5);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, value -> Chars.padSpaces((String)value, (CharType)charType), (Type)charType);
    }

    @Test
    public void testStringDictionarySequence() throws Exception {
        Iterable writeValues = Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.transform((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17), Object::toString)), (int)30000);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createUnboundedVarcharType());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createVarcharType((int)3));
        CharType charType = CharType.createCharType((int)3);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, value -> Chars.padSpaces((String)value, (CharType)charType), (Type)charType);
    }

    @Test
    public void testStringStrideDictionary() throws Exception {
        Iterable writeValues = Iterables.concat((Iterable)ImmutableList.of((Object)"a"), Collections.nCopies(9999, "123"), (Iterable)ImmutableList.of((Object)"b"), Collections.nCopies(9999, "123"));
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createUnboundedVarcharType());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createVarcharType((int)3));
        CharType charType = CharType.createCharType((int)3);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, value -> Chars.padSpaces((String)value, (CharType)charType), (Type)charType);
    }

    @Test
    public void testEmptyStringSequence() throws Exception {
        Iterable writeValues = Iterables.limit((Iterable)Iterables.cycle((Object[])new String[]{""}), (int)30000);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createUnboundedVarcharType());
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, (Type)VarcharType.createVarcharType((int)3));
        CharType charType = CharType.createCharType((int)3);
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, writeValues, value -> Chars.padSpaces((String)value, (CharType)charType), (Type)charType);
    }

    @Test
    public void testBinaryDirectSequence() throws Exception {
        Iterable writeValues = Iterables.transform(AbstractTestParquetReader.intsBetween(0, 30000), (Function)Functions.compose(AbstractTestParquetReader::stringToByteArray, Object::toString));
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::byteArrayToVarbinary), (Type)VarbinaryType.VARBINARY);
    }

    @Test
    public void testReadFixedWidthByteArrayAsVarBinary() throws Exception {
        Random random = new Random(2342890824L);
        int typeLength = 5;
        List writeValues = (List)IntStream.range(0, 30000).mapToObj(i -> {
            byte[] value = new byte[typeLength];
            random.nextBytes(value);
            return value;
        }).collect(ImmutableList.toImmutableList());
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::byteArrayToVarbinary), (Type)VarbinaryType.VARBINARY, Optional.of(MessageTypeParser.parseMessageType((String)String.format("message varbinary { optional FIXED_LEN_BYTE_ARRAY(%s) test; }", typeLength))));
    }

    @Test
    public void testBinaryDictionarySequence() throws Exception {
        Iterable writeValues = Iterables.limit((Iterable)Iterables.cycle((Iterable)Iterables.transform((Iterable)ImmutableList.of((Object)1, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13, (Object)17), (Function)Functions.compose(AbstractTestParquetReader::stringToByteArray, Object::toString))), (int)30000);
        Iterable readValues = Iterables.transform((Iterable)writeValues, AbstractTestParquetReader::byteArrayToVarbinary);
        this.tester.testRoundTrip((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, readValues, (Type)VarbinaryType.VARBINARY);
        this.tester.testMaxReadBytes((ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, writeValues, readValues, (Type)VarbinaryType.VARBINARY, DataSize.ofBytes((long)1000L));
    }

    @Test
    public void testEmptyBinarySequence() throws Exception {
        this.tester.testRoundTrip((PrimitiveObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector, Iterables.limit((Iterable)Iterables.cycle(List.of(new byte[0])), (int)30000), AbstractTestParquetReader::byteArrayToVarbinary, (Type)VarbinaryType.VARBINARY);
    }

    private static <T> Iterable<T> skipEvery(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private final Iterator<T> delegate;
            private int position;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                while (this.delegate.hasNext()) {
                    Object next = this.delegate.next();
                    ++this.position;
                    if (this.position <= n) {
                        return next;
                    }
                    this.position = 0;
                }
                return this.endOfData();
            }
        };
    }

    @Test
    public void testStructMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = DataSize.ofBytes((long)1000L);
        List<List<?>> structValues = this.createTestStructs(Collections.nCopies(500, String.join((CharSequence)"", Collections.nCopies(33, "test"))), Collections.nCopies(500, String.join((CharSequence)"", Collections.nCopies(1, "test"))));
        List<String> structFieldNames = Arrays.asList("a", "b");
        RowType structType = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)VarcharType.VARCHAR), RowType.field((String)"b", (Type)VarcharType.VARCHAR)));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(structFieldNames, Arrays.asList(PrimitiveObjectInspectorFactory.javaStringObjectInspector, PrimitiveObjectInspectorFactory.javaStringObjectInspector)), structValues, structValues, (Type)structType, maxReadBlockSize);
    }

    @Test
    public void testArrayMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = DataSize.ofBytes((long)1000L);
        List values = this.createFixedTestArrays(Iterables.limit((Iterable)Iterables.cycle(Arrays.asList(1, null, 3, 5, null, null, null, 7, 11, null, 13, 17)), (int)30000));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector), values, values, (Type)new ArrayType((Type)IntegerType.INTEGER), maxReadBlockSize);
    }

    @Test
    public void testMapMaxReadBytes() throws Exception {
        DataSize maxReadBlockSize = DataSize.ofBytes((long)1000L);
        Iterable<Map<String, Long>> values = this.createFixedTestMaps((Iterable)Collections.nCopies(5000, String.join((CharSequence)"", Collections.nCopies(33, "test"))), (Iterable)AbstractTestParquetReader.longsBetween(0L, 5000L));
        this.tester.testMaxReadBytes((ObjectInspector)ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaLongObjectInspector), values, values, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT), maxReadBlockSize);
    }

    private static <T> Iterable<T> repeatEach(final int n, final Iterable<T> iterable) {
        return () -> new AbstractIterator<T>(){
            private final Iterator<T> delegate;
            private int position;
            private T value;
            {
                this.delegate = iterable.iterator();
            }

            protected T computeNext() {
                if (this.position == 0) {
                    if (!this.delegate.hasNext()) {
                        return this.endOfData();
                    }
                    this.value = this.delegate.next();
                }
                ++this.position;
                if (this.position >= n) {
                    this.position = 0;
                }
                return this.value;
            }
        };
    }

    private static Iterable<Float> floatSequence(double start, double step, int items) {
        return Iterables.transform(AbstractTestParquetReader.doubleSequence(start, step, items), input -> {
            if (input == null) {
                return null;
            }
            return Float.valueOf(input.floatValue());
        });
    }

    private static Iterable<Double> doubleSequence(double start, final double step, final int items) {
        return () -> new AbstractSequentialIterator<Double>(Double.valueOf(start)){
            private int item;

            protected Double computeNext(Double previous) {
                if (this.item >= items) {
                    return null;
                }
                ++this.item;
                return previous + step;
            }
        };
    }

    private static ContiguousSet<Integer> intsBetween(int lowerInclusive, int upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(lowerInclusive), (Comparable)Integer.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.integers());
    }

    private static ContiguousSet<Long> longsBetween(long lowerInclusive, long upperExclusive) {
        return ContiguousSet.create((Range)Range.closedOpen((Comparable)Long.valueOf(lowerInclusive), (Comparable)Long.valueOf(upperExclusive)), (DiscreteDomain)DiscreteDomain.longs());
    }

    private <F> List<List<?>> createTestStructs(Iterable<F> fieldValues) {
        Preconditions.checkArgument((boolean)fieldValues.iterator().hasNext(), (Object)"struct field values cannot be empty");
        ArrayList structs = new ArrayList();
        for (F field : fieldValues) {
            structs.add(Collections.singletonList(field));
        }
        return structs;
    }

    private List<List<?>> createTestStructs(Iterable<?> ... values) {
        ArrayList structs = new ArrayList();
        List<Iterator> iterators = Arrays.stream(values).map(Iterable::iterator).collect(Collectors.toList());
        iterators.forEach(iter -> Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"struct field values cannot be empty"));
        while (iterators.stream().allMatch(Iterator::hasNext)) {
            structs.add(iterators.stream().map(Iterator::next).collect(Collectors.toList()));
        }
        return structs;
    }

    private Iterable<List<?>> createNullableTestStructs(Iterable<?> ... values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestStructs(values));
    }

    private <T> List<List<T>> createTestArrays(Iterable<T> values) {
        ArrayList<List<T>> arrays = new ArrayList<List<T>>();
        Iterator<T> valuesIter = values.iterator();
        ArrayList<T> array = new ArrayList<T>();
        while (valuesIter.hasNext()) {
            if (ThreadLocalRandom.current().nextBoolean()) {
                arrays.add(array);
                array = new ArrayList();
            }
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                arrays.add(Collections.emptyList());
            }
            array.add(valuesIter.next());
        }
        return arrays;
    }

    private <T> Iterable<List<T>> createNullableTestArrays(Iterable<T> values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestArrays(values));
    }

    private <T> List<List<T>> createFixedTestArrays(Iterable<T> values) {
        ArrayList<List<T>> arrays = new ArrayList<List<T>>();
        Iterator<T> valuesIter = values.iterator();
        ArrayList<T> array = new ArrayList<T>();
        int count = 1;
        while (valuesIter.hasNext()) {
            if (count % 10 == 0) {
                arrays.add(array);
                array = new ArrayList();
            }
            if (count % 20 == 0) {
                arrays.add(Collections.emptyList());
            }
            array.add(valuesIter.next());
            ++count;
        }
        return arrays;
    }

    private <K, V> Iterable<Map<K, V>> createFixedTestMaps(Iterable<K> keys, Iterable<V> values) {
        ArrayList<Map<K, V>> maps = new ArrayList<Map<K, V>>();
        Iterator<K> keysIterator = keys.iterator();
        Iterator<V> valuesIterator = values.iterator();
        HashMap<K, V> map = new HashMap<K, V>();
        int count = 1;
        while (keysIterator.hasNext() && valuesIterator.hasNext()) {
            if (count % 5 == 0) {
                maps.add(map);
                map = new HashMap();
            }
            if (count % 10 == 0) {
                maps.add(Collections.emptyMap());
            }
            map.put(keysIterator.next(), valuesIterator.next());
            ++count;
        }
        return maps;
    }

    private <K, V> Iterable<Map<K, V>> createTestMaps(Iterable<K> keys, Iterable<V> values) {
        ArrayList<Map<K, V>> maps = new ArrayList<Map<K, V>>();
        Iterator<K> keysIterator = keys.iterator();
        Iterator<V> valuesIterator = values.iterator();
        HashMap<K, V> map = new HashMap<K, V>();
        while (keysIterator.hasNext() && valuesIterator.hasNext()) {
            if (ThreadLocalRandom.current().nextInt(5) == 0) {
                maps.add(map);
                map = new HashMap();
            }
            if (ThreadLocalRandom.current().nextInt(10) == 0) {
                maps.add(Collections.emptyMap());
            }
            map.put(keysIterator.next(), valuesIterator.next());
        }
        return maps;
    }

    private <K, V> Iterable<Map<K, V>> createNullableTestMaps(Iterable<K> keys, Iterable<V> values) {
        return ParquetTester.insertNullEvery(ThreadLocalRandom.current().nextInt(2, 5), this.createTestMaps(keys, values));
    }

    private static Byte intToByte(Integer input) {
        if (input == null) {
            return null;
        }
        return (byte)(input & 0xFF);
    }

    private static Short intToShort(Integer input) {
        if (input == null) {
            return null;
        }
        return Shorts.checkedCast((long)input.intValue());
    }

    private static Integer byteToInt(Byte input) {
        return AbstractTestParquetReader.toInteger(input);
    }

    private static Integer shortToInt(Short input) {
        return AbstractTestParquetReader.toInteger(input);
    }

    private static Long intToLong(Integer input) {
        return AbstractTestParquetReader.toLong(input);
    }

    private static <N extends Number> Integer toInteger(N input) {
        if (input == null) {
            return null;
        }
        return input.intValue();
    }

    private static <N extends Number> Long toLong(N input) {
        if (input == null) {
            return null;
        }
        return input.longValue();
    }

    private static byte[] stringToByteArray(String input) {
        return input.getBytes(StandardCharsets.UTF_8);
    }

    private static SqlVarbinary byteArrayToVarbinary(byte[] input) {
        if (input == null) {
            return null;
        }
        return new SqlVarbinary(input);
    }

    private static Timestamp intToTimestamp(Integer epochMillis) {
        if (epochMillis == null) {
            return null;
        }
        return AbstractTestParquetReader.longToTimestamp((long)epochMillis);
    }

    private static Timestamp longToTimestamp(Long epochMillis) {
        if (epochMillis == null) {
            return null;
        }
        long seconds = Math.floorDiv((long)epochMillis, 1000);
        int nanos = Math.floorMod((long)epochMillis, 1000) * 1000000;
        return Timestamp.ofEpochSecond((long)seconds, (int)nanos);
    }

    private static SqlTimestamp intToSqlTimestamp(Integer input) {
        if (input == null) {
            return null;
        }
        return DateTimeTestingUtils.sqlTimestampOf((long)input.intValue());
    }

    private static Date intToDate(Integer input) {
        if (input == null) {
            return null;
        }
        return Date.ofEpochDay((int)input);
    }

    private static SqlDate intToSqlDate(Integer input) {
        if (input == null) {
            return null;
        }
        return new SqlDate(input.intValue());
    }

    private static Double floatToDouble(Float input) {
        if (input == null) {
            return null;
        }
        return input.floatValue();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum DecimalInput {
        INT32{

            @Override
            String getPrimitiveTypeName(int precision) {
                return "INT32";
            }

            @Override
            int getMaxSupportedPrecision() {
                return MAX_PRECISION_INT32;
            }

            @Override
            ObjectInspector getParquetObjectInspector(int precision, int scale) {
                return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
            }

            @Override
            Object convertToWriteValue(BigInteger value, int scale) {
                return value.intValueExact();
            }
        }
        ,
        INT64{

            @Override
            String getPrimitiveTypeName(int precision) {
                return "INT64";
            }

            @Override
            int getMaxSupportedPrecision() {
                return MAX_PRECISION_INT64;
            }

            @Override
            ObjectInspector getParquetObjectInspector(int precision, int scale) {
                return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
            }

            @Override
            Object convertToWriteValue(BigInteger value, int scale) {
                return value.longValueExact();
            }
        }
        ,
        BINARY{

            @Override
            String getPrimitiveTypeName(int precision) {
                return "BINARY";
            }

            @Override
            int getMaxSupportedPrecision() {
                return 38;
            }

            @Override
            ObjectInspector getParquetObjectInspector(int precision, int scale) {
                return new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(precision, scale));
            }

            @Override
            Object convertToWriteValue(BigInteger value, int scale) {
                return HiveDecimal.create((BigInteger)value, (int)scale);
            }
        }
        ,
        FIXED_LEN_BYTE_ARRAY{

            @Override
            String getPrimitiveTypeName(int precision) {
                return String.format("FIXED_LEN_BYTE_ARRAY(%d)", ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[precision - 1]);
            }

            @Override
            int getMaxSupportedPrecision() {
                return 38;
            }

            @Override
            ObjectInspector getParquetObjectInspector(int precision, int scale) {
                return new JavaHiveDecimalObjectInspector(new DecimalTypeInfo(precision, scale));
            }

            @Override
            Object convertToWriteValue(BigInteger value, int scale) {
                return HiveDecimal.create((BigInteger)value, (int)scale);
            }
        };


        abstract String getPrimitiveTypeName(int var1);

        abstract int getMaxSupportedPrecision();

        abstract ObjectInspector getParquetObjectInspector(int var1, int var2);

        abstract Object convertToWriteValue(BigInteger var1, int var2);
    }
}

