/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.hdfs.HdfsFileSystemFactory;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.parquet.BloomFilterStore;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.predicate.TupleDomainParquetPredicate;
import io.trino.parquet.reader.MetadataReader;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestBloomFilterStore {
    private static final String COLUMN_NAME = "test_column";
    private static final int DOMAIN_COMPACTION_THRESHOLD = 32;
    ColumnDescriptor columnDescriptor = new ColumnDescriptor(new String[]{"test_column"}, new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "test_column"), 0, 0);

    @DataProvider
    public Object[][] bloomFilterTypeTests() {
        return new Object[][]{{new BloomFilterTypeTestCase(Arrays.asList("hello", "parquet", "bloom", "filter"), Arrays.asList("NotExist", "fdsvit"), (Type)VarcharType.createVarcharType((int)255), (ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList(12321, 3344, 72334, 321, Integer.MAX_VALUE, Integer.MIN_VALUE), Arrays.asList(89899, 897773), (Type)IntegerType.INTEGER, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList(892.22, 341112.2222, 43232.222121, 99988.22, Double.MAX_VALUE, Double.POSITIVE_INFINITY, Double.MIN_VALUE, Double.NEGATIVE_INFINITY), Arrays.asList(321.44, 776541.3214, 8.988465674311579E307), (Type)DoubleType.DOUBLE, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDoubleObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList(Float.valueOf(32.22f), Float.valueOf(341112.22f), Float.valueOf(43232.223f), Float.valueOf(32322.22f), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)), Arrays.asList(Float.valueOf(321.44f), Float.valueOf(321.3214f), Float.valueOf(0.0f)), (Type)RealType.REAL, (ObjectInspector)PrimitiveObjectInspectorFactory.javaFloatObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList((byte)32, (byte)67, (byte)127, (byte)127, (byte)89), Arrays.asList((byte)0, (byte)33, (byte)75), (Type)TinyintType.TINYINT, (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList((short)32, (short)3000, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE), Arrays.asList((short)0, (short)33, (short)43), (Type)SmallintType.SMALLINT, (ObjectInspector)PrimitiveObjectInspectorFactory.javaShortObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList(Date.ofEpochDay((int)0), Date.ofEpochDay((int)325), Date.ofEpochDay((int)99875553), Date.ofEpochDay((int)2456524)), Arrays.asList(Date.ofEpochDay((int)45), Date.ofEpochDay((int)67439216)), (Type)DateType.DATE, (ObjectInspector)PrimitiveObjectInspectorFactory.javaDateObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList("hello".getBytes(StandardCharsets.UTF_8), "parquet  ".getBytes(StandardCharsets.UTF_8), "bloom".getBytes(StandardCharsets.UTF_8), "filter".getBytes(StandardCharsets.UTF_8)), Arrays.asList("not".getBytes(StandardCharsets.UTF_8), "exist".getBytes(StandardCharsets.UTF_8), "testcaseX".getBytes(StandardCharsets.UTF_8), "parquet".getBytes(StandardCharsets.UTF_8)), (Type)VarbinaryType.VARBINARY, (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector)}, {new BloomFilterTypeTestCase(Arrays.asList(TestBloomFilterStore.uuidToBytes(UUID.fromString("783176de-b6c5-4c5a-905d-0460ae103050")), TestBloomFilterStore.uuidToBytes(UUID.fromString("b1a71c78-bd96-4117-a91a-18671530196a"))), Arrays.asList(TestBloomFilterStore.uuidToBytes(UUID.fromString("98a5f99c-7adb-4a92-ae10-6d2469d59423")), TestBloomFilterStore.uuidToBytes(UUID.fromString("19fd9aed-7a93-4ada-8966-f89014f499ec"))), (Type)UuidType.UUID, (ObjectInspector)PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector)}};
    }

    @Test(dataProvider="bloomFilterTypeTests")
    public void testReadBloomFilter(BloomFilterTypeTestCase typeTestCase) throws Exception {
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");){
            BloomFilterStore bloomFilterEnabled = TestBloomFilterStore.generateBloomFilterStore(tempFile, true, typeTestCase.writeValues, typeTestCase.objectInspector);
            Assert.assertTrue((boolean)bloomFilterEnabled.getBloomFilter(ColumnPath.fromDotString((String)COLUMN_NAME)).isPresent());
            BloomFilter bloomFilter = (BloomFilter)bloomFilterEnabled.getBloomFilter(ColumnPath.fromDotString((String)COLUMN_NAME)).get();
            for (Object data : typeTestCase.matchingValues) {
                Assert.assertTrue((boolean)TupleDomainParquetPredicate.checkInBloomFilter((BloomFilter)bloomFilter, (Object)data, (Type)typeTestCase.sqlType));
            }
            for (Object data : typeTestCase.nonMatchingValues) {
                Assert.assertFalse((boolean)TupleDomainParquetPredicate.checkInBloomFilter((BloomFilter)bloomFilter, (Object)data, (Type)typeTestCase.sqlType));
            }
        }
        tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");
        try {
            BloomFilterStore bloomFilterNotEnabled = TestBloomFilterStore.generateBloomFilterStore(tempFile, false, typeTestCase.writeValues, typeTestCase.objectInspector);
            Assert.assertTrue((boolean)bloomFilterNotEnabled.getBloomFilter(ColumnPath.fromDotString((String)COLUMN_NAME)).isEmpty());
        }
        finally {
            tempFile.close();
        }
    }

    @Test(dataProvider="bloomFilterTypeTests")
    public void testMatchesWithBloomFilter(BloomFilterTypeTestCase typeTestCase) throws Exception {
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");){
            BloomFilterStore bloomFilterStore = TestBloomFilterStore.generateBloomFilterStore(tempFile, true, typeTestCase.writeValues, typeTestCase.objectInspector);
            TupleDomain domain = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.multipleValues((Type)typeTestCase.sqlType, typeTestCase.matchingValues)));
            TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(domain, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)parquetPredicate.matches(bloomFilterStore, 32));
            TupleDomain domainWithoutMatch = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.multipleValues((Type)typeTestCase.sqlType, typeTestCase.nonMatchingValues)));
            TupleDomainParquetPredicate parquetPredicateWithoutMatch = new TupleDomainParquetPredicate(domainWithoutMatch, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertFalse((boolean)parquetPredicateWithoutMatch.matches(bloomFilterStore, 32));
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(new String[]{"non_exist_path"}, (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("Test column"), 0, 0);
            TupleDomain domainForColumnWithoutBloomFilter = TupleDomain.withColumnDomains(Collections.singletonMap(columnDescriptor, Domain.multipleValues((Type)typeTestCase.sqlType, typeTestCase.nonMatchingValues)));
            TupleDomainParquetPredicate predicateForColumnWithoutBloomFilter = new TupleDomainParquetPredicate(domainForColumnWithoutBloomFilter, Collections.singletonList(columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)predicateForColumnWithoutBloomFilter.matches(bloomFilterStore, 32));
        }
    }

    @Test
    public void testMatchesWithBloomFilterExpand() throws Exception {
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");){
            BloomFilterStore bloomFilterStore = TestBloomFilterStore.generateBloomFilterStore(tempFile, true, Arrays.asList(60, 61, 62, 63, 64, 65), (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
            TupleDomain domain = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)60L, (boolean)true, (Object)68L, (boolean)true))), (boolean)false)));
            TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(domain, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)parquetPredicate.matches(bloomFilterStore, 32));
            domain = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)-68L, (boolean)true, (Object)0L, (boolean)true))), (boolean)false)));
            parquetPredicate = new TupleDomainParquetPredicate(domain, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)parquetPredicate.matches(bloomFilterStore, 32));
            domain = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)-68L, (boolean)true, (Object)-60L, (boolean)true))), (boolean)false)));
            parquetPredicate = new TupleDomainParquetPredicate(domain, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertFalse((boolean)parquetPredicate.matches(bloomFilterStore, 32));
        }
    }

    @Test
    public void testMatchesWithBloomFilterNullValues() throws Exception {
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");){
            BloomFilterStore bloomFilterStore = TestBloomFilterStore.generateBloomFilterStore(tempFile, true, Arrays.asList(null, null, 62, 63, 64, 65), (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
            TupleDomain domain = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)60L, (boolean)true, (Object)68L, (boolean)true))), (boolean)false)));
            TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(domain, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)parquetPredicate.matches(bloomFilterStore, 32));
            TupleDomain domainWithoutMatch = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)-68L, (boolean)true, (Object)-60L, (boolean)true))), (boolean)false)));
            TupleDomainParquetPredicate parquetPredicateWithoutMatch = new TupleDomainParquetPredicate(domainWithoutMatch, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertFalse((boolean)parquetPredicateWithoutMatch.matches(bloomFilterStore, 32));
        }
    }

    @Test
    public void testMatchesWithBloomFilterNullPredicate() throws Exception {
        try (ParquetTester.TempFile tempFile = new ParquetTester.TempFile("testbloomfilter", ".parquet");){
            BloomFilterStore bloomFilterStore = TestBloomFilterStore.generateBloomFilterStore(tempFile, true, Arrays.asList(62, 63, 64, 65), (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
            TupleDomain domainWithoutMatch = TupleDomain.withColumnDomains(Collections.singletonMap(this.columnDescriptor, Domain.create((ValueSet)SortedRangeSet.copyOf((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)Range.range((Type)IntegerType.INTEGER, (Object)-68L, (boolean)true, (Object)-60L, (boolean)true))), (boolean)true)));
            TupleDomainParquetPredicate parquetPredicateWithoutMatch = new TupleDomainParquetPredicate(domainWithoutMatch, Collections.singletonList(this.columnDescriptor), DateTimeZone.UTC);
            Assert.assertTrue((boolean)parquetPredicateWithoutMatch.matches(bloomFilterStore, 32));
        }
    }

    private static BloomFilterStore generateBloomFilterStore(ParquetTester.TempFile tempFile, boolean enableBloomFilter, List<Object> testValues, ObjectInspector objectInspector) throws Exception {
        List<ObjectInspector> objectInspectors = Collections.singletonList(objectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)COLUMN_NAME);
        JobConf jobConf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());
        jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
        jobConf.setBoolean("parquet.bloom.filter.enabled", enableBloomFilter);
        ParquetTester.writeParquetColumn(jobConf, tempFile.getFile(), CompressionCodec.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{testValues.iterator()}, Optional.empty(), false, DateTimeZone.getDefault());
        HdfsFileSystemFactory fileSystemFactory = new HdfsFileSystemFactory(HiveTestUtils.HDFS_ENVIRONMENT);
        TrinoFileSystem fileSystem = fileSystemFactory.create(HiveTestUtils.getHiveSession(new HiveConfig().setHiveStorageFormat(HiveStorageFormat.PARQUET)));
        TrinoInputFile inputFile = fileSystem.newInputFile(tempFile.getFile().getPath());
        TrinoParquetDataSource dataSource = new TrinoParquetDataSource(inputFile, new ParquetReaderOptions(), new FileFormatDataSourceStats());
        ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
        ColumnChunkMetaData columnChunkMetaData = (ColumnChunkMetaData)Iterables.getOnlyElement((Iterable)((BlockMetaData)Iterables.getOnlyElement((Iterable)parquetMetadata.getBlocks())).getColumns());
        return new BloomFilterStore((ParquetDataSource)dataSource, (BlockMetaData)Iterables.getOnlyElement((Iterable)parquetMetadata.getBlocks()), Set.of(columnChunkMetaData.getPath()));
    }

    private static byte[] uuidToBytes(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    private static class BloomFilterTypeTestCase {
        private final List<Object> matchingValues;
        private final List<Object> nonMatchingValues;
        private final List<Object> writeValues;
        private final Type sqlType;
        private final ObjectInspector objectInspector;

        private BloomFilterTypeTestCase(List<Object> writeValues, List<Object> nonMatchingValues, Type sqlType, ObjectInspector objectInspector) {
            this.sqlType = Objects.requireNonNull(sqlType);
            this.objectInspector = Objects.requireNonNull(objectInspector);
            this.writeValues = Objects.requireNonNull(writeValues);
            this.matchingValues = (List)writeValues.stream().map(data -> HiveTestUtils.toNativeContainerValue(sqlType, data)).collect(ImmutableList.toImmutableList());
            this.nonMatchingValues = (List)nonMatchingValues.stream().map(data -> HiveTestUtils.toNativeContainerValue(sqlType, data)).collect(ImmutableList.toImmutableList());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("writeValues", this.writeValues).add("sqlType", (Object)this.sqlType).toString();
        }
    }
}

