/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.Session;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.plugin.hive.parquet.ParquetTester;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.CompressionCodec;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTimeZone;
import org.testng.annotations.Test;

public class TestHiveParquetWithBloomFilters
extends AbstractTestQueryFramework {
    private static final String COLUMN_NAME = "dataColumn";
    private static final List<Integer> TEST_VALUES = Arrays.asList(Integer.MIN_VALUE, Integer.MAX_VALUE, 1, 3, 7, 10, 15);
    private static final int MISSING_VALUE = 0;

    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().build();
    }

    @Test
    public void verifyBloomFilterEnabled() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SHOW SESSION LIKE '%s.parquet_use_bloom_filter'", this.getSession().getCatalog().orElseThrow())))).skippingTypesCheck().matches(result -> result.getRowCount() == 1)).matches(result -> {
            String value = (String)((MaterializedRow)result.getMaterializedRows().get(0)).getField(1);
            return value.equals("true");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBloomFilterRowGroupPruning() throws Exception {
        File tmpDir = Files.createTempDirectory("testBloomFilterRowGroupPruning", new FileAttribute[0]).toFile();
        try {
            File parquetFile = new File(tmpDir, TestingNames.randomNameSuffix());
            String tableName = "parquet_with_bloom_filters_" + TestingNames.randomNameSuffix();
            TestHiveParquetWithBloomFilters.createParquetBloomFilterSource(parquetFile, COLUMN_NAME, TEST_VALUES);
            this.assertUpdate(String.format("CREATE TABLE %s (%s INT) WITH (format = 'PARQUET', external_location = '%s')", tableName, COLUMN_NAME, tmpDir.getAbsolutePath()));
            this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE dataColumn = 0", queryStats -> {
                Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isEqualTo(0L);
                Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(0L);
            }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
            this.assertQueryStats(this.getSession(), "SELECT * FROM " + tableName + " WHERE dataColumn = " + TEST_VALUES.get(0), queryStats -> {
                Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
                Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
            }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(1));
            this.assertQueryStats(TestHiveParquetWithBloomFilters.bloomFiltersDisabled(this.getSession()), "SELECT * FROM " + tableName + " WHERE dataColumn = 0", queryStats -> {
                Assertions.assertThat((long)queryStats.getPhysicalInputPositions()).isGreaterThan(0L);
                Assertions.assertThat((long)queryStats.getProcessedInputPositions()).isEqualTo(queryStats.getPhysicalInputPositions());
            }, results -> Assertions.assertThat((int)results.getRowCount()).isEqualTo(0));
        }
        catch (Throwable throwable) {
            MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
            throw throwable;
        }
        MoreFiles.deleteRecursively((Path)tmpDir.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    private static Session bloomFiltersDisabled(Session session) {
        return Session.builder((Session)session).setCatalogSessionProperty((String)session.getCatalog().orElseThrow(), "parquet_use_bloom_filter", "false").build();
    }

    private static void createParquetBloomFilterSource(File tempFile, String columnName, List<Integer> testValues) throws Exception {
        List<JavaIntObjectInspector> objectInspectors = Collections.singletonList(PrimitiveObjectInspectorFactory.javaIntObjectInspector);
        ImmutableList columnNames = ImmutableList.of((Object)columnName);
        JobConf jobConf = new JobConf(ConfigurationInstantiator.newEmptyConfiguration());
        jobConf.setEnum("parquet.writer.version", (Enum)ParquetProperties.WriterVersion.PARQUET_1_0);
        jobConf.setBoolean("parquet.bloom.filter.enabled", true);
        ParquetTester.writeParquetColumn(jobConf, tempFile, CompressionCodec.SNAPPY, ParquetTester.createTableProperties((List<String>)columnNames, objectInspectors), (SettableStructObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector((List)columnNames, objectInspectors), new Iterator[]{testValues.iterator()}, Optional.empty(), false, DateTimeZone.getDefault());
    }
}

