/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestParquetPageSourceFactory {
    @Test(dataProvider="useColumnNames")
    public void testGetNestedMixedRepetitionColumnType(boolean useColumnNames) {
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"optional_level2", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"required_level3", (Type)IntegerType.INTEGER)}))});
        HiveColumnHandle columnHandle = new HiveColumnHandle("optional_level1", 0, HiveType.valueOf((String)"struct<optional_level2:struct<required_level3:int>>"), (Type)rowType, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)1, (Object)1), (List)ImmutableList.of((Object)"optional_level2", (Object)"required_level3"), HiveType.toHiveType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER)), HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        MessageType fileSchema = new MessageType("hive_schema", new org.apache.parquet.schema.Type[]{new GroupType(Type.Repetition.OPTIONAL, "optional_level1", new org.apache.parquet.schema.Type[]{new GroupType(Type.Repetition.OPTIONAL, "optional_level2", new org.apache.parquet.schema.Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "required_level3")})})});
        Assert.assertEquals(ParquetPageSourceFactory.getColumnType((HiveColumnHandle)columnHandle, (MessageType)fileSchema, (boolean)useColumnNames).get(), (Object)fileSchema.getType("optional_level1"));
    }

    @DataProvider
    public Object[][] useColumnNames() {
        return new Object[][]{{true}, {false}};
    }
}

