/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import java.util.Map;
import org.testng.annotations.Test;

public class TestParquetWriterConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((ParquetWriterConfig)ConfigAssertions.recordDefaults(ParquetWriterConfig.class)).setParquetOptimizedWriterEnabled(false).setBlockSize(DataSize.ofBytes((long)0x8000000L)).setPageSize(DataSize.ofBytes((long)0x100000L)).setBatchSize(10000).setValidationPercentage(5.0));
    }

    @Test
    public void testLegacyProperties() {
        ConfigAssertions.assertDeprecatedEquivalence(ParquetWriterConfig.class, Map.of("parquet.optimized-writer.enabled", "true", "parquet.writer.block-size", "2PB", "parquet.writer.page-size", "3PB"), (Map[])new Map[]{Map.of("parquet.experimental-optimized-writer.enabled", "true", "hive.parquet.writer.block-size", "2PB", "hive.parquet.writer.page-size", "3PB"), Map.of("hive.parquet.optimized-writer.enabled", "true", "hive.parquet.writer.block-size", "2PB", "hive.parquet.writer.page-size", "3PB")});
    }

    @Test
    public void testExplicitPropertyMappings() {
        Map<String, String> properties = Map.of("parquet.optimized-writer.enabled", "true", "parquet.writer.block-size", "234MB", "parquet.writer.page-size", "11MB", "parquet.writer.batch-size", "100", "parquet.optimized-writer.validation-percentage", "10");
        ParquetWriterConfig expected = new ParquetWriterConfig().setParquetOptimizedWriterEnabled(true).setBlockSize(DataSize.of((long)234L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setPageSize(DataSize.of((long)11L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setBatchSize(100).setValidationPercentage(10.0);
        ConfigAssertions.assertFullMapping(properties, (Object)expected);
    }
}

