/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.io.Resources;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.benchmark.StandardFileFormats;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.testing.DataProviders;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.TestingConnectorSession;
import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTimestampMicros {
    @Test(dataProvider="testTimestampMicrosDataProvider")
    public void testTimestampMicros(HiveTimestampPrecision timestampPrecision, LocalDateTime expected, boolean useOptimizedParquetReader) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig().setTimestampPrecision(timestampPrecision), new ParquetReaderConfig().setOptimizedReaderEnabled(useOptimizedParquetReader));
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampType columnType = TimestampType.createTimestampType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = this.createPageSource((ConnectorSession)session, parquetFile, "created", HiveType.HIVE_TIMESTAMP, (Type)columnType);){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected))});
        }
    }

    @Test(dataProvider="testTimestampMicrosDataProvider")
    public void testTimestampMicrosAsTimestampWithTimeZone(HiveTimestampPrecision timestampPrecision, LocalDateTime expected, boolean useOptimizedParquetReader) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig().setTimestampPrecision(timestampPrecision), new ParquetReaderConfig().setOptimizedReaderEnabled(useOptimizedParquetReader));
        File parquetFile = new File(Resources.getResource((String)"issue-5483.parquet").toURI());
        TimestampWithTimeZoneType columnType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)timestampPrecision.getPrecision());
        try (ConnectorPageSource pageSource = this.createPageSource((ConnectorSession)session, parquetFile, "created", HiveType.HIVE_TIMESTAMP, (Type)columnType);){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)session, (ConnectorPageSource)pageSource, List.of(columnType)).toTestTypes();
            Assertions.assertThat((List)result.getMaterializedRows()).containsOnly((Object[])new MaterializedRow[]{new MaterializedRow(List.of(expected.atZone(ZoneId.of("UTC"))))});
        }
    }

    @DataProvider
    public static Object[][] testTimestampMicrosDataProvider() {
        return DataProviders.cartesianProduct((Object[][][])new Object[][][]{{{HiveTimestampPrecision.MILLISECONDS, LocalDateTime.parse("2020-10-12T16:26:02.907")}, {HiveTimestampPrecision.MICROSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668")}, {HiveTimestampPrecision.NANOSECONDS, LocalDateTime.parse("2020-10-12T16:26:02.906668")}}, {{true}, {false}}});
    }

    private ConnectorPageSource createPageSource(ConnectorSession session, File parquetFile, String columnName, HiveType columnHiveType, Type columnType) {
        HivePageSourceFactory pageSourceFactory = StandardFileFormats.TRINO_PARQUET.getHivePageSourceFactory(HiveTestUtils.HDFS_ENVIRONMENT).orElseThrow();
        Properties schema = new Properties();
        schema.setProperty("serialization.lib", HiveStorageFormat.PARQUET.getSerde());
        ReaderPageSource pageSourceWithProjections = (ReaderPageSource)pageSourceFactory.createPageSource(ConfigurationInstantiator.newEmptyConfiguration(), session, new Path(parquetFile.toURI()), 0L, parquetFile.length(), parquetFile.length(), schema, List.of(HiveColumnHandle.createBaseColumn((String)columnName, (int)0, (HiveType)columnHiveType, (Type)columnType, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty())), TupleDomain.all(), Optional.empty(), OptionalInt.empty(), false, AcidTransaction.NO_ACID_TRANSACTION).orElseThrow();
        pageSourceWithProjections.getReaderColumns().ifPresent(projections -> {
            throw new IllegalStateException("Unexpected projections: " + projections);
        });
        return pageSourceWithProjections.get();
    }
}

