/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import io.airlift.testing.Closeables;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.testing.TestingNames;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BaseTestTrinoS3FileSystemObjectStorage {
    private static final MediaType DIRECTORY_MEDIA_TYPE = MediaType.create((String)"application", (String)"x-directory");
    private static final String PATH_SEPARATOR = "/";
    private static final String DIRECTORY_SUFFIX = "_$folder$";

    protected abstract String getBucketName();

    protected abstract Configuration s3Configuration();

    @Test
    public void testDeleteRecursivelyMissingObjectPath() throws Exception {
        String prefix = "test-delete-recursively-missing-object-" + TestingNames.randomNameSuffix();
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s".formatted(this.getBucketName(), prefix)), true));
        }
    }

    @Test
    public void testDeleteNonRecursivelyMissingObjectPath() throws Exception {
        String prefix = "test-delete-non-recursively-missing-object-" + TestingNames.randomNameSuffix();
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s".formatted(this.getBucketName(), prefix)), false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyObjectPath() throws Exception {
        String prefix = "test-delete-recursively-object-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String filename = "file.txt";
                String fileKey = "%s/%s".formatted(prefix, filename);
                String filePath = "s3://%s/%s/%s".formatted(this.getBucketName(), prefix, filename);
                fs.createNewFile(new Path(prefixPath, filename));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{fileKey});
                Assert.assertTrue((boolean)fs.delete(new Path(filePath), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyObjectPath() throws Exception {
        String prefix = "test-delete-non-recursively-object-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String filename = "file.txt";
                String fileKey = "%s/%s".formatted(prefix, filename);
                String filePath = "s3://%s/%s".formatted(this.getBucketName(), fileKey);
                fs.createNewFile(new Path(prefixPath, filename));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{fileKey});
                Assert.assertTrue((boolean)fs.delete(new Path(filePath), false));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyObjectNamePrefixingAnotherObjectName() throws Exception {
        String prefix = "test-delete-non-recursively-object-delete-only-requested-object-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                fs.createNewFile(new Path(prefixPath, "foo"));
                fs.createNewFile(new Path(prefixPath, "foobar"));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foo".formatted(prefix), "%s/foobar".formatted(prefix)});
                Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s/foo".formatted(this.getBucketName(), prefix)), false));
                paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foobar".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyDirectoryNamePrefixingAnotherDirectoryName() throws Exception {
        String prefix = "test-delete-non-recursively-object-delete-only-requested-directory-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), "%s/foo".formatted(prefix));
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), "%s/foobar".formatted(prefix));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foo/".formatted(prefix), "%s/foobar/".formatted(prefix)});
                Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s/foo".formatted(this.getBucketName(), prefix)), true));
                paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foobar/".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyEmptyDirectory() throws Exception {
        String prefix = "test-delete-non-recursively-empty-directory-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), prefix);
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, false);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{prefix + PATH_SEPARATOR});
                Assert.assertTrue((boolean)fs.delete(new Path(prefixPath), false));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyEmptyDirectoryWithAdditionalDirectorySuffixPlaceholder() throws Exception {
        String directoryName = "test-delete-non-recursively-empty-directory-" + TestingNames.randomNameSuffix();
        String directoryPath = "s3://%s/%s".formatted(this.getBucketName(), directoryName);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryName);
                fs.createNewFile(new Path(directoryPath + DIRECTORY_SUFFIX));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), directoryName, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{directoryName + PATH_SEPARATOR, directoryName + DIRECTORY_SUFFIX});
                Assert.assertTrue((boolean)fs.delete(new Path(directoryPath), false));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), directoryName, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(directoryPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyObjectNamePrefixingAnotherObjectName() throws Exception {
        String prefix = "test-delete-recursively-object-delete-only-requested-object-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                fs.createNewFile(new Path(prefixPath, "foo"));
                fs.createNewFile(new Path(prefixPath, "foobar"));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foo".formatted(prefix), "%s/foobar".formatted(prefix)});
                Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s/foo".formatted(this.getBucketName(), prefix)), true));
                paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foobar".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyDirectoryNamePrefixingAnotherDirectoryName() throws Exception {
        String prefix = "test-delete-recursively-object-delete-only-requested-directory-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), "%s/foo".formatted(prefix));
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), "%s/foobar".formatted(prefix));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foo/".formatted(prefix), "%s/foobar/".formatted(prefix)});
                Assert.assertTrue((boolean)fs.delete(new Path("s3://%s/%s/foo".formatted(this.getBucketName(), prefix)), true));
                paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/foobar/".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyPrefixContainingMultipleObjectsPlain() throws Exception {
        String prefix = "test-delete-recursively-path-multiple-objects-plain-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String filename1 = "file1.txt";
                String filename2 = "file2.txt";
                fs.createNewFile(new Path(prefixPath, filename1));
                fs.createNewFile(new Path(prefixPath, filename2));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/%s".formatted(prefix, filename1), "%s/%s".formatted(prefix, filename2)});
                Assert.assertTrue((boolean)fs.delete(new Path(prefixPath), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyDirectoryWithDeepHierarchy() throws Exception {
        String prefix = "test-delete-recursively-directory-deep-hierarchy-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String directoryKey = prefix + "/directory";
                String directoryPath = "s3://%s/%s".formatted(this.getBucketName(), directoryKey);
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey);
                String filename1 = "file1.txt";
                String filename2 = "file2.txt";
                String filename3 = "file3.txt";
                fs.createNewFile(new Path(directoryPath, filename1));
                fs.createNewFile(new Path(directoryPath, filename2));
                fs.createNewFile(new Path(directoryPath + "/dir3", filename3));
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey + "/dir4");
                Assert.assertTrue((boolean)fs.delete(new Path(directoryPath), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyEmptyDirectory() throws Exception {
        String prefix = "test-delete-recursively-empty-directory-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String directoryKey = prefix + "/directory";
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey);
                fs.createNewFile(new Path("s3://%s/%s%s".formatted(this.getBucketName(), directoryKey, DIRECTORY_SUFFIX)));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{directoryKey + PATH_SEPARATOR, directoryKey + DIRECTORY_SUFFIX});
                Assert.assertTrue((boolean)fs.delete(new Path(prefixPath + "/directory"), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyDirectoryWithObjectsAndDirectorySuffixPlaceholder() throws Exception {
        String prefix = "test-delete-recursively-directory-multiple-objects-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String directoryKey = prefix + "/directory";
                String directoryPath = "s3://%s/%s".formatted(this.getBucketName(), directoryKey);
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey);
                fs.createNewFile(new Path(directoryPath + DIRECTORY_SUFFIX));
                String filename1 = "file1.txt";
                String filename2 = "file2.txt";
                String filename3 = "file3.txt";
                fs.createNewFile(new Path(directoryPath, filename1));
                fs.createNewFile(new Path(directoryPath, filename2));
                fs.createNewFile(new Path(directoryPath + "/dir3", filename3));
                fs.createNewFile(new Path(directoryPath + "/dir3_$folder$"));
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey + "/dir4");
                fs.createNewFile(new Path(directoryPath + "/dir4_$folder$"));
                Assert.assertTrue((boolean)fs.delete(new Path(directoryPath), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteRecursivelyPrefixContainingDeepHierarchy() throws Exception {
        String prefix = "test-delete-recursively-prefix-deep-hierarchy-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String filename1 = "file1.txt";
                String filename2 = "file2.txt";
                String filename3 = "file3.txt";
                fs.createNewFile(new Path("s3://%s/%s/dir1".formatted(this.getBucketName(), prefix), filename1));
                fs.createNewFile(new Path("s3://%s/%s/dir2/dir22".formatted(this.getBucketName(), prefix), filename2));
                fs.createNewFile(new Path("s3://%s/%s/dir3/dir33/dir333".formatted(this.getBucketName(), prefix), filename3));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/dir1/%s".formatted(prefix, filename1), "%s/dir2/dir22/%s".formatted(prefix, filename2), "%s/dir3/dir33/dir333/%s".formatted(prefix, filename3)});
                Assert.assertTrue((boolean)fs.delete(new Path(prefixPath), true));
                Assertions.assertThat(BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true)).isEmpty();
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyNonEmptyDirectory() throws Exception {
        String prefix = "test-illegal-delete-non-recursively-directory-non-empty-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String directoryKey = prefix + "/directory";
                String directoryPath = "s3://%s/%s".formatted(this.getBucketName(), directoryKey);
                BaseTestTrinoS3FileSystemObjectStorage.createDirectory(fs.getS3Client(), this.getBucketName(), directoryKey);
                fs.createNewFile(new Path(directoryPath, "file1.txt"));
                Assertions.assertThatThrownBy(() -> fs.delete(new Path(directoryPath), false)).hasMessage("Directory %s is not empty".formatted(directoryPath));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/directory/".formatted(prefix), "%s/directory/file1.txt".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyNonEmptyPath() throws Exception {
        String prefix = "test-illegal-delete-non-recursively-path-non-empty-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                fs.createNewFile(new Path(prefixPath, "file1.txt"));
                Assertions.assertThatThrownBy(() -> fs.delete(new Path("s3://%s/%s".formatted(this.getBucketName(), prefix)), false)).hasMessage("Directory s3://%s/%s is not empty".formatted(this.getBucketName(), prefix));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/file1.txt".formatted(prefix)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteNonRecursivelyNonEmptyDeepPath() throws Exception {
        String prefix = "test-illegal-delete-non-recursively-deep-path-non-empty-" + TestingNames.randomNameSuffix();
        String prefixPath = "s3://%s/%s".formatted(this.getBucketName(), prefix);
        try (TrinoS3FileSystem fs = this.createFileSystem();){
            try {
                String filename1 = "file1.txt";
                String filename2 = "file2.txt";
                fs.createNewFile(new Path(prefixPath + "/dir1/", filename1));
                fs.createNewFile(new Path(prefixPath + "/dir2/", filename2));
                List<String> paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/dir1/%s".formatted(prefix, filename1), "%s/dir2/%s".formatted(prefix, filename2)});
                Assertions.assertThatThrownBy(() -> fs.delete(new Path("s3://%s/%s".formatted(this.getBucketName(), prefix)), false)).hasMessage("Directory s3://%s/%s is not empty".formatted(this.getBucketName(), prefix));
                paths = BaseTestTrinoS3FileSystemObjectStorage.listPaths(fs.getS3Client(), this.getBucketName(), prefix, true);
                Assertions.assertThat(paths).containsOnly((Object[])new String[]{"%s/dir1/%s".formatted(prefix, filename1), "%s/dir2/%s".formatted(prefix, filename2)});
            }
            finally {
                fs.delete(new Path(prefixPath), true);
            }
        }
    }

    protected TrinoS3FileSystem createFileSystem() throws Exception {
        TrinoS3FileSystem fs = new TrinoS3FileSystem();
        try {
            fs.initialize(new URI("s3://%s/".formatted(this.getBucketName())), this.s3Configuration());
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{fs});
            throw e;
        }
        return fs;
    }

    protected static void createDirectory(AmazonS3 client, String bucketName, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(0L);
        metadata.setContentType(DIRECTORY_MEDIA_TYPE.toString());
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key + PATH_SEPARATOR, (InputStream)emptyContent, metadata);
        client.putObject(putObjectRequest);
    }

    protected static List<String> listPaths(AmazonS3 s3, String bucketName, String prefix, boolean recursive) {
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix).withDelimiter(recursive ? null : PATH_SEPARATOR);
        ListObjectsV2Result listing = s3.listObjectsV2(request);
        ArrayList<String> paths = new ArrayList<String>();
        paths.addAll(listing.getCommonPrefixes());
        paths.addAll((Collection)listing.getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(ImmutableList.toImmutableList()));
        return paths;
    }
}

