/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.s3.HiveS3Config;
import io.trino.plugin.hive.s3.TrinoS3AclType;
import io.trino.plugin.hive.s3.TrinoS3SignerType;
import io.trino.plugin.hive.s3.TrinoS3SseType;
import io.trino.plugin.hive.s3.TrinoS3StorageClass;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestHiveS3Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((HiveS3Config)ConfigAssertions.recordDefaults(HiveS3Config.class)).setS3AwsAccessKey(null).setS3AwsSecretKey(null).setS3Endpoint(null).setS3Region(null).setS3SignerType(null).setS3SignerClass(null).setS3PathStyleAccess(false).setS3IamRole(null).setS3ExternalId(null).setS3StorageClass(TrinoS3StorageClass.STANDARD).setS3SslEnabled(true).setS3SseEnabled(false).setS3SseType(TrinoS3SseType.S3).setS3SseKmsKeyId(null).setS3KmsKeyId(null).setS3EncryptionMaterialsProvider(null).setS3MaxClientRetries(5).setS3MaxErrorRetries(10).setS3MaxBackoffTime(new Duration(10.0, TimeUnit.MINUTES)).setS3MaxRetryTime(new Duration(10.0, TimeUnit.MINUTES)).setS3ConnectTimeout(new Duration(5.0, TimeUnit.SECONDS)).setS3ConnectTtl(null).setS3SocketTimeout(new Duration(5.0, TimeUnit.SECONDS)).setS3MultipartMinFileSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3MultipartMinPartSize(DataSize.of((long)5L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3MaxConnections(500).setS3StagingDirectory(new File(StandardSystemProperty.JAVA_IO_TMPDIR.value())).setPinS3ClientToCurrentRegion(false).setS3UserAgentPrefix("").setS3AclType(TrinoS3AclType.PRIVATE).setSkipGlacierObjects(false).setRequesterPaysEnabled(false).setS3StreamingUploadEnabled(true).setS3StreamingPartSize(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3ProxyHost(null).setS3ProxyPort(-1).setS3ProxyProtocol("HTTPS").setS3NonProxyHosts((List)ImmutableList.of()).setS3ProxyUsername(null).setS3ProxyPassword(null).setS3PreemptiveBasicProxyAuth(false).setS3StsEndpoint(null).setS3StsRegion(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path stagingDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.s3.aws-access-key", (Object)"abc123").put((Object)"hive.s3.aws-secret-key", (Object)"secret").put((Object)"hive.s3.endpoint", (Object)"endpoint.example.com").put((Object)"hive.s3.region", (Object)"eu-central-1").put((Object)"hive.s3.signer-type", (Object)"S3SignerType").put((Object)"hive.s3.signer-class", (Object)"com.amazonaws.services.s3.internal.AWSS3V4Signer").put((Object)"hive.s3.path-style-access", (Object)"true").put((Object)"hive.s3.iam-role", (Object)"roleArn").put((Object)"hive.s3.external-id", (Object)"externalId").put((Object)"hive.s3.storage-class", (Object)"INTELLIGENT_TIERING").put((Object)"hive.s3.ssl.enabled", (Object)"false").put((Object)"hive.s3.sse.enabled", (Object)"true").put((Object)"hive.s3.sse.type", (Object)"KMS").put((Object)"hive.s3.sse.kms-key-id", (Object)"KMS_KEY_ID").put((Object)"hive.s3.encryption-materials-provider", (Object)"EMP_CLASS").put((Object)"hive.s3.kms-key-id", (Object)"KEY_ID").put((Object)"hive.s3.max-client-retries", (Object)"9").put((Object)"hive.s3.max-error-retries", (Object)"8").put((Object)"hive.s3.max-backoff-time", (Object)"4m").put((Object)"hive.s3.max-retry-time", (Object)"20m").put((Object)"hive.s3.connect-timeout", (Object)"8s").put((Object)"hive.s3.connect-ttl", (Object)"30m").put((Object)"hive.s3.socket-timeout", (Object)"4m").put((Object)"hive.s3.multipart.min-file-size", (Object)"32MB").put((Object)"hive.s3.multipart.min-part-size", (Object)"15MB").put((Object)"hive.s3.max-connections", (Object)"77").put((Object)"hive.s3.staging-directory", (Object)stagingDirectory.toString()).put((Object)"hive.s3.pin-client-to-current-region", (Object)"true").put((Object)"hive.s3.user-agent-prefix", (Object)"user-agent-prefix").put((Object)"hive.s3.upload-acl-type", (Object)"PUBLIC_READ").put((Object)"hive.s3.skip-glacier-objects", (Object)"true").put((Object)"hive.s3.requester-pays.enabled", (Object)"true").put((Object)"hive.s3.streaming.enabled", (Object)"false").put((Object)"hive.s3.streaming.part-size", (Object)"15MB").put((Object)"hive.s3.proxy.host", (Object)"localhost").put((Object)"hive.s3.proxy.port", (Object)"14000").put((Object)"hive.s3.proxy.protocol", (Object)"HTTP").put((Object)"hive.s3.proxy.non-proxy-hosts", (Object)"test,test2,test3").put((Object)"hive.s3.proxy.username", (Object)"test").put((Object)"hive.s3.proxy.password", (Object)"test").put((Object)"hive.s3.proxy.preemptive-basic-auth", (Object)"true").put((Object)"hive.s3.sts.endpoint", (Object)"http://minio:9000").put((Object)"hive.s3.sts.region", (Object)"eu-central-1").buildOrThrow();
        HiveS3Config expected = new HiveS3Config().setS3AwsAccessKey("abc123").setS3AwsSecretKey("secret").setS3Endpoint("endpoint.example.com").setS3Region("eu-central-1").setS3SignerType(TrinoS3SignerType.S3SignerType).setS3SignerClass("com.amazonaws.services.s3.internal.AWSS3V4Signer").setS3PathStyleAccess(true).setS3IamRole("roleArn").setS3ExternalId("externalId").setS3StorageClass(TrinoS3StorageClass.INTELLIGENT_TIERING).setS3SslEnabled(false).setS3SseEnabled(true).setS3SseType(TrinoS3SseType.KMS).setS3SseKmsKeyId("KMS_KEY_ID").setS3EncryptionMaterialsProvider("EMP_CLASS").setS3KmsKeyId("KEY_ID").setS3MaxClientRetries(9).setS3MaxErrorRetries(8).setS3MaxBackoffTime(new Duration(4.0, TimeUnit.MINUTES)).setS3MaxRetryTime(new Duration(20.0, TimeUnit.MINUTES)).setS3ConnectTimeout(new Duration(8.0, TimeUnit.SECONDS)).setS3ConnectTtl(new Duration(30.0, TimeUnit.MINUTES)).setS3SocketTimeout(new Duration(4.0, TimeUnit.MINUTES)).setS3MultipartMinFileSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3MultipartMinPartSize(DataSize.of((long)15L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3MaxConnections(77).setS3StagingDirectory(stagingDirectory.toFile()).setPinS3ClientToCurrentRegion(true).setS3UserAgentPrefix("user-agent-prefix").setS3AclType(TrinoS3AclType.PUBLIC_READ).setSkipGlacierObjects(true).setRequesterPaysEnabled(true).setS3StreamingUploadEnabled(false).setS3StreamingPartSize(DataSize.of((long)15L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setS3ProxyHost("localhost").setS3ProxyPort(14000).setS3ProxyProtocol("HTTP").setS3NonProxyHosts((List)ImmutableList.of((Object)"test", (Object)"test2", (Object)"test3")).setS3ProxyUsername("test").setS3ProxyPassword("test").setS3PreemptiveBasicProxyAuth(true).setS3StsEndpoint("http://minio:9000").setS3StsRegion("eu-central-1");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

