/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hdfs.DynamicConfigurationProvider;
import io.trino.hdfs.HdfsContext;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.s3.FileBasedS3SecurityMappingsProvider;
import io.trino.plugin.hive.s3.S3SecurityMapping;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.S3SecurityMappingConfigurationProvider;
import io.trino.plugin.hive.s3.S3SecurityMappingsProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.testing.TestingConnectorSession;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SecurityMapping {
    private static final HiveSessionProperties HIVE_SESSION_PROPERTIES = HiveTestUtils.getHiveSessionProperties(new HiveConfig());
    private static final String IAM_ROLE_CREDENTIAL_NAME = "IAM_ROLE_CREDENTIAL_NAME";
    private static final String KMS_KEY_ID_CREDENTIAL_NAME = "KMS_KEY_ID_CREDENTIAL_NAME";
    private static final String DEFAULT_PATH = "s3://default";
    private static final String DEFAULT_USER = "testuser";

    @Test
    public void testMapping() {
        S3SecurityMappingConfig mappingConfig = new S3SecurityMappingConfig().setConfigFilePath(Resources.getResource(this.getClass(), (String)"security-mapping.json").getPath()).setRoleCredentialName(IAM_ROLE_CREDENTIAL_NAME).setKmsKeyIdCredentialName(KMS_KEY_ID_CREDENTIAL_NAME).setColonReplacement("#");
        S3SecurityMappingConfigurationProvider provider = new S3SecurityMappingConfigurationProvider(mappingConfig, (S3SecurityMappingsProvider)new FileBasedS3SecurityMappingsProvider(mappingConfig));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo/data/test.csv"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_10"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_10"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo").withExtraCredentialKmsKeyId("kmsKey_10"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_10"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo").withExtraCredentialKmsKeyId("kmsKey_11"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_11"));
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo").withExtraCredentialKmsKeyId("kmsKey_not_allowed"), "Selected KMS Key ID is not allowed");
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo_all_keys_allowed").withExtraCredentialKmsKeyId("kmsKey_777"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_777"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://foo_no_default_key").withExtraCredentialKmsKeyId("kmsKey_12"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withKmsKeyId("kmsKey_12"));
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/test"), "No S3 role selected and mapping has no default role");
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/test").withExtraCredentialIamRole("arn:aws:iam::123456789101:role/allow_bucket_2"), MappingResult.role("arn:aws:iam::123456789101:role/allow_bucket_2"));
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/test").withUser("bob").withExtraCredentialIamRole("bogus"), "Selected S3 role is not allowed: bogus");
        String roleWithoutColon = "arn#aws#iam##123456789101#role/allow_bucket_2";
        Assertions.assertThat((String)roleWithoutColon).doesNotContain(new CharSequence[]{":"});
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/test").withExtraCredentialIamRole(roleWithoutColon), MappingResult.role("arn:aws:iam::123456789101:role/allow_bucket_2"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/abc/data/test.csv"), MappingResult.role("arn:aws:iam::123456789101:role/allow_path"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty(), MappingResult.role("arn:aws:iam::123456789101:role/default"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://xyz/default"), MappingResult.role("arn:aws:iam::123456789101:role/allow_default"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://xyz/foo").withExtraCredentialIamRole("arn:aws:iam::123456789101:role/allow_foo"), MappingResult.role("arn:aws:iam::123456789101:role/allow_foo"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://xyz/bar").withExtraCredentialIamRole("arn:aws:iam::123456789101:role/allow_bar"), MappingResult.role("arn:aws:iam::123456789101:role/allow_bar"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("alice"), MappingResult.role("alice_role"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("alice").withExtraCredentialIamRole("alice_role"), MappingResult.role("alice_role"));
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("alice").withExtraCredentialIamRole("bogus"), "Selected S3 role is not allowed: bogus");
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/test").withUser("alice").withExtraCredentialIamRole("alice_role"), "Selected S3 role is not allowed: alice_role");
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("bob"), MappingResult.role("bob_and_charlie_role"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withGroups("finance"), MappingResult.role("finance_role"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withGroups("eng"), MappingResult.role("hr_and_eng_group"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("danny"), MappingResult.role("arn:aws:iam::123456789101:role/default"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withGroups("hq"), MappingResult.role("arn:aws:iam::123456789101:role/default"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty().withUser("danny").withGroups("hq"), MappingResult.role("danny_hq_role"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://endpointbucket/bar"), MappingResult.credentials("AKIAxxxaccess", "iXbXxxxsecret").withEndpoint("http://localhost:7753"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://somebucket"), MappingResult.role("arn:aws:iam::1234567891012:role/default").withRoleSessionName("iam-trino-session"));
    }

    @Test
    public void testMappingWithFallbackToClusterDefault() {
        S3SecurityMappingConfig mappingConfig = new S3SecurityMappingConfig().setConfigFilePath(Resources.getResource(this.getClass(), (String)"security-mapping-with-fallback-to-cluster-default.json").getPath());
        S3SecurityMappingConfigurationProvider provider = new S3SecurityMappingConfigurationProvider(mappingConfig, (S3SecurityMappingsProvider)new FileBasedS3SecurityMappingsProvider(mappingConfig));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/abc/data/test.csv"), MappingResult.role("arn:aws:iam::123456789101:role/allow_path"));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.empty(), MappingResult.clusterDefaultRole());
    }

    @Test
    public void testMappingWithoutFallback() {
        S3SecurityMappingConfig mappingConfig = new S3SecurityMappingConfig().setConfigFilePath(Resources.getResource(this.getClass(), (String)"security-mapping-without-fallback.json").getPath());
        S3SecurityMappingConfigurationProvider provider = new S3SecurityMappingConfigurationProvider(mappingConfig, (S3SecurityMappingsProvider)new FileBasedS3SecurityMappingsProvider(mappingConfig));
        TestS3SecurityMapping.assertMapping((DynamicConfigurationProvider)provider, MappingSelector.path("s3://bar/abc/data/test.csv"), MappingResult.role("arn:aws:iam::123456789101:role/allow_path"));
        TestS3SecurityMapping.assertMappingFails((DynamicConfigurationProvider)provider, MappingSelector.empty(), "No matching S3 security mapping");
    }

    @Test
    public void testMappingWithoutRoleCredentialsFallbackShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new S3SecurityMapping(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("must either allow useClusterDefault role or provide role and/or credentials");
    }

    @Test
    public void testMappingWithRoleAndFallbackShouldFail() {
        Optional<String> iamRole = Optional.of("arn:aws:iam::123456789101:role/allow_path");
        Optional<Boolean> useClusterDefault = Optional.of(true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new S3SecurityMapping(Optional.empty(), Optional.empty(), Optional.empty(), iamRole, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), useClusterDefault, Optional.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("must either allow useClusterDefault role or provide role and/or credentials");
    }

    @Test
    public void testMappingWithEncryptionKeysAndFallbackShouldFail() {
        Optional<Boolean> useClusterDefault = Optional.of(true);
        Optional<String> kmsKeyId = Optional.of("CLIENT_S3CRT_KEY_ID");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new S3SecurityMapping(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), kmsKeyId, Optional.empty(), Optional.empty(), Optional.empty(), useClusterDefault, Optional.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("KMS key ID cannot be provided together with useClusterDefault");
    }

    @Test
    public void testMappingWithRoleSessionNameWithoutIamRoleShouldFail() {
        Optional<String> roleSessionName = Optional.of("iam-trino-session");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new S3SecurityMapping(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), roleSessionName, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty())).isInstanceOf(IllegalArgumentException.class)).hasMessage("iamRole must be provided when roleSessionName is provided");
    }

    private static void assertMapping(DynamicConfigurationProvider provider, MappingSelector selector, MappingResult mappingResult) {
        Configuration configuration = ConfigurationInstantiator.newEmptyConfiguration();
        Assert.assertNull((Object)configuration.get("trino.s3.access-key"));
        Assert.assertNull((Object)configuration.get("trino.s3.secret-key"));
        Assert.assertNull((Object)configuration.get("trino.s3.iam-role"));
        Assert.assertNull((Object)configuration.get("trino.s3.kms-key-id"));
        TestS3SecurityMapping.applyMapping(provider, selector, configuration);
        Assert.assertEquals((String)configuration.get("trino.s3.access-key"), (String)mappingResult.getAccessKey().orElse(null));
        Assert.assertEquals((String)configuration.get("trino.s3.secret-key"), (String)mappingResult.getSecretKey().orElse(null));
        Assert.assertEquals((String)configuration.get("trino.s3.iam-role"), (String)mappingResult.getRole().orElse(null));
        Assert.assertEquals((String)configuration.get("trino.s3.kms-key-id"), (String)mappingResult.getKmsKeyId().orElse(null));
        Assert.assertEquals((String)configuration.get("trino.s3.endpoint"), (String)mappingResult.getEndpoint().orElse(null));
        Assert.assertEquals((String)configuration.get("trino.s3.role-session-name"), (String)mappingResult.getRoleSessionName().orElse(null));
    }

    private static void assertMappingFails(DynamicConfigurationProvider provider, MappingSelector selector, String message) {
        Configuration configuration = ConfigurationInstantiator.newEmptyConfiguration();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestS3SecurityMapping.applyMapping(provider, selector, configuration)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: " + message);
    }

    private static void applyMapping(DynamicConfigurationProvider provider, MappingSelector selector, Configuration configuration) {
        provider.updateConfiguration(configuration, selector.getHdfsContext(), selector.getPath().toUri());
    }

    public static class MappingSelector {
        private final String user;
        private final Set<String> groups;
        private final Path path;
        private final Optional<String> extraCredentialIamRole;
        private final Optional<String> extraCredentialKmsKeyId;

        public static MappingSelector empty() {
            return MappingSelector.path(TestS3SecurityMapping.DEFAULT_PATH);
        }

        public static MappingSelector path(String path) {
            return new MappingSelector(TestS3SecurityMapping.DEFAULT_USER, (Set<String>)ImmutableSet.of(), new Path(path), Optional.empty(), Optional.empty());
        }

        private MappingSelector(String user, Set<String> groups, Path path, Optional<String> extraCredentialIamRole, Optional<String> extraCredentialKmsKeyId) {
            this.user = Objects.requireNonNull(user, "user is null");
            this.groups = ImmutableSet.copyOf((Collection)Objects.requireNonNull(groups, "groups is null"));
            this.path = Objects.requireNonNull(path, "path is null");
            this.extraCredentialIamRole = Objects.requireNonNull(extraCredentialIamRole, "extraCredentialIamRole is null");
            this.extraCredentialKmsKeyId = Objects.requireNonNull(extraCredentialKmsKeyId, "extraCredentialKmsKeyId is null");
        }

        public Path getPath() {
            return this.path;
        }

        public MappingSelector withExtraCredentialIamRole(String role) {
            return new MappingSelector(this.user, this.groups, this.path, Optional.of(role), this.extraCredentialKmsKeyId);
        }

        public MappingSelector withExtraCredentialKmsKeyId(String kmsKeyId) {
            return new MappingSelector(this.user, this.groups, this.path, this.extraCredentialIamRole, Optional.of(kmsKeyId));
        }

        public MappingSelector withUser(String user) {
            return new MappingSelector(user, this.groups, this.path, this.extraCredentialIamRole, this.extraCredentialKmsKeyId);
        }

        public MappingSelector withGroups(String ... groups) {
            return new MappingSelector(this.user, (Set<String>)ImmutableSet.copyOf((Object[])groups), this.path, this.extraCredentialIamRole, this.extraCredentialKmsKeyId);
        }

        public HdfsContext getHdfsContext() {
            ImmutableMap.Builder extraCredentials = ImmutableMap.builder();
            this.extraCredentialIamRole.ifPresent(role -> extraCredentials.put((Object)TestS3SecurityMapping.IAM_ROLE_CREDENTIAL_NAME, role));
            this.extraCredentialKmsKeyId.ifPresent(kmsKeyId -> extraCredentials.put((Object)TestS3SecurityMapping.KMS_KEY_ID_CREDENTIAL_NAME, kmsKeyId));
            TestingConnectorSession connectorSession = TestingConnectorSession.builder().setIdentity(ConnectorIdentity.forUser((String)this.user).withGroups(this.groups).withExtraCredentials((Map)extraCredentials.buildOrThrow()).build()).setPropertyMetadata(HIVE_SESSION_PROPERTIES.getSessionProperties()).build();
            return new HdfsContext((ConnectorSession)connectorSession);
        }
    }

    public static class MappingResult {
        private final Optional<String> accessKey;
        private final Optional<String> secretKey;
        private final Optional<String> role;
        private final Optional<String> kmsKeyId;
        private final Optional<String> endpoint;
        private final Optional<String> roleSessionName;

        public static MappingResult credentials(String accessKey, String secretKey) {
            return new MappingResult(Optional.of(accessKey), Optional.of(secretKey), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public static MappingResult role(String role) {
            return new MappingResult(Optional.empty(), Optional.empty(), Optional.of(role), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public static MappingResult clusterDefaultRole() {
            return new MappingResult(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public static MappingResult endpoint(String endpoint) {
            return new MappingResult(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(endpoint), Optional.empty());
        }

        private MappingResult(Optional<String> accessKey, Optional<String> secretKey, Optional<String> role, Optional<String> kmsKeyId, Optional<String> endpoint, Optional<String> roleSessionName) {
            this.accessKey = Objects.requireNonNull(accessKey, "accessKey is null");
            this.secretKey = Objects.requireNonNull(secretKey, "secretKey is null");
            this.role = Objects.requireNonNull(role, "role is null");
            this.kmsKeyId = Objects.requireNonNull(kmsKeyId, "kmsKeyId is null");
            this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
            this.roleSessionName = Objects.requireNonNull(roleSessionName, "roleSessionName is null");
        }

        public MappingResult withEndpoint(String endpoint) {
            return new MappingResult(this.accessKey, this.secretKey, this.role, this.kmsKeyId, Optional.of(endpoint), Optional.empty());
        }

        public MappingResult withKmsKeyId(String kmsKeyId) {
            return new MappingResult(this.accessKey, this.secretKey, this.role, Optional.of(kmsKeyId), this.endpoint, Optional.empty());
        }

        public MappingResult withRoleSessionName(String roleSessionName) {
            return new MappingResult(this.accessKey, this.secretKey, this.role, this.kmsKeyId, Optional.empty(), Optional.of(roleSessionName));
        }

        public Optional<String> getAccessKey() {
            return this.accessKey;
        }

        public Optional<String> getSecretKey() {
            return this.secretKey;
        }

        public Optional<String> getRole() {
            return this.role;
        }

        public Optional<String> getKmsKeyId() {
            return this.kmsKeyId;
        }

        public Optional<String> getEndpoint() {
            return this.endpoint;
        }

        public Optional<String> getRoleSessionName() {
            return this.roleSessionName;
        }
    }
}

