/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestS3SecurityMappingConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((S3SecurityMappingConfig)ConfigAssertions.recordDefaults(S3SecurityMappingConfig.class)).setJsonPointer("").setConfigFilePath(null).setRoleCredentialName(null).setKmsKeyIdCredentialName(null).setRefreshPeriod(null).setColonReplacement(null));
    }

    @Test
    public void testExplicitPropertyMappingsWithFile() throws IOException {
        Path securityMappingConfigFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.s3.security-mapping.config-file", (Object)securityMappingConfigFile.toString()).put((Object)"hive.s3.security-mapping.json-pointer", (Object)"/data").put((Object)"hive.s3.security-mapping.iam-role-credential-name", (Object)"iam-role-credential-name").put((Object)"hive.s3.security-mapping.kms-key-id-credential-name", (Object)"kms-key-id-credential-name").put((Object)"hive.s3.security-mapping.refresh-period", (Object)"1s").put((Object)"hive.s3.security-mapping.colon-replacement", (Object)"#").buildOrThrow();
        S3SecurityMappingConfig expected = new S3SecurityMappingConfig().setConfigFilePath(securityMappingConfigFile.toString()).setJsonPointer("/data").setRoleCredentialName("iam-role-credential-name").setKmsKeyIdCredentialName("kms-key-id-credential-name").setRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS)).setColonReplacement("#");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testExplicitPropertyMappingsWithUrl() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"hive.s3.security-mapping.config-file", (Object)"http://test:1234/example").put((Object)"hive.s3.security-mapping.json-pointer", (Object)"/data").put((Object)"hive.s3.security-mapping.iam-role-credential-name", (Object)"iam-role-credential-name").put((Object)"hive.s3.security-mapping.kms-key-id-credential-name", (Object)"kms-key-id-credential-name").put((Object)"hive.s3.security-mapping.refresh-period", (Object)"1s").put((Object)"hive.s3.security-mapping.colon-replacement", (Object)"#").buildOrThrow();
        S3SecurityMappingConfig expected = new S3SecurityMappingConfig().setConfigFilePath("http://test:1234/example").setJsonPointer("/data").setRoleCredentialName("iam-role-credential-name").setKmsKeyIdCredentialName("kms-key-id-credential-name").setRefreshPeriod(new Duration(1.0, TimeUnit.SECONDS)).setColonReplacement("#");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

