/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.S3SecurityMappings;
import io.trino.plugin.hive.s3.S3SecurityMappingsParser;
import io.trino.spi.security.ConnectorIdentity;
import java.net.URI;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SecurityMappingsParser {
    @Test
    public void testParse() {
        S3SecurityMappingConfig conf = new S3SecurityMappingConfig().setJsonPointer("/data");
        S3SecurityMappingsParser provider = new S3SecurityMappingsParser(conf);
        S3SecurityMappings mappings = provider.parseJSONString("{\"data\": {\"mappings\": [{\"iamRole\":\"arn:aws:iam::test\",\"user\":\"test\"}]}, \"time\": \"30s\"}");
        Optional mapping = mappings.getMapping(ConnectorIdentity.ofUser((String)"test"), URI.create("http://trino"));
        Assert.assertTrue((boolean)mapping.isPresent());
    }

    @Test
    public void testParseDefault() {
        S3SecurityMappingConfig conf = new S3SecurityMappingConfig();
        S3SecurityMappingsParser provider = new S3SecurityMappingsParser(conf);
        S3SecurityMappings mappings = provider.parseJSONString("{\"mappings\": [{\"iamRole\":\"arn:aws:iam::test\",\"user\":\"test\"}]}");
        Optional mapping = mappings.getMapping(ConnectorIdentity.ofUser((String)"test"), URI.create("http://trino"));
        Assert.assertTrue((boolean)mapping.isPresent());
    }
}

