/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestS3WrongRegionPicked {
    @Test
    public void testS3WrongRegionSelection() throws Exception {
        String bucketName = "test-bucket" + TestingNames.randomNameSuffix();
        try (HiveMinioDataLake dataLake = new HiveMinioDataLake(bucketName);){
            dataLake.start();
            try (DistributedQueryRunner queryRunner = ((S3HiveQueryRunner.Builder)((Object)S3HiveQueryRunner.builder(dataLake).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.s3.region", (Object)"eu-central-1")))).build();){
                String tableName = "s3_region_test_" + TestingNames.randomNameSuffix();
                queryRunner.execute("CREATE TABLE default." + tableName + " (a int) WITH (external_location = 's3://" + bucketName + "/" + tableName + "')");
                Assertions.assertThatThrownBy(() -> TestS3WrongRegionPicked.lambda$testS3WrongRegionSelection$0((QueryRunner)queryRunner, tableName)).rootCause().hasMessageContaining("Status Code: 400").hasMessageContaining("Error Code: AuthorizationHeaderMalformed");
            }
        }
    }

    private static /* synthetic */ void lambda$testS3WrongRegionSelection$0(QueryRunner queryRunner, String tableName) throws Throwable {
        queryRunner.execute("SELECT * FROM default." + tableName);
    }
}

