/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.amazonaws.services.s3.AmazonS3;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.s3.BaseTestTrinoS3FileSystemObjectStorage;
import io.trino.plugin.hive.s3.TrinoS3FileSystem;
import io.trino.testing.TestingNames;
import io.trino.testing.containers.Minio;
import io.trino.testing.minio.MinioClient;
import io.trino.util.AutoCloseableCloser;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTrinoS3FileSystemMinio
extends BaseTestTrinoS3FileSystemObjectStorage {
    private final String bucketName = "trino-ci-test";
    private Minio minio;
    private MinioClient minioClient;

    @BeforeClass
    public void setup() throws Exception {
        this.minio = Minio.builder().build();
        this.minio.start();
        this.minioClient = this.minio.createMinioClient();
        this.minio.createBucket("trino-ci-test");
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        try (AutoCloseableCloser closer = AutoCloseableCloser.create();){
            closer.register((AutoCloseable)this.minio);
            closer.register((AutoCloseable)this.minioClient);
        }
        this.minioClient = null;
        this.minio = null;
    }

    @Override
    protected String getBucketName() {
        return "trino-ci-test";
    }

    @Override
    protected Configuration s3Configuration() {
        Configuration config = ConfigurationInstantiator.newEmptyConfiguration();
        config.set("trino.s3.endpoint", this.minio.getMinioAddress());
        config.set("trino.s3.access-key", "accesskey");
        config.set("trino.s3.secret-key", "secretkey");
        config.set("trino.s3.path-style-access", "true");
        return config;
    }

    @Test
    public void testDeleteNonRecursivelyEmptyBucketRoot() throws Exception {
        String testBucketName = "trino-delete-bucket-root-empty" + TestingNames.randomNameSuffix();
        this.minioClient.makeBucket(testBucketName);
        String testBucketPath = "s3://%s/".formatted(testBucketName);
        try (TrinoS3FileSystem fs = new TrinoS3FileSystem();){
            fs.initialize(new URI(testBucketPath), this.s3Configuration());
            AmazonS3 s3 = fs.getS3Client();
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).isEmpty();
            fs.delete(new Path(testBucketPath), false);
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).isEmpty();
        }
    }

    @Test
    public void testDeleteNonRecursivelyNonEmptyBucketRoot() throws Exception {
        String testBucketName = "trino-delete-bucket-root-non-empty" + TestingNames.randomNameSuffix();
        this.minioClient.makeBucket(testBucketName);
        String testBucketPath = "s3://%s/".formatted(testBucketName);
        try (TrinoS3FileSystem fs = new TrinoS3FileSystem();){
            fs.initialize(new URI(testBucketPath), this.s3Configuration());
            AmazonS3 s3 = fs.getS3Client();
            fs.createNewFile(new Path("s3://%s/file1.txt".formatted(testBucketName)));
            String directory2Path = testBucketPath + "directory2";
            TestTrinoS3FileSystemMinio.createDirectory(fs.getS3Client(), testBucketName, "directory2");
            String filename2 = "file2.txt";
            fs.createNewFile(new Path(directory2Path, filename2));
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).containsOnly((Object[])new String[]{"file1.txt", "directory2/", "directory2/file2.txt"});
            Assertions.assertThatThrownBy(() -> fs.delete(new Path(testBucketPath), false)).hasMessage("Directory %s is not empty".formatted(testBucketPath));
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).containsOnly((Object[])new String[]{"file1.txt", "directory2/", "directory2/file2.txt"});
        }
    }

    @Test
    public void testDeleteRecursivelyBucketRoot() throws Exception {
        String testBucketName = "trino-delete-recursive-bucket-root" + TestingNames.randomNameSuffix();
        this.minioClient.makeBucket(testBucketName);
        String testBucketPath = "s3://" + testBucketName;
        try (TrinoS3FileSystem fs = new TrinoS3FileSystem();){
            fs.initialize(new URI(testBucketPath), this.s3Configuration());
            AmazonS3 s3 = fs.getS3Client();
            fs.createNewFile(new Path("s3://%s/file1.txt".formatted(testBucketName)));
            String directory2Path = testBucketPath + "/directory2";
            TestTrinoS3FileSystemMinio.createDirectory(fs.getS3Client(), testBucketName, "directory2");
            fs.createNewFile(new Path(directory2Path, "file2.txt"));
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).containsOnly((Object[])new String[]{"file1.txt", "directory2/", "directory2/file2.txt"});
            Assert.assertTrue((boolean)fs.delete(new Path(testBucketPath + "/"), true));
            Assertions.assertThat(TestTrinoS3FileSystemMinio.listPaths(s3, testBucketName, "", true)).isEmpty();
        }
    }
}

