/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.net.MediaType;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.trino.plugin.hive.s3.S3SecurityMappingConfig;
import io.trino.plugin.hive.s3.UriBasedS3SecurityMappingsProvider;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUriBasedS3SecurityMappingsProvider {
    private static final String MOCK_MAPPINGS_RESPONSE = "{\"mappings\": [{\"iamRole\":\"arn:aws:iam::test\",\"user\":\"test\"}]}";

    @Test
    public void testGetRawJSON() {
        Response response = TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)MOCK_MAPPINGS_RESPONSE);
        S3SecurityMappingConfig conf = new S3SecurityMappingConfig().setConfigFilePath("http://test:1234/api/endpoint");
        UriBasedS3SecurityMappingsProvider provider = new UriBasedS3SecurityMappingsProvider(conf, (HttpClient)new TestingHttpClient(request -> response));
        String result = provider.getRawJsonString();
        Assert.assertEquals((String)result, (String)MOCK_MAPPINGS_RESPONSE);
    }
}

