/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.s3select.IonSqlQueryBuilder;
import io.trino.plugin.hive.s3select.S3SelectDataType;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import io.trino.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestIonSqlQueryBuilder {
    @Test
    public void testBuildSQL() {
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"n_nationkey", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"n_name", (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"n_regionkey", (int)2, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.CSV);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, TupleDomain.all()), (String)"SELECT s._1, s._2, s._3 FROM S3Object s");
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L))), (boolean)false)));
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE (case s._3 when '' then null else CAST(s._3 AS INT) end = 3)");
        queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, TupleDomain.all()), (String)"SELECT s.n_nationkey, s.n_name, s.n_regionkey FROM S3Object s");
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.n_nationkey, s.n_name, s.n_regionkey FROM S3Object s WHERE (case s.n_regionkey when '' then null else CAST(s.n_regionkey AS INT) end = 3)");
    }

    @Test
    public void testEmptyColumns() {
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.CSV);
        Assert.assertEquals((String)queryBuilder.buildSql((List)ImmutableList.of(), TupleDomain.all()), (String)"SELECT ' ' FROM S3Object s");
        queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)ImmutableList.of(), TupleDomain.all()), (String)"SELECT ' ' FROM S3Object s");
    }

    @Test
    public void testDecimalColumns() {
        TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"quantity", (int)0, (HiveType)HiveType.valueOf((String)"decimal(20,0)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"extendedprice", (int)1, (HiveType)HiveType.valueOf((String)"decimal(20,2)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"discount", (int)2, (HiveType)HiveType.valueOf((String)"decimal(10,2)"), (Type)DecimalType.createDecimalType(), (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        DecimalType decimalType = DecimalType.createDecimalType((int)10, (int)2);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(0)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DecimalType.createDecimalType((int)20, (int)0), (Object)HiveTestUtils.longDecimal("50")), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)HiveType.valueOf((String)"decimal(20,2)").getType(typeManager), (Object)HiveTestUtils.longDecimal("0.05")), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)decimalType, (Object)HiveTestUtils.shortDecimal("0.0"), (boolean)true, (Object)HiveTestUtils.shortDecimal("0.02"), (boolean)true), (Range[])new Range[0]), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(typeManager, S3SelectDataType.CSV);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS DECIMAL(20,0)) end < 50)) AND (case s._2 when '' then null else CAST(s._2 AS DECIMAL(20,2)) end = 0.05) AND ((case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end >= 0.00 AND case s._3 when '' then null else CAST(s._3 AS DECIMAL(10,2)) end <= 0.02))");
        queryBuilder = new IonSqlQueryBuilder(typeManager, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.quantity, s.extendedprice, s.discount FROM S3Object s WHERE ((case s.quantity when '' then null else CAST(s.quantity AS DECIMAL(20,0)) end < 50)) AND (case s.extendedprice when '' then null else CAST(s.extendedprice AS DECIMAL(20,2)) end = 0.05) AND ((case s.discount when '' then null else CAST(s.discount AS DECIMAL(10,2)) end >= 0.00 AND case s.discount when '' then null else CAST(s.discount AS DECIMAL(10,2)) end <= 0.02))");
    }

    @Test
    public void testDateColumn() {
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"t1", (int)0, (HiveType)HiveType.HIVE_TIMESTAMP, (Type)TimestampType.TIMESTAMP_MILLIS, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"t2", (int)1, (HiveType)HiveType.HIVE_DATE, (Type)DateType.DATE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)DateType.DATE, (List)ImmutableList.of((Object)Range.equal((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2001-08-22")))), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.CSV);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s._1, s._2 FROM S3Object s WHERE (case s._2 when '' then null else CAST(s._2 AS TIMESTAMP) end = `2001-08-22`)");
        queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.t1, s.t2 FROM S3Object s WHERE (case s.t2 when '' then null else CAST(s.t2 AS TIMESTAMP) end = `2001-08-22`)");
    }

    @Test
    public void testNotPushDoublePredicates() {
        ImmutableList columns = ImmutableList.of((Object)HiveColumnHandle.createBaseColumn((String)"quantity", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"extendedprice", (int)1, (HiveType)HiveType.HIVE_DOUBLE, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()), (Object)HiveColumnHandle.createBaseColumn((String)"discount", (int)2, (HiveType)HiveType.HIVE_DOUBLE, (Type)DoubleType.DOUBLE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)((HiveColumnHandle)columns.get(0)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)50L), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)DoubleType.DOUBLE, (Object)0.05), (Range[])new Range[0]), (boolean)false), (Object)((HiveColumnHandle)columns.get(2)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)0.02, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        IonSqlQueryBuilder queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.CSV);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s._1, s._2, s._3 FROM S3Object s WHERE ((case s._1 when '' then null else CAST(s._1 AS INT) end < 50))");
        queryBuilder = new IonSqlQueryBuilder(InternalTypeManager.TESTING_TYPE_MANAGER, S3SelectDataType.JSON);
        Assert.assertEquals((String)queryBuilder.buildSql((List)columns, tupleDomain), (String)"SELECT s.quantity, s.extendedprice, s.discount FROM S3Object s WHERE ((case s.quantity when '' then null else CAST(s.quantity AS INT) end < 50))");
    }
}

