/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Partition;
import io.trino.plugin.hive.metastore.Storage;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.s3select.S3SelectPushdown;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import io.trino.testing.TestingConnectorSession;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hive.hcatalog.data.JsonSerDe;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestS3SelectPushdown {
    private static final String S3_SELECT_PUSHDOWN_ENABLED = "s3_select_pushdown_enabled";
    private TextInputFormat inputFormat;
    private ConnectorSession session;
    private Table table;
    private Partition partition;
    private Storage storage;
    private Column column;
    private Properties schema;

    @BeforeClass
    public void setUp() {
        this.inputFormat = new TextInputFormat();
        this.inputFormat.configure(new JobConf(ConfigurationInstantiator.newEmptyConfiguration()));
        this.session = TestingConnectorSession.builder().setPropertyMetadata(List.of(PropertyMetadata.booleanProperty((String)S3_SELECT_PUSHDOWN_ENABLED, (String)"S3 Select pushdown enabled", (Boolean)true, (boolean)false))).setPropertyValues(Map.of(S3_SELECT_PUSHDOWN_ENABLED, true)).build();
        this.column = new Column("column", HiveType.HIVE_BOOLEAN, Optional.empty());
        this.storage = Storage.builder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.TEXTFILE)).setLocation("location").build();
        this.partition = new Partition("db", "table", Collections.emptyList(), this.storage, Collections.singletonList(this.column), Collections.emptyMap());
        this.table = new Table("db", "table", Optional.of("owner"), "type", this.storage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty(), OptionalLong.empty());
        this.schema = new Properties();
        this.schema.setProperty("serialization.lib", LazySimpleSerDe.class.getName());
    }

    @Test
    public void testIsCompressionCodecSupported() {
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.gz")));
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.lz4")));
        Assert.assertFalse((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.snappy")));
        Assert.assertTrue((boolean)S3SelectPushdown.isCompressionCodecSupported((InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.bz2")));
    }

    @Test
    public void testShouldEnableSelectPushdown() {
        Assert.assertTrue((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Assert.assertTrue((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3://fakeBucket/fakeObject", Optional.of(this.partition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenDisabledOnSession() {
        TestingConnectorSession testSession = TestingConnectorSession.builder().setPropertyMetadata(List.of(PropertyMetadata.booleanProperty((String)S3_SELECT_PUSHDOWN_ENABLED, (String)"S3 Select pushdown enabled", (Boolean)false, (boolean)false))).setPropertyValues(Map.of(S3_SELECT_PUSHDOWN_ENABLED, false)).build();
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)testSession, (Table)this.table, (String)"", Optional.empty()));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenIsNotS3StoragePath() {
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, null, Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"", Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3:/invalid", Optional.empty()));
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)this.table, (String)"s3:/invalid", Optional.of(this.partition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenIsNotSupportedSerde() {
        Storage newStorage = Storage.builder().setStorageFormat(StorageFormat.fromHiveStorageFormat((HiveStorageFormat)HiveStorageFormat.ORC)).setLocation("location").build();
        Table newTable = new Table("db", "table", Optional.of("owner"), "type", newStorage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty(), OptionalLong.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Partition newPartition = new Partition("db", "table", Collections.emptyList(), newStorage, Collections.singletonList(this.column), Collections.emptyMap());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.of(newPartition)));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenIsNotSupportedInputFormat() {
        Storage newStorage = Storage.builder().setStorageFormat(StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)"inputFormat", (String)"outputFormat")).setLocation("location").build();
        Table newTable = new Table("db", "table", Optional.of("owner"), "type", newStorage, Collections.singletonList(this.column), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty(), OptionalLong.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Partition newPartition = new Partition("db", "table", Collections.emptyList(), newStorage, Collections.singletonList(this.column), Collections.emptyMap());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.of(newPartition)));
        newStorage = Storage.builder().setStorageFormat(StorageFormat.create((String)LazySimpleSerDe.class.getName(), (String)TextInputFormat.class.getName(), (String)"outputFormat")).setLocation("location").build();
        newTable = new Table("db", "table", Optional.of("owner"), "type", newStorage, Collections.singletonList(this.column), Collections.emptyList(), Map.of("skip.header.line.count", "1"), Optional.empty(), Optional.empty(), OptionalLong.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        newTable = new Table("db", "table", Optional.of("owner"), "type", newStorage, Collections.singletonList(this.column), Collections.emptyList(), Map.of("skip.footer.line.count", "1"), Optional.empty(), Optional.empty(), OptionalLong.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
    }

    @Test
    public void testShouldNotEnableSelectPushdownWhenColumnTypesAreNotSupported() {
        Column newColumn = new Column("column", HiveType.HIVE_BINARY, Optional.empty());
        Table newTable = new Table("db", "table", Optional.of("owner"), "type", this.storage, Collections.singletonList(newColumn), Collections.emptyList(), Collections.emptyMap(), Optional.empty(), Optional.empty(), OptionalLong.empty());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.empty()));
        Partition newPartition = new Partition("db", "table", Collections.emptyList(), this.storage, Collections.singletonList(newColumn), Collections.emptyMap());
        Assert.assertFalse((boolean)S3SelectPushdown.shouldEnablePushdownForTable((ConnectorSession)this.session, (Table)newTable, (String)"s3://fakeBucket/fakeObject", Optional.of(newPartition)));
    }

    @Test
    public void testShouldEnableSplits() {
        Assert.assertTrue((boolean)S3SelectPushdown.isSplittable((boolean)true, (Properties)this.schema, (InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.csv")));
        Assert.assertTrue((boolean)S3SelectPushdown.isSplittable((boolean)false, (Properties)this.schema, (InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.csv")));
        Properties jsonSchema = new Properties();
        jsonSchema.setProperty("serialization.lib", JsonSerDe.class.getName());
        Assert.assertTrue((boolean)S3SelectPushdown.isSplittable((boolean)true, (Properties)jsonSchema, (InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.json")));
    }

    @Test
    public void testShouldNotEnableSplits() {
        Assert.assertFalse((boolean)S3SelectPushdown.isSplittable((boolean)true, (Properties)this.schema, (InputFormat)this.inputFormat, (Path)new Path("s3://fakeBucket/fakeObject.gz")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.inputFormat = null;
        this.session = null;
        this.table = null;
        this.partition = null;
        this.storage = null;
        this.column = null;
        this.schema = null;
    }
}

