/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.s3select.S3SelectRecordCursor;
import io.trino.plugin.hive.type.TypeInfo;
import io.trino.spi.type.DateType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SelectRecordCursor {
    private static final String LAZY_SERDE_CLASS_NAME = LazySimpleSerDe.class.getName();
    protected static final HiveColumnHandle ARTICLE_COLUMN = HiveColumnHandle.createBaseColumn((String)"article", (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    protected static final HiveColumnHandle AUTHOR_COLUMN = HiveColumnHandle.createBaseColumn((String)"author", (int)1, (HiveType)HiveType.HIVE_STRING, (Type)VarcharType.VARCHAR, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    protected static final HiveColumnHandle DATE_ARTICLE_COLUMN = HiveColumnHandle.createBaseColumn((String)"date_pub", (int)1, (HiveType)HiveType.HIVE_INT, (Type)DateType.DATE, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    protected static final HiveColumnHandle QUANTITY_COLUMN = HiveColumnHandle.createBaseColumn((String)"quantity", (int)1, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
    private static final HiveColumnHandle[] DEFAULT_TEST_COLUMNS = new HiveColumnHandle[]{ARTICLE_COLUMN, AUTHOR_COLUMN, DATE_ARTICLE_COLUMN, QUANTITY_COLUMN};

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLHasNoColumns() {
        String ddlSerializationValue = "struct article { }";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid Thrift DDL struct article \\{ \\}");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLNotStartingWithStruct() {
        String ddlSerializationValue = "foo article { varchar article varchar }";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Thrift DDL should start with struct");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenSerialDDLNotStartingWithStruct2() {
        String ddlSerializationValue = "struct article {varchar article}";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid Thrift DDL struct article \\{varchar article\\}");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenMissingOpenStartStruct() {
        String ddlSerializationValue = "struct article varchar article varchar }";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid Thrift DDL struct article varchar article varchar \\}");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenDDlFormatNotCorrect() {
        String ddlSerializationValue = "struct article{varchar article varchar author date date_pub int quantity";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid Thrift DDL struct article\\{varchar article varchar author date date_pub int quantity");
    }

    @Test
    public void shouldThrowIllegalArgumentExceptionWhenEndOfStructNotFound() {
        String ddlSerializationValue = "struct article { varchar article varchar author date date_pub int quantity ";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS)).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("Invalid Thrift DDL struct article \\{ varchar article varchar author date date_pub int quantity ");
    }

    @Test
    public void shouldFilterColumnsWhichDoesNotMatchInTheHiveTable() {
        String ddlSerializationValue = "struct article { varchar address varchar company date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnOnlyQuantityColumnInTheDDl() {
        String ddlSerializationValue = "struct article { varchar address varchar company date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, ARTICLE_COLUMN, QUANTITY_COLUMN), (Map)this.buildExpectedProperties(expectedDDLSerialization, ARTICLE_COLUMN, QUANTITY_COLUMN));
    }

    @Test
    public void shouldReturnProperties() {
        String ddlSerializationValue = "struct article { varchar article varchar author date date_pub int quantity}";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnPropertiesWithoutDoubleCommaInColumnsNameLastColumnNameWithEndStruct() {
        String ddlSerializationValue = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldReturnPropertiesWithoutDoubleCommaInColumnsNameLastColumnNameWithoutEndStruct() {
        String ddlSerializationValue = "struct article { varchar article, varchar author, date date_pub, int quantity }";
        String expectedDDLSerialization = "struct article { varchar article, varchar author, date date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldOnlyGetColumnTypeFromHiveObjectAndNotFromDDLSerialLastColumnNameWithEndStruct() {
        String ddlSerializationValue = "struct article { int article, double author, xxxx date_pub, int quantity}";
        String expectedDDLSerialization = "struct article { int article, double author, xxxx date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test
    public void shouldOnlyGetColumnTypeFromHiveObjectAndNotFromDDLSerialLastColumnNameWithoutEndStruct() {
        String ddlSerializationValue = "struct article { int article, double author, xxxx date_pub, int quantity }";
        String expectedDDLSerialization = "struct article { int article, double author, xxxx date_pub, int quantity}";
        Assert.assertEquals((Map)this.buildSplitSchema(ddlSerializationValue, DEFAULT_TEST_COLUMNS), (Map)this.buildExpectedProperties(expectedDDLSerialization, DEFAULT_TEST_COLUMNS));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void shouldThrowNullPointerExceptionWhenColumnsIsNull() {
        S3SelectRecordCursor.updateSplitSchema((Properties)new Properties(), null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void shouldThrowNullPointerExceptionWhenSchemaIsNull() {
        S3SelectRecordCursor.updateSplitSchema(null, (List)ImmutableList.of());
    }

    private Properties buildSplitSchema(String ddlSerializationValue, HiveColumnHandle ... columns) {
        Properties properties = new Properties();
        properties.setProperty("serialization.lib", LAZY_SERDE_CLASS_NAME);
        properties.setProperty("serialization.ddl", ddlSerializationValue);
        return S3SelectRecordCursor.updateSplitSchema((Properties)properties, Arrays.asList(columns));
    }

    private Properties buildExpectedProperties(String expectedDDLSerialization, HiveColumnHandle ... expectedColumns) {
        String expectedColumnsType = this.getTypes(expectedColumns);
        String expectedColumnsName = this.getName(expectedColumns);
        Properties propExpected = new Properties();
        propExpected.setProperty("columns", expectedColumnsName);
        propExpected.setProperty("serialization.lib", LAZY_SERDE_CLASS_NAME);
        propExpected.setProperty("serialization.ddl", expectedDDLSerialization);
        propExpected.setProperty("columns.types", expectedColumnsType);
        return propExpected;
    }

    private String getName(HiveColumnHandle[] expectedColumns) {
        return Stream.of(expectedColumns).map(HiveColumnHandle::getName).collect(Collectors.joining(","));
    }

    private String getTypes(HiveColumnHandle[] expectedColumns) {
        return Stream.of(expectedColumns).map(HiveColumnHandle::getHiveType).map(HiveType::getTypeInfo).map(TypeInfo::getTypeName).collect(Collectors.joining(","));
    }
}

