/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.hadoop.ConfigurationInstantiator;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveRecordCursorProvider;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.TestBackgroundHiveSplitLoader;
import io.trino.plugin.hive.s3select.S3SelectRecordCursorProvider;
import io.trino.plugin.hive.s3select.TestS3SelectRecordCursor;
import io.trino.plugin.hive.s3select.TrinoS3ClientFactory;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.type.InternalTypeManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestS3SelectRecordCursorProvider {
    @Test
    public void shouldReturnSelectRecordCursor() {
        ArrayList<HiveColumnHandle> readerColumns = new ArrayList<HiveColumnHandle>();
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, readerColumns, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnSelectRecordCursorWhenEffectivePredicateExists() {
        TupleDomain effectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)Domain.create((ValueSet)SortedRangeSet.copyOf((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)Range.equal((Type)BigintType.BIGINT, (Object)3L))), (boolean)false)));
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, TestS3SelectRecordCursorProvider.getAllColumns(), true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldReturnSelectRecordCursorWhenProjectionExists() {
        TupleDomain effectivePredicate = TupleDomain.all();
        ImmutableList readerColumns = ImmutableList.of((Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN, (Object)TestS3SelectRecordCursor.ARTICLE_COLUMN);
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, (List<HiveColumnHandle>)readerColumns, true);
        Assert.assertTrue((boolean)recordCursor.isPresent());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenPushdownIsDisabled() {
        ArrayList<HiveColumnHandle> readerColumns = new ArrayList<HiveColumnHandle>();
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, readerColumns, false);
        Assert.assertTrue((boolean)recordCursor.isEmpty());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenQueryIsNotFiltering() {
        TupleDomain effectivePredicate = TupleDomain.all();
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, TestS3SelectRecordCursorProvider.getAllColumns(), true);
        Assert.assertTrue((boolean)recordCursor.isEmpty());
    }

    @Test
    public void shouldNotReturnSelectRecordCursorWhenProjectionOrderIsDifferent() {
        TupleDomain effectivePredicate = TupleDomain.all();
        ImmutableList readerColumns = ImmutableList.of((Object)TestS3SelectRecordCursor.DATE_ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.QUANTITY_COLUMN, (Object)TestS3SelectRecordCursor.ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN);
        Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> recordCursor = TestS3SelectRecordCursorProvider.getRecordCursor((TupleDomain<HiveColumnHandle>)effectivePredicate, (List<HiveColumnHandle>)readerColumns, true);
        Assert.assertTrue((boolean)recordCursor.isEmpty());
    }

    private static Optional<HiveRecordCursorProvider.ReaderRecordCursorWithProjections> getRecordCursor(TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveColumnHandle> readerColumns, boolean s3SelectPushdownEnabled) {
        S3SelectRecordCursorProvider s3SelectRecordCursorProvider = new S3SelectRecordCursorProvider((HdfsEnvironment)new TestBackgroundHiveSplitLoader.TestingHdfsEnvironment(new ArrayList<LocatedFileStatus>()), new TrinoS3ClientFactory(new HiveConfig()));
        return s3SelectRecordCursorProvider.createRecordCursor(ConfigurationInstantiator.newEmptyConfiguration(), HiveTestUtils.SESSION, new Path("s3://fakeBucket/fakeObject.gz"), 0L, 10L, 10L, TestS3SelectRecordCursorProvider.createTestingSchema(), readerColumns, effectivePredicate, InternalTypeManager.TESTING_TYPE_MANAGER, s3SelectPushdownEnabled);
    }

    private static Properties createTestingSchema() {
        List<HiveColumnHandle> schemaColumns = TestS3SelectRecordCursorProvider.getAllColumns();
        Properties schema = new Properties();
        String columnNames = TestS3SelectRecordCursorProvider.buildPropertyFromColumns(schemaColumns, HiveColumnHandle::getName);
        String columnTypeNames = TestS3SelectRecordCursorProvider.buildPropertyFromColumns(schemaColumns, column -> column.getHiveType().getTypeInfo().getTypeName());
        schema.setProperty("columns", columnNames);
        schema.setProperty("columns.types", columnTypeNames);
        String deserializerClassName = LazySimpleSerDe.class.getName();
        schema.setProperty("serialization.lib", deserializerClassName);
        return schema;
    }

    private static String buildPropertyFromColumns(List<HiveColumnHandle> columns, Function<HiveColumnHandle, String> mapper) {
        if (columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(mapper).collect(Collectors.joining(","));
    }

    private static List<HiveColumnHandle> getAllColumns() {
        return ImmutableList.of((Object)TestS3SelectRecordCursor.ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.AUTHOR_COLUMN, (Object)TestS3SelectRecordCursor.DATE_ARTICLE_COLUMN, (Object)TestS3SelectRecordCursor.QUANTITY_COLUMN);
    }
}

